/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.modifier;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.modifier.PropertyModifier;
import com.aliyun.securitysdk.rass.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Constants;

public class Log4jModifier
implements PropertyModifier {
    private static final Logger logger = SecurityLogManager.getLogger(Log4jModifier.class);

    @Override
    public void modifyProperty() {
        this.modifyProperties();
        this.modifyConstants();
        this.removeJndi();
    }

    void modifyProperties() {
        AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty("log4j2.formatMsgNoLookups", "true");
            }
        });
        logger.info("Set log4j2.formatMsgNoLookups = true");
    }

    boolean modifyConstants() {
        try {
            Field field = ReflectionUtils.findField(Constants.class, "FORMAT_MESSAGES_PATTERN_DISABLE_LOOKUPS");
            field.setAccessible(true);
            ReflectionUtils.setFinalField(field, null, true);
            logger.info("Set log4j2 FORMAT_MESSAGES_PATTERN_DISABLE_LOOKUPS = true");
            return true;
        }
        catch (Exception ex) {
            logger.info("Failed to set FORMAT_MESSAGES_PATTERN_DISABLE_LOOKUPS");
            return false;
        }
    }

    void removeJndi() {
        org.apache.logging.log4j.spi.LoggerContext context = LogManager.getContext((boolean)false);
        if (context instanceof LoggerContext) {
            Configuration configuration = ((LoggerContext)context).getConfiguration();
            StrSubstitutor strSubstitutor = configuration.getStrSubstitutor();
            StrLookup variableResolver = strSubstitutor.getVariableResolver();
            if (this.removeJndiFromMap(variableResolver, "strLookupMap") || this.removeJndiFromMap(variableResolver, "lookups")) {
                logger.info("Success to remove log4j2 jndi plugin");
            } else {
                logger.info("Failed to remove log4j2 jndi plugin");
            }
        }
    }

    private boolean removeJndiFromMap(StrLookup variableResolver, String fieldName) {
        try {
            Field field = variableResolver.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Map map = (Map)field.get(variableResolver);
            map.remove("jndi");
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return false;
        }
    }
}

