/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.modifier;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.config.ConfigLoader;
import com.aliyun.securitysdk.rass.api.config.RassConfig;
import com.aliyun.securitysdk.rass.api.exception.RassSecurityException;
import com.aliyun.securitysdk.rass.api.util.StringUtils;
import com.aliyun.securitysdk.rass.config.schema.Serialization;
import com.aliyun.securitysdk.rass.modifier.PropertyModifier;
import com.aliyun.securitysdk.rass.resolver.transformer.Serialization2FastJsonRuleListTransformer;
import com.aliyun.securitysdk.rass.util.ClassUtils;
import com.aliyun.securitysdk.rass.util.CollectionUtils;
import com.aliyun.securitysdk.rass.util.FastJSONRuleList;
import com.aliyun.securitysdk.rass.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class FastJsonDenyListModifier
implements PropertyModifier {
    private static final Logger logger = SecurityLogManager.getLogger(FastJsonDenyListModifier.class);
    private static final FastJsonVersion VERSION_1_2_0 = new FastJsonVersion("1.2.0");
    private static final FastJsonVersion VERSION_1_2_9 = new FastJsonVersion("1.2.9");
    private static final FastJsonVersion VERSION_1_2_27 = new FastJsonVersion("1.2.27");
    private static final FastJsonVersion VERSION_1_2_42 = new FastJsonVersion("1.2.42");
    private Serialization serialization;
    private Serialization2FastJsonRuleListTransformer transformer;

    public FastJsonDenyListModifier(Serialization serialization) {
        this.serialization = serialization;
        this.transformer = new Serialization2FastJsonRuleListTransformer();
    }

    @Override
    public void modifyProperty() {
        if (!this.isFastJSONExists()) {
            return;
        }
        String fastJSONVersion = this.getFastJSONVersion();
        if (fastJSONVersion == null) {
            return;
        }
        FastJsonVersion version = new FastJsonVersion(fastJSONVersion);
        FastJSONRuleList ruleList = this.transformer.transform(this.serialization);
        List<String> denyListToAppend = ruleList.getDenyClasses();
        List<String> acceptListToAppend = ruleList.getAllowClasses();
        if (CollectionUtils.isEmpty(denyListToAppend) && CollectionUtils.isEmpty(acceptListToAppend)) {
            logger.info("No deny or accept lists to append.");
            return;
        }
        Class<?> clazz = this.forNameQuietly();
        if (clazz == null) {
            return;
        }
        if (version.compareTo(VERSION_1_2_9) < 0) {
            RassConfig rassConfig = ConfigLoader.loadSecurityConfig();
            if (!rassConfig.isIgnoreFastjsonWarning()) {
                logger.warn("FastJSON version: {} is found, reject to launch the program", (Object)version);
                throw new RassSecurityException("FastJSON version you're using is too dangerous, please contact security engineers (81828, 117726, 269396)");
            }
            return;
        }
        Method method = ReflectionUtils.findMethod(clazz, "getGlobalInstance");
        Object instance = ReflectionUtils.invokeMethod(method, null);
        if (version.compareTo(VERSION_1_2_42) < 0) {
            logger.info("Add {} deny classes to fastjson configs", (Object)(denyListToAppend == null ? 0 : denyListToAppend.size()));
            this.setDenyOrAcceptList(clazz, "denyList", instance, denyListToAppend);
            if (version.compareTo(VERSION_1_2_27) >= 0) {
                logger.info("Add {} accept classes to fastjson configs", (Object)(acceptListToAppend == null ? 0 : acceptListToAppend.size()));
                this.setDenyOrAcceptList(clazz, "acceptList", instance, acceptListToAppend);
            }
        } else {
            logger.info("Add {} deny classes to fastjson configs", (Object)(denyListToAppend == null ? 0 : denyListToAppend.size()));
            this.setDenyOrAcceptHashCodes(clazz, "denyHashCodes", instance, denyListToAppend);
            logger.info("Add {} accept classes to fastjson configs", (Object)(acceptListToAppend == null ? 0 : acceptListToAppend.size()));
            this.setDenyOrAcceptHashCodes(clazz, "acceptHashCodes", instance, acceptListToAppend);
        }
    }

    private Class<?> forNameQuietly() {
        try {
            return ClassUtils.forName("com.alibaba.fastjson.parser.ParserConfig", ClassUtils.getDefaultClassLoader());
        }
        catch (Throwable throwable) {
            logger.warn("Fastjson doesn't exist.");
            return null;
        }
    }

    private void setDenyOrAcceptHashCodes(Class<?> parserConfigClazz, String name, Object parserConfigInstance, List<String> listToAppend) {
        if (!CollectionUtils.isEmpty(listToAppend)) {
            Field acceptField = ReflectionUtils.findField(parserConfigClazz, name);
            long[] acceptHashCodes = (long[])ReflectionUtils.getFieldValue(acceptField, parserConfigInstance);
            HashSet<Long> newAcceptSet = new HashSet<Long>();
            for (long acceptHashCode : acceptHashCodes) {
                newAcceptSet.add(acceptHashCode);
            }
            Object object = listToAppend.iterator();
            while (object.hasNext()) {
                String s = (String)object.next();
                newAcceptSet.add(FastJsonDenyListModifier.calcHash(s));
            }
            acceptField.setAccessible(true);
            long[] toAppend = new long[newAcceptSet.size()];
            int i = 0;
            for (Long aLong : newAcceptSet) {
                toAppend[i++] = aLong;
            }
            Arrays.sort(toAppend);
            ReflectionUtils.setField(acceptField, parserConfigInstance, toAppend);
        }
    }

    private void setDenyOrAcceptList(Class<?> parserConfigClazz, String name, Object parserConfigInstance, List<String> listToAppend) {
        if (!CollectionUtils.isEmpty(listToAppend)) {
            Field denyField = ReflectionUtils.findField(parserConfigClazz, name);
            String[] originArray = (String[])ReflectionUtils.getFieldValue(denyField, parserConfigInstance);
            HashSet<String> newSet = new HashSet<String>();
            Collections.addAll(newSet, originArray);
            newSet.addAll(listToAppend);
            denyField.setAccessible(true);
            ReflectionUtils.setField(denyField, parserConfigInstance, newSet.toArray(new String[0]));
        }
    }

    private boolean isFastJSONExists() {
        try {
            Class.forName("com.alibaba.fastjson.parser.ParserConfig");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private String getFastJSONVersion() {
        try {
            Class<?> target = Class.forName("com.alibaba.fastjson.JSON");
            try {
                return (String)ReflectionUtils.getFieldValue(target, "VERSION", null);
            }
            catch (Exception e) {
                logger.info("fastjson exists, but can't get fastjson version with fallback method 2");
            }
        }
        catch (ClassNotFoundException ex) {
            logger.info("fastjson exists, but can't get fastjson version");
        }
        return null;
    }

    private static Long calcHash(String keyword) {
        long BASIC = -3750763034362895579L;
        long PRIME = 1099511628211L;
        Long hash = -3750763034362895579L;
        for (int i = 0; i < keyword.length(); ++i) {
            hash = hash ^ (long)keyword.charAt(i);
            hash = hash * 1099511628211L;
        }
        return hash;
    }

    static class FastJsonVersion
    implements Comparable<FastJsonVersion> {
        private String[] versionSplits;

        FastJsonVersion(String version) {
            this.versionSplits = StringUtils.split((String)version, (String)"._-");
        }

        @Override
        public int compareTo(FastJsonVersion version2) {
            int comparisonResult = 0;
            String[] version2Splits = version2.versionSplits;
            int maxLengthOfVersionSplits = Math.max(this.versionSplits.length, version2Splits.length);
            for (int i = 0; i < maxLengthOfVersionSplits; ++i) {
                Integer v2;
                Integer v1 = i < this.versionSplits.length ? this.parseInt(this.versionSplits[i]) : 0;
                int compare = v1.compareTo(v2 = Integer.valueOf(i < version2Splits.length ? this.parseInt(version2Splits[i]) : 0));
                if (compare == 0) continue;
                comparisonResult = compare;
                break;
            }
            return comparisonResult;
        }

        private int parseInt(String exp) {
            try {
                return Integer.parseInt(FastJsonVersion.stripNonDigits(exp));
            }
            catch (Exception ex) {
                return 0;
            }
        }

        private static String stripNonDigits(CharSequence input) {
            StringBuilder sb = new StringBuilder(input.length());
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (c <= '/' || c >= ':') continue;
                sb.append(c);
            }
            return sb.toString();
        }
    }
}

