/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dms.converter;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.bean.BwmJsonObject;
import com.aliyun.migration.workflow.migration.common.type.DbType;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.dms.domain.DmsTaskEdge;
import com.aliyun.migration.workflow.migration.dms.domain.DmsTaskFlowGraph;
import com.aliyun.migration.workflow.migration.dms.domain.DmsTaskFlowPackage;
import com.aliyun.migration.workflow.migration.dms.domain.DmsTaskNode;
import com.cronutils.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class Dms2WorkflowConverter {
    public WorkflowProjectPackage convert(DmsTaskFlowPackage dmsTaskFlowPackage) {
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        WorkflowProject workflowProject = new WorkflowProject();
        workflowProject.setProjectId(dmsTaskFlowPackage.getPackageName());
        workflowProject.setName(dmsTaskFlowPackage.getPackageName());
        workflowProject.setDescription("");
        workflowProjectPackage.setWorkflowProject(workflowProject);
        List workflowList = dmsTaskFlowPackage.getDmsTaskFlowGraphList().stream().map(x -> this.convertWorkflow((DmsTaskFlowGraph)x, workflowProject)).collect(Collectors.toList());
        workflowProjectPackage.setWorkflowList(workflowList);
        return workflowProjectPackage;
    }

    public Workflow convertWorkflow(DmsTaskFlowGraph dmsTaskFlowGraph, WorkflowProject workflowProject) {
        Workflow workflow = new Workflow();
        workflow.setWorkflowId(String.valueOf(dmsTaskFlowGraph.getTaskFlowId()));
        workflow.setWorkflowName(dmsTaskFlowGraph.getTaskFlowName());
        workflow.setProjectId(workflowProject.getProjectId());
        workflow.setProjectName(workflowProject.getName());
        List workflowNodeList = dmsTaskFlowGraph.getTaskNodeList().stream().map(x -> this.convertDmsNode((DmsTaskNode)x, workflow)).collect(Collectors.toList());
        workflow.setWorkflowNodes(workflowNodeList);
        List relationPackageList = dmsTaskFlowGraph.getTaskEdgeList().stream().map(x -> this.convertNodeRelation((DmsTaskEdge)x)).collect(Collectors.toList());
        workflow.setNodeRelations(relationPackageList);
        return workflow;
    }

    public RelationPackage convertNodeRelation(DmsTaskEdge dmsTaskEdge) {
        RelationPackage relationPackage = RelationPackage.builder().from(String.valueOf(dmsTaskEdge.getNodeFrom())).to(String.valueOf(dmsTaskEdge.getNodeEnd())).reType(RelationPackage.ReType.NODE).build();
        return relationPackage;
    }

    public WorkflowNode convertDmsNode(DmsTaskNode dmsTaskNode, Workflow workflow) {
        switch (dmsTaskNode.getTaskNodeType()) {
            case SINGLE_SQL: {
                return this.convertSqlNode(dmsTaskNode, workflow);
            }
        }
        return this.convertNode(dmsTaskNode, workflow);
    }

    private WorkflowNode convertNode(DmsTaskNode dmsTaskNode, Workflow workflow) {
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setWorkflowId(workflow.getWorkflowId());
        workflowNode.setProjectName(workflow.getProjectName());
        workflowNode.setWorkflowId(workflow.getWorkflowId());
        workflowNode.setWorkflowName(workflow.getWorkflowName());
        workflowNode.setNodeId(String.valueOf(dmsTaskNode.getTaskNodeId()));
        workflowNode.setNodeName(dmsTaskNode.getTaskNodeName());
        workflowNode.setNodeType(dmsTaskNode.getTaskNodeType().getType());
        workflowNode.setScript(dmsTaskNode.getTaskNodeContent());
        workflowNode.setParamMap(new HashMap());
        if (!StringUtils.isEmpty((CharSequence)dmsTaskNode.getTaskNodeConfig())) {
            workflowNode.getParamMap().put("config", dmsTaskNode.getTaskNodeConfig());
        }
        if (!StringUtils.isEmpty((CharSequence)dmsTaskNode.getTimeVariables())) {
            workflowNode.getParamMap().put("time_variables", dmsTaskNode.getTimeVariables());
        }
        return workflowNode;
    }

    private WorkflowNode convertSqlNode(DmsTaskNode dmsTaskNode, Workflow workflow) {
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setWorkflowId(workflow.getWorkflowId());
        workflowNode.setProjectName(workflow.getProjectName());
        workflowNode.setWorkflowId(workflow.getWorkflowId());
        workflowNode.setWorkflowName(workflow.getWorkflowName());
        workflowNode.setNodeId(String.valueOf(dmsTaskNode.getTaskNodeId()));
        workflowNode.setNodeName(dmsTaskNode.getTaskNodeName());
        workflowNode.setParamMap(new HashMap());
        BwmJsonObject configJson = BwmJsonUtil.parseObject((String)dmsTaskNode.getTaskNodeConfig());
        String sqlScript = configJson.getStringWrap("sql");
        String dbName = configJson.getStringWrap("dbType").toLowerCase();
        workflowNode.setScript(sqlScript);
        switch (dbName) {
            case "mysql": {
                workflowNode.setDbType(DbType.MYSQL.getDescp());
                break;
            }
            case "polardb": {
                workflowNode.setDbType(DbType.POLARDB_MYSQL.getDescp());
                break;
            }
            case "oracle": {
                workflowNode.setDbType(DbType.ORACLE.getDescp());
                break;
            }
            case "ob_for_oracle": 
            case "oceanbasex": {
                workflowNode.setDbType(DbType.OCEANBASE.getDescp());
                break;
            }
            case "mariadb": {
                workflowNode.setDbType(DbType.MARIADB.getDescp());
                break;
            }
            case "postgresql": {
                workflowNode.setDbType(DbType.POSTGRESQL.getDescp());
                break;
            }
            case "sqlserver": {
                workflowNode.setDbType(DbType.SQLSERVER.getDescp());
                break;
            }
            case "polardb-o": {
                workflowNode.setDbType(DbType.POLARDB_O.getDescp());
                break;
            }
            case "polardb-pg": {
                workflowNode.setDbType(DbType.POLARDB_PG.getDescp());
                break;
            }
            case "drds": {
                workflowNode.setDbType(DbType.POLARDB_DRDS.getDescp());
                break;
            }
            case "redis": {
                workflowNode.setDbType(DbType.REDIS.getDescp());
                break;
            }
            case "mongo": {
                workflowNode.setDbType(DbType.MONGODB.getDescp());
                break;
            }
            case "hbase": {
                workflowNode.setDbType(DbType.HBASE.getDescp());
                break;
            }
            case "lindorm_cql": {
                workflowNode.setDbType(DbType.LINDORM.getDescp());
                break;
            }
            case "cassandra": {
                workflowNode.setDbType(DbType.CASSANDRA.getDescp());
                break;
            }
            case "adb_mysql": {
                workflowNode.setDbType(DbType.ADB_MYSQL.getDescp());
                break;
            }
            case "adb_postgresql": {
                workflowNode.setDbType(DbType.ADB_PG.getDescp());
                break;
            }
            case "dla": {
                workflowNode.setDbType(DbType.DLA.getDescp());
                break;
            }
            case "clickhouse": {
                workflowNode.setDbType(DbType.CLICKHOUSE.getDescp());
                break;
            }
            case "maxcompute": {
                workflowNode.setDbType(DbType.MAXCOMPUTE.getDescp());
                break;
            }
            case "gdb": {
                workflowNode.setDbType(DbType.GDB.getDescp());
                break;
            }
            case "dm": {
                workflowNode.setDbType(DbType.DAMENG.getDescp());
                break;
            }
            default: {
                workflowNode.setDbType(DbType.UNKUNWN.getDescp());
            }
        }
        return workflowNode;
    }
}

