/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.joda.time.Days;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.Years;

public class TimeUtils {
    public static final String DATE_TIME_ZONE_PATTERN = "yyyy/MM/dd HH:mm:ss z";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static String formatDateTimeZone(long timestampMs) {
        return TimeUtils.format(timestampMs, DATE_TIME_ZONE_PATTERN);
    }

    public static String formatDateTime(long timestampMs) {
        return TimeUtils.format(timestampMs, DATE_TIME_PATTERN);
    }

    private static String format(long timestampMs, String pattern) {
        if (timestampMs < 0L) {
            return "-";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestampMs), ZoneId.systemDefault());
        return formatter.format(zonedDateTime);
    }

    public static String formatDuration(long startTime, long endTime) {
        if (startTime == -1L) {
            return "-";
        }
        long durationMS = endTime == -1L ? System.currentTimeMillis() - startTime : endTime - startTime;
        long seconds = durationMS / 1000L;
        if (seconds < 60L) {
            return seconds + " sec";
        }
        long minutes = seconds / 60L;
        seconds %= 60L;
        if (minutes < 60L) {
            return minutes + "m " + seconds + "s";
        }
        long hours = minutes / 60L;
        minutes %= 60L;
        if (hours < 24L) {
            return hours + "h " + minutes + "m " + seconds + "s";
        }
        long days = hours / 24L;
        return days + "d " + (hours %= 24L) + "h " + minutes + "m";
    }

    public static String formatPeriod(ReadablePeriod period) {
        String periodStr = "null";
        if (period == null) {
            return periodStr;
        }
        if (period.get(DurationFieldType.years()) > 0) {
            int years = period.get(DurationFieldType.years());
            periodStr = years + " year(s)";
        } else if (period.get(DurationFieldType.months()) > 0) {
            int months = period.get(DurationFieldType.months());
            periodStr = months + " month(s)";
        } else if (period.get(DurationFieldType.weeks()) > 0) {
            int weeks = period.get(DurationFieldType.weeks());
            periodStr = weeks + " week(s)";
        } else if (period.get(DurationFieldType.days()) > 0) {
            int days = period.get(DurationFieldType.days());
            periodStr = days + " day(s)";
        } else if (period.get(DurationFieldType.hours()) > 0) {
            int hours = period.get(DurationFieldType.hours());
            periodStr = hours + " hour(s)";
        } else if (period.get(DurationFieldType.minutes()) > 0) {
            int minutes = period.get(DurationFieldType.minutes());
            periodStr = minutes + " minute(s)";
        } else if (period.get(DurationFieldType.seconds()) > 0) {
            int seconds = period.get(DurationFieldType.seconds());
            periodStr = seconds + " second(s)";
        }
        return periodStr;
    }

    public static ReadablePeriod parsePeriodString(String periodStr) {
        Years period;
        char periodUnit = periodStr.charAt(periodStr.length() - 1);
        if (periodStr.equals("null") || periodUnit == 'n') {
            return null;
        }
        int periodInt = Integer.parseInt(periodStr.substring(0, periodStr.length() - 1));
        switch (periodUnit) {
            case 'y': {
                period = Years.years((int)periodInt);
                break;
            }
            case 'M': {
                period = Months.months((int)periodInt);
                break;
            }
            case 'w': {
                period = Weeks.weeks((int)periodInt);
                break;
            }
            case 'd': {
                period = Days.days((int)periodInt);
                break;
            }
            case 'h': {
                period = Hours.hours((int)periodInt);
                break;
            }
            case 'm': {
                period = Minutes.minutes((int)periodInt);
                break;
            }
            case 's': {
                period = Seconds.seconds((int)periodInt);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid schedule period unit '" + periodUnit);
            }
        }
        return period;
    }

    public static String createPeriodString(ReadablePeriod period) {
        String periodStr = "null";
        if (period == null) {
            return "null";
        }
        if (period.get(DurationFieldType.years()) > 0) {
            int years = period.get(DurationFieldType.years());
            periodStr = years + "y";
        } else if (period.get(DurationFieldType.months()) > 0) {
            int months = period.get(DurationFieldType.months());
            periodStr = months + "M";
        } else if (period.get(DurationFieldType.weeks()) > 0) {
            int weeks = period.get(DurationFieldType.weeks());
            periodStr = weeks + "w";
        } else if (period.get(DurationFieldType.days()) > 0) {
            int days = period.get(DurationFieldType.days());
            periodStr = days + "d";
        } else if (period.get(DurationFieldType.hours()) > 0) {
            int hours = period.get(DurationFieldType.hours());
            periodStr = hours + "h";
        } else if (period.get(DurationFieldType.minutes()) > 0) {
            int minutes = period.get(DurationFieldType.minutes());
            periodStr = minutes + "m";
        } else if (period.get(DurationFieldType.seconds()) > 0) {
            int seconds = period.get(DurationFieldType.seconds());
            periodStr = seconds + "s";
        }
        return periodStr;
    }
}

