/*
 * Decompiled with CFR 0.152.
 */
package azkaban.metrics;

import azkaban.utils.Props;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.lang.reflect.Constructor;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MetricsManager {
    private static final Logger log = LoggerFactory.getLogger(MetricsManager.class);
    private final MetricRegistry registry;

    @Inject
    public MetricsManager(MetricRegistry registry) {
        this.registry = registry;
        this.registerJvmMetrics();
    }

    private void registerJvmMetrics() {
        this.registry.register("MEMORY_Gauge", (Metric)new MemoryUsageGaugeSet());
        this.registry.register("GC_Gauge", (Metric)new GarbageCollectorMetricSet());
        this.registry.register("Thread_State_Gauge", (Metric)new ThreadStatesGaugeSet());
    }

    public Meter addMeter(String name) {
        Meter curr = this.registry.meter(name);
        this.registry.register(name + "-gauge", (Metric)((Gauge)() -> ((Meter)curr).getOneMinuteRate()));
        return curr;
    }

    public <T> void addGauge(String name, Supplier<T> gaugeFunc) {
        this.registry.register(name, (Metric)((Gauge)gaugeFunc::get));
    }

    public Counter addCounter(String name) {
        return this.registry.counter(name);
    }

    public Histogram addHistogram(String name) {
        return this.registry.histogram(name);
    }

    public Timer addTimer(String name) {
        return this.registry.timer(name);
    }

    public synchronized void startReporting(String reporterName, Props props) {
        String metricsReporterClassName = props.get("azkaban.metrics.reporter.name");
        String metricsServerURL = props.get("azkaban.metrics.server.url");
        if (metricsReporterClassName != null && metricsServerURL != null) {
            try {
                log.info("metricsReporterClassName: " + metricsReporterClassName);
                Class<?> metricsClass = Class.forName(metricsReporterClassName);
                Constructor<?>[] constructors = metricsClass.getConstructors();
                constructors[0].newInstance(reporterName, this.registry, metricsServerURL);
            }
            catch (Exception e) {
                log.error("Encountered error while loading and instantiating " + metricsReporterClassName, (Throwable)e);
                throw new IllegalStateException("Encountered error while loading and instantiating " + metricsReporterClassName, e);
            }
        } else {
            log.error(String.format("No value for property: %s or %s was found", "azkaban.metrics.reporter.name", "azkaban.metrics.server.url"));
        }
    }
}

