/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model.serialize;

import com.aliyun.mns.model.AbstractMessagePropertyValue;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.MessagePropertyValue;
import com.aliyun.mns.model.PropertyType;
import com.aliyun.mns.model.serialize.BaseXMLSerializer;
import com.aliyun.mns.model.serialize.Serializer;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XMLSerializer<T>
extends BaseXMLSerializer<T>
implements Serializer<T> {
    public Element safeCreateContentElement(Document doc, String tagName, Object value, String defaultValue) {
        if (value == null && defaultValue == null) {
            return null;
        }
        Element node = doc.createElement(tagName);
        if (value != null) {
            node.setTextContent(value.toString());
        } else {
            node.setTextContent(defaultValue);
        }
        return node;
    }

    public Element serializeMessage(Document doc, Message msg) {
        Element root = doc.createElementNS("http://mns.aliyuncs.com/doc/v1", "Message");
        Element node = this.safeCreateContentElement(doc, "MessageBody", msg.getOriginalMessageBody(), "");
        if (node != null) {
            root.appendChild(node);
        }
        if ((node = this.safeCreateContentElement(doc, "DelaySeconds", msg.getDelaySeconds(), null)) != null) {
            root.appendChild(node);
        }
        if ((node = this.safeCreateContentElement(doc, "Priority", msg.getPriority(), null)) != null) {
            root.appendChild(node);
        }
        if ((node = this.safeCreatePropertiesNode(doc, msg.getUserProperties(), "UserProperties", "PropertyValue")) != null) {
            root.appendChild(node);
        }
        if ((node = this.safeCreatePropertiesNode(doc, msg.getSystemProperties(), "SystemProperties", "SystemPropertyValue")) != null) {
            root.appendChild(node);
        }
        return root;
    }

    public Element safeCreatePropertiesNode(Document doc, Map<String, ? extends AbstractMessagePropertyValue> map, String nodeName, String propertyNodeName) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        Element propertiesNode = doc.createElement(nodeName);
        for (Map.Entry<String, ? extends AbstractMessagePropertyValue> entry : map.entrySet()) {
            Element typeNode;
            Element valueNode;
            PropertyType propertyType;
            Element propNode = doc.createElement(propertyNodeName);
            Element nameNode = this.safeCreateContentElement(doc, "Name", entry.getKey(), null);
            if (nameNode != null) {
                propNode.appendChild(nameNode);
            }
            String valueString = entry.getValue().getStringValueByType();
            if (entry.getValue() instanceof MessagePropertyValue && (propertyType = ((MessagePropertyValue)entry.getValue()).getDataType()) == PropertyType.BINARY) {
                valueString = new String(Base64.encodeBase64((byte[])valueString.getBytes()));
            }
            if ((valueNode = this.safeCreateContentElement(doc, "Value", valueString, null)) != null) {
                propNode.appendChild(valueNode);
            }
            if ((typeNode = this.safeCreateContentElement(doc, "Type", entry.getValue().getDataTypeString(), null)) != null) {
                propNode.appendChild(typeNode);
            }
            propertiesNode.appendChild(propNode);
        }
        return propertiesNode;
    }
}

