/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.dw.dbr.converter;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerBranchCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.databricks.sdk.service.jobs.ConditionTask;
import com.databricks.sdk.service.jobs.ConditionTaskOp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbrConditionConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DbrConditionConvert.class);

    public DbrConditionConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public DbrConditionConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        if (CollectionUtils.isEmpty(workflowNodes)) {
            return res;
        }
        for (WorkflowNode workflowNode : workflowNodes) {
            WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
            tgtworkflowNode.setNodeType(CodeProgramType.CONTROLLER_BRANCH.getName());
            String script = workflowNode.getScript();
            ConditionTask conditionTask = (ConditionTask)BwmJsonUtil.parseObject((String)script, ConditionTask.class);
            if (Objects.isNull(conditionTask)) {
                log.error("not parse ConditionTask {}", (Object)workflowNode.getNodeName());
                tgtworkflowNode.setNodeType(CodeProgramType.VIRTUAL.getName());
                res.add(tgtworkflowNode);
                return res;
            }
            ConditionTaskOp op = conditionTask.getOp();
            String conditionOpStr = this.generateCondition(op);
            String condition = conditionTask.getLeft() + conditionOpStr + conditionTask.getRight();
            ArrayList<ControllerBranchCode.Branch> branchList = new ArrayList<ControllerBranchCode.Branch>();
            Set conditionNodes = this.workflow.getNodeRelations().stream().filter(nodeRelation -> nodeRelation.getFrom().equals(workflowNode.getNodeId())).map(RelationPackage::getTo).collect(Collectors.toSet());
            WorkflowNode conditionTrueNode = this.workflow.getWorkflowNodes().stream().filter(node -> conditionNodes.contains(node.getNodeId())).peek(node -> {
                if (null == node.getCustomProperties()) {
                    node.setCustomProperties(new HashMap());
                }
            }).filter(node -> "true".equals(node.getCustomProperties().get("dbr_task_outcome"))).findFirst().orElse(null);
            if (Objects.isNull(conditionTrueNode)) {
                log.error("not found dbr condition task true node {}", (Object)workflowNode.getNodeName());
                tgtworkflowNode.setNodeType(CodeProgramType.VIRTUAL.getName());
                res.add(tgtworkflowNode);
                return res;
            }
            ControllerBranchCode.Branch branch = new ControllerBranchCode.Branch();
            branch.setCondition(condition);
            String output = this.getDefaultNodeOutput(conditionTrueNode.getNodeId());
            branch.setNodeoutput(output);
            branchList.add(branch);
            ControllerBranchCode branchCode = new ControllerBranchCode();
            branchCode.setBranchList(branchList);
            tgtworkflowNode.setScript(branchCode.getContent());
            res.add(tgtworkflowNode);
        }
        return res;
    }

    private String generateCondition(ConditionTaskOp op) {
        switch (op) {
            case EQUAL_TO: {
                return "==";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_OR_EQUAL: {
                return ">=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_OR_EQUAL: {
                return "<=";
            }
            case NOT_EQUAL: {
                return "!=";
            }
        }
        return "";
    }
}

