/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.Props;
import azkaban.utils.Utils;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public class MemConfValue {
    private final String string;
    private final long size;

    public static MemConfValue parseMaxXms(Props props) {
        return MemConfValue.parse(props, "job.max.Xms", "1G");
    }

    public static MemConfValue parseMaxXmx(Props props) {
        return MemConfValue.parse(props, "job.max.Xmx", "2G");
    }

    private static MemConfValue parse(Props props, String key, String defaultValue) {
        String stringValue = props.getString(key, defaultValue);
        Preconditions.checkArgument((!StringUtils.isBlank((String)stringValue) ? 1 : 0) != 0, (Object)String.format("%s must not have an empty value. Remove the property to use default or specify a valid value.", key));
        long size = Utils.parseMemString(stringValue);
        return new MemConfValue(stringValue, size);
    }

    private MemConfValue(String string, long size) {
        this.string = string;
        this.size = size;
    }

    public String getString() {
        return this.string;
    }

    public long getSize() {
        return this.size;
    }
}

