/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv3.handle;

import com.alibaba.cola.dto.Response;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerApi;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinschedulerApiV3Service;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.dsv1.temp.DolphinSchedulerReader;
import com.aliyun.migration.workflow.migration.dsv3.handle.Dolphinv3FileHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphinv3OpenApiHandler
extends Dolphinv3FileHandler {
    private static final Logger log = LoggerFactory.getLogger(Dolphinv3OpenApiHandler.class);
    private DolphinSchedulerReader dolphinSchedulerReader;
    private DolphinSchedulerApi dolphinSchedulerApiService;
    private Boolean needDownloadResource;

    public Dolphinv3OpenApiHandler(Datasource scheduleDataSource, TaskContext taskContext) {
        super(scheduleDataSource, taskContext);
    }

    @Override
    public void init() {
        Object mxExportFilePath;
        String project;
        Map properties = this.scheduleDataSource.getProperties();
        String endpoint = (String)properties.get("endpoint");
        String token = (String)properties.get("token");
        this.project = project = (String)properties.get("project");
        String version = (String)properties.get("version");
        Boolean needDownloadResource = this.getIfNeedDownloadResource();
        if (!NumberUtils.isDigits((String)version)) {
            version = "3.2.0";
        }
        if (StringUtils.isBlank((CharSequence)(mxExportFilePath = (String)properties.get("source-file-path")))) {
            mxExportFilePath = "temp/dolphinv1/" + this.scheduleDataSource.getName();
            properties.put("source-file-path", mxExportFilePath);
        }
        this.dolphinSchedulerApiService = new DolphinschedulerApiV3Service(endpoint, token);
        List<WorkflowProject> projectList = this.getProjectList();
        if (CollectionUtils.isEmpty(projectList)) {
            log.error("\u8be5DolphinScheduler\u4e2d\u4e0d\u5b58\u5728\u9879\u76ee\u6216token\u65e0\u9879\u76ee\u6743\u9650");
            return;
        }
        Boolean isProjectExist = projectList.stream().anyMatch(workflowProject -> workflowProject.getName().equals(project));
        if (!isProjectExist.booleanValue()) {
            for (WorkflowProject workflowProject2 : projectList) {
                if (!workflowProject2.getProjectId().equals(project)) continue;
                this.project = workflowProject2.getName();
                isProjectExist = true;
                break;
            }
        }
        if (isProjectExist.booleanValue()) {
            List<String> projects = Collections.singletonList(this.project);
            this.dolphinSchedulerReader = new DolphinSchedulerReader(endpoint, token, version, projects, new ArrayList(), new File((String)mxExportFilePath));
            this.dolphinSchedulerReader.setSkipResources(Boolean.valueOf(false));
        } else {
            log.error("\u8be5DolphinScheduler\u4e2d\u4e0d\u5b58\u5728\u8be5\u9879\u76ee\u6216token\u65e0\u8be5\u9879\u76ee\u6743\u9650: {}", (Object)project);
        }
    }

    public List<WorkflowProject> getProjectList() {
        try {
            com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.Response listResponse = this.dolphinSchedulerApiService.queryAllProjectList(new DolphinSchedulerRequest());
            if (listResponse.getData() == null || ((List)listResponse.getData()).size() <= 0) {
                log.error("dolphin not.find.the.projects");
                return new ArrayList<WorkflowProject>();
            }
            List data = (List)listResponse.getData();
            return data.stream().map(jsonObject -> {
                WorkflowProject workflowProject = new WorkflowProject();
                workflowProject.setName(jsonObject.get("name").getAsString());
                workflowProject.setProjectId(jsonObject.get("code").getAsString());
                return workflowProject;
            }).toList();
        }
        catch (Exception e) {
            log.error("detect.dolphinschedulev1.error", (Throwable)e);
            return new ArrayList<WorkflowProject>();
        }
    }

    public Response preCheck(Datasource scheduleDataSource) {
        try {
            com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.Response listResponse = this.dolphinSchedulerApiService.queryAllProjectList(new DolphinSchedulerRequest());
            if (listResponse.getData() == null || ((List)listResponse.getData()).size() <= 0) {
                return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"not.find.the.projects");
            }
        }
        catch (Exception e) {
            log.error("detect.dolphinschedulev1.error", (Throwable)e);
            return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"detect.dolphinschedulev1.error");
        }
        return Response.buildSuccess();
    }

    @Override
    public WorkflowProjectPackage read() {
        File export = null;
        export = this.dolphinSchedulerReader.export();
        Map properties = this.scheduleDataSource.getProperties();
        properties.put("source-file-path", export.getAbsolutePath());
        super.init();
        return super.read();
    }
}

