/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.circuitbreaker.event;

import com.alibaba.securitysdk.logging.circuitbreaker.ThresholdCircuitBreakerEvent;
import com.alibaba.securitysdk.logging.circuitbreaker.jmx.DiskspaceMXBean;
import com.alibaba.securitysdk.logging.circuitbreaker.jmx.DiskspaceUsage;
import com.alibaba.securitysdk.logging.circuitbreaker.util.JmxUtil;
import com.alibaba.securitysdk.logging.utils.AssertUtil;

public class SpaceThresholdCircuitBreakerEvent
implements ThresholdCircuitBreakerEvent<DiskspaceMXBean> {
    private final DiskspaceMXBean diskspaceMXBean;
    private final double threadHold;

    public SpaceThresholdCircuitBreakerEvent(double threadHold) {
        this(threadHold, JmxUtil.createDiskspaceMXBean());
    }

    public SpaceThresholdCircuitBreakerEvent(double threadHold, DiskspaceMXBean diskspaceMXBean) {
        this.threadHold = threadHold;
        this.diskspaceMXBean = (DiskspaceMXBean)AssertUtil.notNull((Object)diskspaceMXBean);
    }

    @Override
    public boolean exceedThreshold() {
        DiskspaceUsage workingDiskspace = this.diskspaceMXBean.getWorkingDiskspaceUsage();
        double spaceUsageRatio = (double)workingDiskspace.getUsableSpace() / (double)workingDiskspace.getTotalSpace();
        return this.threadHold <= 0.0 || spaceUsageRatio > this.threadHold;
    }

    @Override
    public DiskspaceMXBean getObject() {
        return this.diskspaceMXBean;
    }
}

