/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.bwmspec.reader.module;

import com.alibaba.cola.dto.Response;
import com.alibaba.cola.dto.SingleResponse;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.AbstractReader;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmSpecReader
extends AbstractReader {
    private static final Logger log = LoggerFactory.getLogger(BwmSpecReader.class);

    public Reader init(TaskContext taskContext) {
        this.setTaskContext(taskContext);
        this.optimalizeReader();
        return this;
    }

    public Response preCheck(Datasource scheduleDataSource) {
        String sourFilePath = this.taskContext.getSourceFilePackage();
        if (StringUtils.isBlank((CharSequence)sourFilePath)) {
            return Response.buildFailure((String)BwmServiceErrorCode.FILE_NOT_FOUND.getCode(), (String)"sourceFilePath is null");
        }
        BwmPackageFileOperator.readFile((String)sourFilePath);
        return SingleResponse.buildSuccess();
    }

    public WorkflowProjectPackage read() throws Exception {
        WorkflowProjectPackage pkg = BwmPackageFileOperator.readFile((String)this.taskContext.getSourceFilePackage());
        this.taskContext.setWorkflowProjectPackage(pkg);
        return pkg;
    }
}

