/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.model;

import com.aliyun.dataworks.common.spec.domain.SpecContext;
import com.aliyun.dataworks.common.spec.domain.SpecEntity;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.enums.SpecEntityType;
import com.aliyun.dataworks.common.spec.domain.interfaces.Input;
import com.aliyun.dataworks.common.spec.domain.interfaces.Output;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.ref.Container;
import com.aliyun.dataworks.common.spec.domain.ref.InputOutputWired;
import com.aliyun.dataworks.common.spec.domain.ref.ScriptWired;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SpecRefEntityWrapper
extends SpecRefEntity
implements Container,
InputOutputWired,
ScriptWired {
    private SpecRefEntity specRefEntity;
    private SpecEntityType type;

    public SpecRefEntityWrapper setSpecRefEntity(SpecRefEntity entity) {
        this.specRefEntity = entity;
        if (entity != null) {
            this.type = entity.getClass().equals(SpecNode.class) ? SpecEntityType.NODE : (entity.getClass().equals(SpecWorkflow.class) ? SpecEntityType.WORKFLOW : null);
            this.setId(entity.getId());
            this.setMetadata(entity.getMetadata());
            this.setContext(entity.getContext());
            this.setIsRef(entity.getIsRef());
        }
        return this;
    }

    public String getId() {
        return Optional.ofNullable(this.getSpecRefEntity()).map(SpecRefEntity::getId).orElse(null);
    }

    public Boolean getIsRef() {
        return Optional.ofNullable(this.getSpecRefEntity()).map(SpecRefEntity::getIsRef).orElse(null);
    }

    public Map<String, Object> getMetadata() {
        return Optional.ofNullable(this.getSpecRefEntity()).map(SpecEntity::getMetadata).orElse(null);
    }

    public SpecContext getContext() {
        return Optional.ofNullable(this.getSpecRefEntity()).map(SpecEntity::getContext).orElse(null);
    }

    public SpecNode getNode() {
        return this.getSpecRefEntity(SpecNode.class, SpecEntityType.NODE);
    }

    public SpecWorkflow getWorkflow() {
        return this.getSpecRefEntity(SpecWorkflow.class, SpecEntityType.WORKFLOW);
    }

    public Container getAsContainer() {
        return this.getSpecRefEntity(Container.class);
    }

    public InputOutputWired getAsInputOutputWired() {
        return this.getSpecRefEntity(InputOutputWired.class);
    }

    public ScriptWired getAsScriptWired() {
        return this.getSpecRefEntity(ScriptWired.class);
    }

    private <T extends SpecRefEntity> T getSpecRefEntity(Class<T> clazz, SpecEntityType entityType) {
        if (this.type == null || !this.type.equals((Object)entityType)) {
            return null;
        }
        return (T)((SpecRefEntity)this.getSpecRefEntity(clazz));
    }

    private <T> T getSpecRefEntity(Class<T> clazz) {
        return Optional.ofNullable(this.specRefEntity).filter(clazz::isInstance).map(clazz::cast).orElse(null);
    }

    public List<SpecNode> getInnerNodes() {
        return Optional.ofNullable(this.getAsContainer()).map(Container::getInnerNodes).orElse(Collections.emptyList());
    }

    public List<SpecFlowDepend> getInnerDependencies() {
        return Optional.ofNullable(this.getAsContainer()).map(Container::getInnerDependencies).orElse(Collections.emptyList());
    }

    public List<Input> getInputs() {
        return Optional.ofNullable(this.getAsInputOutputWired()).map(InputOutputWired::getInputs).orElse(Collections.emptyList());
    }

    public List<Output> getOutputs() {
        return Optional.ofNullable(this.getAsInputOutputWired()).map(InputOutputWired::getOutputs).orElse(Collections.emptyList());
    }

    public SpecScript getScript() {
        return Optional.ofNullable(this.getAsScriptWired()).map(ScriptWired::getScript).orElse(null);
    }

    public SpecRefEntity getSpecRefEntity() {
        return this.specRefEntity;
    }

    public SpecEntityType getType() {
        return this.type;
    }

    public SpecRefEntityWrapper setType(SpecEntityType type) {
        this.type = type;
        return this;
    }

    public String toString() {
        return "SpecRefEntityWrapper(super=" + super.toString() + ", specRefEntity=" + this.getSpecRefEntity() + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecRefEntityWrapper)) {
            return false;
        }
        SpecRefEntityWrapper other = (SpecRefEntityWrapper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpecRefEntity this$specRefEntity = this.getSpecRefEntity();
        SpecRefEntity other$specRefEntity = other.getSpecRefEntity();
        if (this$specRefEntity == null ? other$specRefEntity != null : !this$specRefEntity.equals(other$specRefEntity)) {
            return false;
        }
        SpecEntityType this$type = this.getType();
        SpecEntityType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpecRefEntityWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SpecRefEntity $specRefEntity = this.getSpecRefEntity();
        result = result * 59 + ($specRefEntity == null ? 43 : $specRefEntity.hashCode());
        SpecEntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

