/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.logic.condition;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerJoinCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecEntityType;
import com.aliyun.dataworks.common.spec.domain.interfaces.Output;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecJoin;
import com.aliyun.dataworks.common.spec.domain.noref.SpecJoinBranch;
import com.aliyun.dataworks.common.spec.domain.noref.SpecLogic;
import com.aliyun.dataworks.common.spec.domain.ref.InputOutputWired;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.DependentRelation;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.TaskExecutionStatus;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.DependentItem;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.DependentTaskModel;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.task.condition.ConditionsParameters;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.dataworks.migrationx.transformer.flowspec.model.SpecRefEntityWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;

public class ConditionsParameterConverter
extends AbstractParameterConverter<ConditionsParameters> {
    private static final SpecScriptRuntime RUNTIME = new SpecScriptRuntime();

    public ConditionsParameterConverter(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, TaskDefinition taskDefinition, DolphinSchedulerV3ConverterContext context) {
        super(spec, specWorkflow, taskDefinition, context);
    }

    @Override
    protected void convertParameter(SpecNode finalJoinNode) {
        if (BooleanUtils.isTrue((Boolean)this.context.getJudgeConditionOnce())) {
            finalJoinNode.setRerunTimes(Integer.valueOf(0));
            finalJoinNode.setRerunInterval(Integer.valueOf(0));
            this.resetNodeStrategy(finalJoinNode);
        }
        SpecScript script = new SpecScript();
        script.setId(this.generateUuid());
        script.setRuntime(RUNTIME);
        script.setPath(this.getScriptPath(finalJoinNode));
        finalJoinNode.setScript(script);
        SpecNode successNode = this.buildBranchNode(finalJoinNode, ControllerJoinCode.Status.SUCCESS, "_success");
        SpecNode failNode = this.buildBranchNode(finalJoinNode, ControllerJoinCode.Status.FAILURE, "_fail");
        Optional.ofNullable((ConditionsParameters)this.parameter).map(ConditionsParameters::getConditionResult).ifPresent(conditionResult -> {
            ListUtils.emptyIfNull((List)conditionResult.getSuccessNode()).stream().filter(Objects::nonNull).forEach(code -> this.addBranchRelation(successNode, (Long)code));
            ListUtils.emptyIfNull((List)conditionResult.getFailedNode()).stream().filter(Objects::nonNull).forEach(code -> this.addBranchRelation(failNode, (Long)code));
        });
        this.tailList.add(this.newWrapper((SpecRefEntity)successNode));
        this.tailList.add(this.newWrapper((SpecRefEntity)failNode));
        Optional.ofNullable((ConditionsParameters)this.parameter).map(ConditionsParameters::getDependence).ifPresent(dependence -> {
            ArrayList<SpecNode> nodeList = new ArrayList<SpecNode>();
            for (int i = 0; i < ListUtils.emptyIfNull((List)dependence.getDependTaskList()).size(); ++i) {
                SpecNode specNode;
                DependentTaskModel dependentTaskModel = (DependentTaskModel)dependence.getDependTaskList().get(i);
                List<SpecJoinBranch> joinBranchList = ListUtils.emptyIfNull((List)dependentTaskModel.getDependItemList()).stream().map(this::buildSpecJoinBranch).flatMap(Collection::stream).collect(Collectors.toList());
                SpecJoin specJoin = this.newSpecJoin(joinBranchList, dependentTaskModel.getRelation());
                SpecNode specNode2 = specNode = dependence.getDependTaskList().size() <= 1 ? finalJoinNode : this.copyJoinNode(finalJoinNode, specJoin, "_join_" + i);
                if (specNode.getJoin() == null) {
                    specNode.setJoin(specJoin);
                    Optional.ofNullable(specNode.getScript()).ifPresent(s -> s.setContent(this.buildControllerJoinCode(specNode).getContent()));
                }
                List<SpecNode> subNodeList = ListUtils.emptyIfNull(joinBranchList).stream().map(SpecJoinBranch::getNodeId).filter(Objects::nonNull).collect(Collectors.toList());
                List<SpecNodeOutput> subNodeOutputList = ListUtils.emptyIfNull(joinBranchList).stream().filter(joinBranch -> Objects.isNull(joinBranch.getNodeId())).map(SpecJoinBranch::getOutput).collect(Collectors.toList());
                this.addRelation(specNode, subNodeList, subNodeOutputList);
                nodeList.add(specNode);
            }
            if (CollectionUtils.size(nodeList) > 1) {
                List<SpecJoinBranch> specJoinBranchList = ListUtils.emptyIfNull(nodeList).stream().map(node -> this.buildSpecJoinBranch((SpecNode)node, ControllerJoinCode.Status.SUCCESS)).collect(Collectors.toList());
                SpecJoin specJoin = this.newSpecJoin(specJoinBranchList, dependence.getRelation());
                finalJoinNode.setJoin(specJoin);
                Optional.ofNullable(this.buildControllerJoinCode(finalJoinNode)).map(AbstractBaseCode::getContent).ifPresent(arg_0 -> ((SpecScript)script).setContent(arg_0));
                this.addRelation(finalJoinNode, nodeList);
            }
        });
    }

    private void addBranchRelation(SpecNode preNode, Long taskCode) {
        List<SpecRefEntityWrapper> specRefEntityWrappers = this.context.getEntityHeadMap().get(taskCode);
        ListUtils.emptyIfNull(specRefEntityWrappers).forEach(entity -> {
            if (SpecEntityType.NODE.equals((Object)entity.getType())) {
                SpecFlowDepend specFlowDepend = this.newSpecFlowDepend();
                specFlowDepend.setNodeId(entity.getNode());
                specFlowDepend.getDepends().add(new SpecDepend(preNode, DependencyType.NORMAL, this.getDefaultOutput(preNode)));
                this.getWorkflowDependencyList().add(specFlowDepend);
            }
            InputOutputWired inputOutputWired = entity.getAsInputOutputWired();
            inputOutputWired.getInputs().add(this.getDefaultOutput(preNode));
        });
    }

    private SpecNode buildBranchNode(SpecNode finalJoinNode, ControllerJoinCode.Status status, String suffix) {
        SpecJoinBranch branch = this.buildSpecJoinBranch(finalJoinNode, status);
        SpecJoin specJoin = this.newSpecJoin(Collections.singletonList(branch), DependentRelation.AND);
        SpecNode specNode = this.copyJoinNode(finalJoinNode, specJoin, suffix);
        this.addRelation(specNode, Collections.singletonList(finalJoinNode), null);
        return specNode;
    }

    private List<SpecJoinBranch> buildSpecJoinBranch(DependentItem dependentItem) {
        ControllerJoinCode.Status status = dependentItem.getStatus() == TaskExecutionStatus.FAILURE ? ControllerJoinCode.Status.FAILURE : ControllerJoinCode.Status.SUCCESS;
        List<SpecRefEntityWrapper> specRefEntityWrappers = this.context.getEntityTailMap().get(dependentItem.getDepTaskCode());
        List specJoinBranchList = ListUtils.emptyIfNull(specRefEntityWrappers).stream().map(SpecRefEntityWrapper::getNode).filter(Objects::nonNull).map(node -> this.buildSpecJoinBranch((SpecNode)node, status)).collect(Collectors.toList());
        List specJoinBranchListWithOutput = ListUtils.emptyIfNull(specRefEntityWrappers).stream().filter(entity -> entity.getNode() == null).map(SpecRefEntityWrapper::getAsInputOutputWired).filter(Objects::nonNull).map(InputOutputWired::getOutputs).map(x$0 -> this.getDefaultOutput((List<Output>)x$0)).map(output -> this.buildSpecJoinBranch((SpecNodeOutput)output, status)).collect(Collectors.toList());
        return ListUtils.union(specJoinBranchList, specJoinBranchListWithOutput);
    }

    protected SpecJoin newSpecJoin(List<SpecJoinBranch> joinBranchList, DependentRelation relation) {
        SpecJoin specJoin = new SpecJoin();
        specJoin.setBranches(joinBranchList);
        List branchNameList = ListUtils.emptyIfNull(joinBranchList).stream().map(SpecJoinBranch::getName).collect(Collectors.toList());
        SpecLogic specLogic = new SpecLogic();
        specLogic.setExpression(String.join((CharSequence)(" " + relation.name() + " "), branchNameList));
        specJoin.setLogic(specLogic);
        specJoin.setResultStatus(ControllerJoinCode.Status.SUCCESS.getCode());
        return specJoin;
    }

    static {
        RUNTIME.setEngine(CodeProgramType.CONTROLLER_JOIN.getCalcEngineType().getLabel());
        RUNTIME.setCommand(CodeProgramType.CONTROLLER_JOIN.getName());
    }
}

