/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractCommonConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.ParameterConverterFactory;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class SpecNodeListConverter
extends AbstractCommonConverter<List<SpecNode>> {
    private final List<TaskDefinition> taskDefinitionList;
    private static final List<TaskType> TASK_TYPE_ORDER;
    private final SpecWorkflow specWorkflow;
    private final DataWorksWorkflowSpec spec;

    public SpecNodeListConverter(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, List<TaskDefinition> taskDefinitionList, DolphinSchedulerV3ConverterContext context) {
        super(context);
        this.spec = spec;
        this.taskDefinitionList = taskDefinitionList;
        this.specWorkflow = specWorkflow;
    }

    @Override
    public List<SpecNode> convert() {
        Map<String, List<TaskDefinition>> taskTypeMap = ListUtils.emptyIfNull(this.taskDefinitionList).stream().collect(Collectors.groupingBy(TaskDefinition::getTaskType));
        TASK_TYPE_ORDER.forEach(taskType -> ListUtils.emptyIfNull((List)((List)taskTypeMap.get(taskType.name()))).forEach(this::convertTaskDefinition));
        return Optional.ofNullable(this.specWorkflow).map(SpecWorkflow::getNodes).orElse(Optional.ofNullable(this.spec).map(DataWorksWorkflowSpec::getNodes).orElse(Collections.emptyList()));
    }

    private void convertTaskDefinition(TaskDefinition taskDefinition) {
        AbstractParameterConverter converter = ParameterConverterFactory.create(this.spec, this.specWorkflow, taskDefinition, this.context);
        converter.convert();
        this.context.getEntityHeadMap().put(taskDefinition.getCode(), converter.getHeadList());
        this.context.getEntityTailMap().put(taskDefinition.getCode(), converter.getTailList());
    }

    static {
        ArrayList<TaskType> taskTypeOrderList = new ArrayList<TaskType>();
        taskTypeOrderList.add(TaskType.SQL);
        taskTypeOrderList.add(TaskType.SHELL);
        taskTypeOrderList.add(TaskType.PYTHON);
        taskTypeOrderList.add(TaskType.SPARK);
        taskTypeOrderList.add(TaskType.MR);
        taskTypeOrderList.add(TaskType.SQOOP);
        taskTypeOrderList.add(TaskType.SUB_PROCESS);
        taskTypeOrderList.add(TaskType.DEPENDENT);
        taskTypeOrderList.add(TaskType.CONDITIONS);
        for (TaskType value : TaskType.values()) {
            if (taskTypeOrderList.contains(value)) continue;
            taskTypeOrderList.add(value);
        }
        TASK_TYPE_ORDER = Collections.unmodifiableList(taskTypeOrderList);
    }
}

