/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common;

import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.Priority;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.dataworks.migrationx.transformer.flowspec.model.SpecRefEntityWrapper;
import com.aliyun.migrationx.common.utils.UuidUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;

public abstract class AbstractCommonConverter<T> {
    protected final DolphinSchedulerV3ConverterContext context;
    private final Function<Long, String> generateUuidFunc;

    protected AbstractCommonConverter(DolphinSchedulerV3ConverterContext context) {
        this.context = context;
        this.generateUuidFunc = BooleanUtils.isTrue((Boolean)context.getDirectMappingId()) ? String::valueOf : code -> UuidUtils.genUuidWithoutHorizontalLine();
    }

    protected abstract T convert();

    protected Integer convertPriority(Priority priority) {
        return Priority.LOWEST.getCode() - priority.getCode();
    }

    protected String generateUuid(Long code) {
        if (Objects.isNull(code)) {
            return this.generateUuid();
        }
        this.context.getCodeUuidMap().computeIfAbsent(code, this.generateUuidFunc);
        return this.context.getCodeUuidMap().get(code);
    }

    protected String generateUuid(Long code, SpecRefEntity entity) {
        String uuid = this.generateUuid(code);
        if (Objects.nonNull(entity)) {
            entity.setId(uuid);
            this.context.getSpecRefEntityMap().put(uuid, this.newWrapper(entity));
        }
        return uuid;
    }

    protected String generateUuid(SpecRefEntity specRefEntity) {
        return this.generateUuid(null, specRefEntity);
    }

    protected String generateUuid() {
        String uuid = UuidUtils.genUuidWithoutHorizontalLine();
        this.context.getCodeUuidMap().putIfAbsent(Long.valueOf(uuid), uuid);
        return uuid;
    }

    protected SpecFlowDepend newSpecFlowDepend() {
        SpecFlowDepend specFlowDepend = new SpecFlowDepend();
        specFlowDepend.setDepends(new ArrayList());
        return specFlowDepend;
    }

    protected SpecRefEntityWrapper newWrapper(SpecRefEntity entity) {
        return new SpecRefEntityWrapper().setSpecRefEntity(entity);
    }
}

