/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.enums.VariableScopeType;
import com.aliyun.dataworks.common.spec.domain.interfaces.Input;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.DataType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.Direct;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.Flag;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.Property;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v301.ProcessExecutionTypeEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v301.ReleaseState;
import com.aliyun.dataworks.migrationx.transformer.core.utils.CodeGenerateUtils;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.AbstractCommonConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.JSONUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ProcessDefinitionConverter
extends AbstractCommonConverter<ProcessDefinition> {
    private final SpecWorkflow workflow;
    private final DataWorksWorkflowSpec spec;

    public ProcessDefinitionConverter(DataWorksWorkflowSpec spec, SpecWorkflow workflow, ProcessDefinition processDefinition, FlowSpecConverterContext context) {
        super(Objects.nonNull(processDefinition) ? processDefinition : new ProcessDefinition(), context);
        this.workflow = workflow;
        this.spec = spec;
    }

    public ProcessDefinitionConverter(DataWorksWorkflowSpec spec, SpecWorkflow workflow, FlowSpecConverterContext context) {
        this(spec, workflow, null, context);
    }

    @Override
    public ProcessDefinition convert() {
        if (Objects.isNull(this.spec)) {
            throw new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"spec"});
        }
        if (Objects.isNull(this.workflow)) {
            this.convertSpec();
        } else {
            this.convertWorkFlow();
        }
        ((ProcessDefinition)this.result).setVersion(1);
        ((ProcessDefinition)this.result).setReleaseState(BooleanUtils.isTrue((Boolean)this.context.getOnlineProcess()) ? ReleaseState.ONLINE : ReleaseState.OFFLINE);
        ((ProcessDefinition)this.result).setProjectCode(((Long)ObjectUtils.defaultIfNull((Object)this.context.getProjectCode(), (Object)0L)).longValue());
        ((ProcessDefinition)this.result).setCreateTime(new Date());
        ((ProcessDefinition)this.result).setUpdateTime(new Date());
        ((ProcessDefinition)this.result).setFlag(Flag.YES);
        ((ProcessDefinition)this.result).setUserId(((Integer)ObjectUtils.defaultIfNull((Object)this.context.getUserId(), (Object)1)).intValue());
        ((ProcessDefinition)this.result).setUserName(null);
        ((ProcessDefinition)this.result).setProjectName(null);
        ((ProcessDefinition)this.result).setScheduleReleaseState(ReleaseState.OFFLINE);
        ((ProcessDefinition)this.result).setTimeout(0);
        ((ProcessDefinition)this.result).setModifyBy(null);
        ((ProcessDefinition)this.result).setWarningGroupId(null);
        ((ProcessDefinition)this.result).setExecutionType(ProcessExecutionTypeEnum.PARALLEL);
        return (ProcessDefinition)this.result;
    }

    private void convertWorkFlow() {
        if (Objects.isNull(this.workflow.getId())) {
            this.workflow.setId(String.valueOf(CodeGenerateUtils.getInstance().genCode()));
        }
        ((ProcessDefinition)this.result).setId(this.generateId(this.workflow.getId()));
        ((ProcessDefinition)this.result).setCode(this.generateCode(this.workflow.getId()));
        ((ProcessDefinition)this.result).setName(this.generateProcessDefinitionName(this.workflow));
        ((ProcessDefinition)this.result).setDescription(StringUtils.defaultString((String)this.workflow.getDescription()));
        ArrayList<Input> inputList = new ArrayList<Input>(ListUtils.emptyIfNull((List)this.workflow.getInputs()));
        inputList.addAll(ListUtils.emptyIfNull((List)this.spec.getVariables()));
        this.setGlobalParamListAndMap(inputList);
    }

    private void convertSpec() {
        if (Objects.isNull(this.spec.getId())) {
            this.spec.setId(String.valueOf(CodeGenerateUtils.getInstance().genCode()));
        }
        ((ProcessDefinition)this.result).setId(this.generateId(this.spec.getId()));
        ((ProcessDefinition)this.result).setCode(this.generateCode(this.spec.getId()));
        ((ProcessDefinition)this.result).setName(this.generateProcessDefinitionName(this.spec));
        ((ProcessDefinition)this.result).setDescription(StringUtils.defaultString((String)this.spec.getDescription()));
        ArrayList<Input> inputList = new ArrayList<Input>(ListUtils.emptyIfNull((List)this.spec.getVariables()));
        this.setGlobalParamListAndMap(inputList);
    }

    private void setGlobalParamListAndMap(List<Input> inputList) {
        List<Property> globalParamList = this.convertGlobalParam(inputList);
        ((ProcessDefinition)this.result).setGlobalParams(JSONUtils.toJsonString(globalParamList));
        ((ProcessDefinition)this.result).setGlobalParamList(globalParamList);
        Map<String, String> globalParamMap = globalParamList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        ((ProcessDefinition)this.result).setGlobalParamMap(globalParamMap);
    }

    private String generateProcessDefinitionName(SpecWorkflow workflow) {
        if (StringUtils.isNotBlank((CharSequence)workflow.getName())) {
            return workflow.getName();
        }
        return ListUtils.emptyIfNull((List)workflow.getNodes()).stream().map(SpecNode::getName).filter(StringUtils::isNotBlank).findFirst().orElse("unnamed");
    }

    private String generateProcessDefinitionName(DataWorksWorkflowSpec spec) {
        if (StringUtils.isNotBlank((CharSequence)spec.getName())) {
            return spec.getName();
        }
        return ListUtils.emptyIfNull((List)spec.getNodes()).stream().map(SpecNode::getName).filter(StringUtils::isNotBlank).findFirst().orElse("unnamed");
    }

    private List<Property> convertGlobalParam(List<Input> inputList) {
        Set dataTypeNameSet = Arrays.stream(DataType.values()).map(Enum::name).collect(Collectors.toSet());
        return ListUtils.emptyIfNull(inputList).stream().filter(this::checkGlobalVariable).map(v -> {
            Property property = this.newProperty((SpecVariable)v, dataTypeNameSet);
            property.setDirect(Direct.IN);
            return property;
        }).collect(Collectors.toList());
    }

    private boolean checkGlobalVariable(Input input) {
        if (Objects.nonNull(input) && input instanceof SpecVariable) {
            SpecVariable specVariable = (SpecVariable)input;
            return VariableScopeType.FLOW.equals((Object)specVariable.getScope());
        }
        return false;
    }

    private Property newProperty(SpecVariable specVariable, Set<String> dataTypeNameSet) {
        Property property = new Property();
        property.setProp(specVariable.getName());
        property.setValue(specVariable.getValue());
        if (dataTypeNameSet.contains(specVariable.getDescription())) {
            property.setType(DataType.valueOf((String)specVariable.getDescription()));
        } else {
            property.setType(DataType.VARCHAR);
        }
        return property;
    }
}

