/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.parameters.AbstractParameters;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.AbstractNodeConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.python.PythonNodeConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.shell.ShellNodeConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.spark.SparkNodeConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.sql.SqlNodeConverter;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConverterFactory {
    private static final Logger log = LoggerFactory.getLogger(NodeConverterFactory.class);

    private NodeConverterFactory() {
    }

    public static AbstractNodeConverter<? extends AbstractParameters> create(SpecNode specNode, FlowSpecConverterContext context) {
        CodeProgramType codeProgramType = Optional.of(specNode).map(SpecNode::getScript).map(SpecScript::getRuntime).map(SpecScriptRuntime::getCommand).map(CodeProgramType::getNodeTypeByName).orElseThrow(() -> new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"specNode.script.runtime.command"}));
        AbstractNodeConverter converter = NodeConverterFactory.createFromContext(specNode, codeProgramType, context);
        if (converter != null) {
            return converter;
        }
        switch (codeProgramType) {
            case ODPS_SQL: {
                return new SqlNodeConverter(specNode, context);
            }
            case PYODPS: 
            case PYODPS3: {
                return new PythonNodeConverter(specNode, context);
            }
            case SHELL: 
            case DIDE_SHELL: {
                return new ShellNodeConverter(specNode, context);
            }
            case ODPS_SPARK: {
                return new SparkNodeConverter(specNode, context);
            }
        }
        throw new BizException(ErrorCode.UNKNOWN_ENUM_TYPE, new Object[]{"CodeProgramType", codeProgramType});
    }

    private static <P extends AbstractParameters> AbstractNodeConverter<P> createFromContext(SpecNode specNode, CodeProgramType codeProgramType, FlowSpecConverterContext context) {
        Map nodeTypeMap = Optional.ofNullable(context).map(FlowSpecConverterContext::getNodeTypeMap).orElse(Collections.emptyMap());
        String converterClassName = (String)nodeTypeMap.get(codeProgramType.getName());
        if (converterClassName == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(converterClassName);
            Constructor<?> declaredConstructor = clazz.getDeclaredConstructor(SpecNode.class, FlowSpecConverterContext.class);
            return (AbstractNodeConverter)declaredConstructor.newInstance(specNode, context);
        }
        catch (ClassNotFoundException e) {
            log.warn("class not found: {}", (Object)converterClassName, (Object)e);
        }
        catch (NoSuchMethodException e) {
            log.warn("construct method not found: {}", (Object)converterClassName, (Object)e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.warn("error found when new instance, {}", (Object)converterClassName, (Object)e);
        }
        return null;
    }
}

