/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common;

import com.aliyun.dataworks.common.spec.domain.enums.VariableScopeType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.DataType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.Direct;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.Flag;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.Priority;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.Property;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.parameters.AbstractParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v301.TimeoutFlag;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.TaskExecuteType;
import com.aliyun.dataworks.migrationx.transformer.core.utils.CodeGenerateUtils;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.AbstractCommonConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.JSONUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractNodeConverter<P extends AbstractParameters>
extends AbstractCommonConverter<TaskDefinition> {
    private static final String RESOURCE_REFERENCE_REGEX_FORMAT = "%s@resource_reference\\{\"(.*?)\"\\}";
    private static final Set<String> COMMENT_SET = new HashSet<String>();
    protected SpecNode specNode;

    protected AbstractNodeConverter(SpecNode specNode, FlowSpecConverterContext context) {
        super(context);
        this.result = new TaskDefinition();
        this.specNode = specNode;
        this.context = context;
    }

    @Override
    public TaskDefinition convert() {
        if (Objects.isNull(this.specNode)) {
            return null;
        }
        ((TaskDefinition)this.result).setId(this.generateId(this.specNode.getId()));
        ((TaskDefinition)this.result).setCode(this.generateCode(this.specNode.getId()));
        ((TaskDefinition)this.result).setName(this.specNode.getName());
        ((TaskDefinition)this.result).setVersion(1);
        ((TaskDefinition)this.result).setDescription(StringUtils.defaultString((String)this.specNode.getDescription()));
        ((TaskDefinition)this.result).setProjectCode(((Long)ObjectUtils.defaultIfNull((Object)this.context.getProjectCode(), (Object)0L)).longValue());
        ((TaskDefinition)this.result).setUserId(((Integer)ObjectUtils.defaultIfNull((Object)this.context.getUserId(), (Object)1)).intValue());
        this.setTaskType();
        P parameter = this.convertParameter();
        List<Property> localParamList = this.convertLocalParam();
        if (CollectionUtils.isEmpty((Collection)parameter.getLocalParams())) {
            parameter.setLocalParams(localParamList);
        }
        ((TaskDefinition)this.result).setTaskParams(JSONUtils.toJsonString(parameter));
        ((TaskDefinition)this.result).setTaskParamList(localParamList);
        Map<String, String> taskParamMap = localParamList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        ((TaskDefinition)this.result).setTaskParamMap(taskParamMap);
        ((TaskDefinition)this.result).setFlag(Flag.YES);
        ((TaskDefinition)this.result).setIsCache(Flag.NO);
        ((TaskDefinition)this.result).setTaskPriority(this.convertPriority(this.specNode.getPriority()));
        ((TaskDefinition)this.result).setUserName(null);
        ((TaskDefinition)this.result).setProjectName(null);
        ((TaskDefinition)this.result).setWorkerGroup(StringUtils.defaultString((String)this.context.getWorkerGroup(), (String)"default"));
        ((TaskDefinition)this.result).setEnvironmentCode(((Long)ObjectUtils.defaultIfNull((Object)this.context.getEnvironmentCode(), (Object)-1L)).longValue());
        ((TaskDefinition)this.result).setFailRetryTimes(((Integer)ObjectUtils.defaultIfNull((Object)this.specNode.getRerunTimes(), (Object)0)).intValue());
        ((TaskDefinition)this.result).setFailRetryInterval((int)Duration.ofMillis(((Integer)ObjectUtils.defaultIfNull((Object)this.specNode.getRerunInterval(), (Object)0)).intValue()).toMinutes());
        ((TaskDefinition)this.result).setTimeoutFlag(TimeoutFlag.CLOSE);
        ((TaskDefinition)this.result).setTimeoutNotifyStrategy(null);
        ((TaskDefinition)this.result).setTimeout(((Integer)ObjectUtils.defaultIfNull((Object)this.specNode.getTimeout(), (Object)0)).intValue());
        ((TaskDefinition)this.result).setDelayTime(Optional.ofNullable(this.specNode.getTrigger()).map(SpecTrigger::getDelaySeconds).map(delaySeconds -> (delaySeconds + 59) / 60).orElse(0).intValue());
        ((TaskDefinition)this.result).setResourceIds(null);
        ((TaskDefinition)this.result).setCreateTime(new Date());
        ((TaskDefinition)this.result).setUpdateTime(new Date());
        ((TaskDefinition)this.result).setModifyBy(null);
        ((TaskDefinition)this.result).setTaskGroupId(0);
        ((TaskDefinition)this.result).setTaskGroupPriority(0);
        ((TaskDefinition)this.result).setTaskExecuteType(TaskExecuteType.BATCH);
        return (TaskDefinition)this.result;
    }

    protected abstract P convertParameter();

    protected abstract void setTaskType();

    @Override
    protected int generateId(String id) {
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return RandomUtils.nextInt((int)100000000, (int)999999999);
        }
    }

    @Override
    protected long generateCode(String id) {
        long newCode;
        if (Objects.isNull(id)) {
            throw new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"id"});
        }
        Long code = this.context.getIdCodeMap().get(id);
        if (Objects.nonNull(code)) {
            return code;
        }
        try {
            newCode = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            newCode = CodeGenerateUtils.getInstance().genCode();
        }
        this.context.getIdCodeMap().put(id, newCode);
        return newCode;
    }

    protected List<ResourceInfo> convertResourceList(String commentPrefix) {
        ArrayList<ResourceInfo> resourceInfoList = new ArrayList<ResourceInfo>();
        Optional.of(this.specNode).map(SpecNode::getFileResources).ifPresent(specFileResources -> specFileResources.stream().filter(Objects::nonNull).forEach(fileResource -> {
            ResourceInfo resourceInfo = new ResourceInfo();
            String fileName = FilenameUtils.concat((String)StringUtils.defaultString((String)this.context.getDefaultFileResourcePath()), (String)fileResource.getName());
            resourceInfo.setResourceName(fileName);
            resourceInfoList.add(resourceInfo);
        }));
        if (COMMENT_SET.contains(commentPrefix) && CollectionUtils.isEmpty(resourceInfoList)) {
            Pattern pattern = Pattern.compile(String.format(RESOURCE_REFERENCE_REGEX_FORMAT, commentPrefix));
            Optional.of(this.specNode).map(SpecNode::getScript).map(SpecScript::getContent).ifPresent(content -> {
                Matcher matcher = pattern.matcher((CharSequence)content);
                while (matcher.find()) {
                    ResourceInfo resourceInfo = new ResourceInfo();
                    String fileName = FilenameUtils.concat((String)StringUtils.defaultString((String)this.context.getDefaultFileResourcePath()), (String)matcher.group(1));
                    resourceInfo.setResourceName(fileName);
                    resourceInfoList.add(resourceInfo);
                }
            });
        }
        return resourceInfoList;
    }

    protected List<ResourceInfo> convertResourceList() {
        return this.convertResourceList(null);
    }

    private List<Property> convertLocalParam() {
        Set dataTypeNameSet = Arrays.stream(DataType.values()).map(Enum::name).collect(Collectors.toSet());
        ArrayList<Property> localParamList = new ArrayList<Property>();
        Optional.of(this.specNode).map(SpecNode::getScript).map(SpecScript::getParameters).ifPresent(specVariableList -> specVariableList.stream().filter(v -> VariableScopeType.NODE_PARAMETER.equals((Object)v.getScope())).forEach(v -> {
            Property property = this.newProperty((SpecVariable)v, dataTypeNameSet);
            property.setDirect(Direct.IN);
            localParamList.add(property);
        }));
        Optional.of(this.specNode).map(SpecNode::getOutputs).ifPresent(outputList -> outputList.stream().filter(SpecVariable.class::isInstance).map(SpecVariable.class::cast).filter(v -> VariableScopeType.NODE_CONTEXT.equals((Object)v.getScope())).filter(v -> VariableType.NODE_OUTPUT.equals((Object)v.getType())).forEach(v -> {
            Property property = this.newProperty((SpecVariable)v, dataTypeNameSet);
            property.setDirect(Direct.OUT);
            localParamList.add(property);
        }));
        return localParamList;
    }

    private Property newProperty(SpecVariable specVariable, Set<String> dataTypeNameSet) {
        Property property = new Property();
        property.setProp(specVariable.getName());
        property.setValue(specVariable.getValue());
        if (dataTypeNameSet.contains(specVariable.getDescription())) {
            property.setType(DataType.valueOf((String)specVariable.getDescription()));
        } else {
            property.setType(DataType.VARCHAR);
        }
        return property;
    }

    private Priority convertPriority(Integer specPriority) {
        if (Objects.isNull(specPriority)) {
            return Priority.MEDIUM;
        }
        switch (specPriority) {
            case 4: {
                return Priority.HIGHEST;
            }
            case 3: {
                return Priority.HIGH;
            }
            case 1: {
                return Priority.LOW;
            }
            case 0: {
                return Priority.LOWEST;
            }
        }
        return Priority.MEDIUM;
    }

    static {
        COMMENT_SET.add("##");
        COMMENT_SET.add("--");
    }
}

