/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.LocationUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.DagDataSchedule;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.DolphinSchedulerConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.ProcessDefinitionConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.ProcessTaskRelationListConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.TaskDefinitionListConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowSpecDolphinSchedulerV3Converter
implements DolphinSchedulerConverter<DataWorksWorkflowSpec> {
    private static final Logger log = LoggerFactory.getLogger(FlowSpecDolphinSchedulerV3Converter.class);
    private final DataWorksWorkflowSpec spec;
    private final FlowSpecConverterContext context;
    private final DagDataSchedule dagDataSchedule;
    private static final int X_STEP = 350;
    private static final int Y_STEP = 150;

    public FlowSpecDolphinSchedulerV3Converter(DataWorksWorkflowSpec spec, FlowSpecConverterContext context) {
        this.spec = spec;
        this.context = context;
        this.dagDataSchedule = new DagDataSchedule();
    }

    @Override
    public DagDataSchedule convert(DataWorksWorkflowSpec from) {
        if (Objects.isNull(from)) {
            log.error("spec is null");
            throw new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"spec"});
        }
        ProcessDefinition processDefinition = new ProcessDefinitionConverter(from, null, this.context).convert();
        log.info("processDefinition: {}", (Object)processDefinition);
        Object taskDefinitionList = new TaskDefinitionListConverter(from, null, this.context).convert();
        log.info("taskDefinitionList: {}", taskDefinitionList);
        Object processTaskRelationList = new ProcessTaskRelationListConverter(from, null, this.context).convert();
        log.info("processTaskRelationList: {}", processTaskRelationList);
        processDefinition.setLocations(LocationUtils.buildLocations((List)processTaskRelationList, (int)350, (int)150));
        this.dagDataSchedule.setProcessDefinition(processDefinition);
        this.dagDataSchedule.setTaskDefinitionList((List)taskDefinitionList);
        this.dagDataSchedule.setProcessTaskRelationList((List)processTaskRelationList);
        return this.dagDataSchedule;
    }

    public DagDataSchedule convert() {
        return this.convert(this.spec);
    }
}

