/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerBranchCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinSchedulerV3Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.SwitchResultVo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.switchs.SwitchParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchParameterConverter
extends AbstractParameterConverter<SwitchParameters> {
    private static final Logger log = LoggerFactory.getLogger(SwitchParameterConverter.class);

    public SwitchParameterConverter(DagData dagData, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(dagData, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() throws IOException {
        log.info("params : {}", (Object)this.taskDefinition.getTaskParams());
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        dwNode.setType(CodeProgramType.CONTROLLER_BRANCH.getName());
        JsonNode param = (JsonNode)JSONUtils.parseObject((String)this.taskDefinition.getTaskParams(), JsonNode.class);
        SwitchParameters switchParameters = null;
        if (param.get("switchResult") != null) {
            switchParameters = (SwitchParameters)JSONUtils.parseObject((JsonNode)param.get("switchResult"), SwitchParameters.class);
        }
        if (switchParameters == null || switchParameters.getDependTaskList() == null || switchParameters.getDependTaskList().isEmpty()) {
            log.warn("no dependence param {}", (Object)this.taskDefinition.getTaskParams());
            return Arrays.asList(dwNode);
        }
        Long defaultNextCode = switchParameters.getNextNode();
        ArrayList<ControllerBranchCode.Branch> branchList = new ArrayList<ControllerBranchCode.Branch>();
        for (SwitchResultVo switchResultVo : switchParameters.getDependTaskList()) {
            String condition = switchResultVo.getCondition();
            Long nextNodeCode = switchResultVo.getNextNode();
            TaskDefinition branchTask = (TaskDefinition)DolphinSchedulerV3Context.getContext().getTaskCodeMap().get(nextNodeCode);
            if (branchTask == null) continue;
            ControllerBranchCode.Branch branch = new ControllerBranchCode.Branch();
            branch.setCondition(condition);
            String taskName = branchTask.getName();
            String output = this.getDefaultNodeOutput(this.processMeta, taskName);
            branch.setNodeoutput(output);
            branchList.add(branch);
        }
        ControllerBranchCode branchCode = new ControllerBranchCode();
        branchCode.setBranchList(branchList);
        dwNode.setCode(branchCode.getContent());
        return Arrays.asList(dwNode);
    }
}

