/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.procedure.ProcedureParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ProcedureParameterConverter
extends AbstractParameterConverter<ProcedureParameters> {
    public ProcedureParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        String sqlNodeMapStr = this.converterContext.getProperties().getProperty("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", "{}");
        Map sqlTypeNodeTypeMapping = (Map)GsonUtils.fromJsonString((String)sqlNodeMapStr, (Type)new TypeToken<Map<String, DbType>>(){}.getType());
        sqlTypeNodeTypeMapping = Optional.ofNullable(sqlTypeNodeTypeMapping).orElse(new HashMap(1));
        String defaultNodeTypeIfNotSupport = this.getConverterType();
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        DbType codeProgramType = (DbType)sqlTypeNodeTypeMapping.get(((ProcedureParameters)this.parameter).getType());
        String type = Optional.ofNullable(codeProgramType).map(Enum::name).orElse(defaultNodeTypeIfNotSupport);
        dwNode.setType(type);
        DataSource dataSource = this.getDataSourceById(((ProcedureParameters)this.parameter).getDatasource());
        if (dataSource != null) {
            dwNode.setConnection(dataSource.getName());
        }
        String code = ((ProcedureParameters)this.parameter).getMethod();
        code = this.replaceCode(code, dwNode);
        dwNode.setCode(code);
        if (type.startsWith("EMR") || type.startsWith("SPARK")) {
            code = EmrCodeUtils.toEmrCode((Node)dwNode);
        }
        dwNode.setCode(code);
        return Arrays.asList(dwNode);
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.target.unknownNodeTypeAs");
        return this.getConverterType(convertType, CodeProgramType.VIRTUAL.name());
    }
}

