/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinSchedulerV3Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.DependentItem;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.DependentTaskModel;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.dependent.DependentParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentParameterConverter
extends AbstractParameterConverter<DependentParameters> {
    private static final Logger log = LoggerFactory.getLogger(DependentParameterConverter.class);

    public DependentParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        log.info("params : {}", (Object)this.taskDefinition.getTaskParams());
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        dwNode.setType(CodeProgramType.VIRTUAL.name());
        JsonObject param = (JsonObject)GsonUtils.fromJsonString((String)this.taskDefinition.getTaskParams(), JsonObject.class);
        DependentParameters dependentParameters = null;
        if (param.get("dependence") != null) {
            dependentParameters = (DependentParameters)GsonUtils.fromJson((JsonObject)param.getAsJsonObject("dependence"), DependentParameters.class);
        }
        if (dependentParameters == null || dependentParameters.getDependTaskList() == null || dependentParameters.getDependTaskList().isEmpty()) {
            log.warn("no dependence param {}", (Object)this.taskDefinition.getTaskParams());
            return Arrays.asList(dwNode);
        }
        List dependencies = dependentParameters.getDependTaskList();
        List<DwNodeIo> dwNodeIos = this.depTaskToDwNode(dependencies);
        if (dwNode.getInputs() == null) {
            dwNode.setInputs(new ArrayList());
        }
        dwNode.getInputs().addAll(dwNodeIos);
        return Arrays.asList(dwNode);
    }

    private List<DwNodeIo> depTaskToDwNode(List<DependentTaskModel> dependencies) {
        ArrayList<DwNodeIo> dwNodeIos = new ArrayList<DwNodeIo>();
        DolphinSchedulerV3Context context = DolphinSchedulerV3Context.getContext();
        ListUtils.emptyIfNull(dependencies).forEach(dependModel -> ListUtils.emptyIfNull((List)dependModel.getDependItemList()).forEach(depItem -> {
            ProcessDefinition depProcessDefinition = (ProcessDefinition)context.getProcessCodeMap().get(depItem.getDefinitionCode());
            if (depProcessDefinition != null && depItem.getProjectCode() > 0L && depProcessDefinition.getProjectCode() == depItem.getProjectCode()) {
                if (depItem.getDepTaskCode() == 0L) {
                    Map<Long, List<Long>> relations = this.findRelations((DependentItem)depItem);
                    List taskDefinitions = (List)context.getProcessCodeTaskRelationMap().get(depItem.getDefinitionCode());
                    for (TaskDefinition task : CollectionUtils.emptyIfNull((Collection)taskDefinitions)) {
                        if (relations.containsKey(task.getCode())) continue;
                        DwNodeIo dwNodeIo = this.taskToNode(task, depProcessDefinition);
                        dwNodeIos.add(dwNodeIo);
                    }
                } else {
                    TaskDefinition depTask = (TaskDefinition)context.getTaskCodeMap().get(depItem.getDepTaskCode());
                    if (depTask != null) {
                        DwNodeIo dwNodeIo = this.taskToNode(depTask, depProcessDefinition);
                        dwNodeIos.add(dwNodeIo);
                    }
                }
            }
        }));
        return dwNodeIos;
    }

    private Map<Long, List<Long>> findRelations(DependentItem depItem) {
        HashMap<Long, List<Long>> relations = new HashMap<Long, List<Long>>();
        DolphinSchedulerV3Context.getContext().getDagDatas().stream().filter(dag -> dag.getProcessDefinition().getCode() == depItem.getDefinitionCode()).map(dag -> dag.getProcessTaskRelationList()).flatMap(Collection::stream).forEach(s -> {
            List postCodes = (List)relations.get(s.getPreTaskCode());
            if (postCodes == null) {
                relations.put(s.getPreTaskCode(), new ArrayList());
            }
            ((List)relations.get(s.getPreTaskCode())).add(s.getPostTaskCode());
        });
        return relations;
    }

    private DwNodeIo taskToNode(TaskDefinition depTask, ProcessDefinition processDefinition) {
        DwNodeIo crossProjectDepend = new DwNodeIo();
        crossProjectDepend.setParseType(Integer.valueOf(1));
        crossProjectDepend.setData(Joiner.on((String)".").join((Object)this.converterContext.getProject().getName(), (Object)depTask.getProjectName(), new Object[]{processDefinition.getName(), depTask.getName()}));
        return crossProjectDepend;
    }
}

