/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinSchedulerV3Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.dlc.DLCParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLCParameterConverter
extends AbstractParameterConverter<DLCParameters> {
    private static final Logger log = LoggerFactory.getLogger(DLCParameterConverter.class);
    private static final String CMD = "py2sql.py";
    private static final String TABLE_REGEX = "(?i)(INSERT)(\\s+)(OVERWRITE)(\\s+)(?!table\\b)([^ ]+)(\\s+)";
    private static final String TABLE_REPLACEMENT = "$1$2$3 TABLE $5$6";
    private static final Pattern TABLE_PATTERN = Pattern.compile("(?i)(INSERT)(\\s+)(OVERWRITE)(\\s+)(?!table\\b)([^ ]+)(\\s+)");
    private static final String DATE_REPLACEMENT1 = "\\${p_date1}";
    private static final String DATE_param1 = "p_date1";
    private static final String DATE_REPLACEMENT2 = "\\${p_date2}";
    private static final String DATE_param2 = "p_date2";
    private static final String regex1 = "'\\$\\[yyyy-MM-dd-1\\]'";
    private static final String regex11 = "'\\$\\[yyyyMMdd-1\\]'";
    private static final String regex2 = "'\\$\\[yyyy-MM-dd-2\\]'";
    private static final String regex21 = "'\\$\\[yyyyMMdd-2\\]'";
    private static final Pattern DATE_PATTERN1 = Pattern.compile("'\\$\\[yyyy-MM-dd-1\\]'");
    private static final Pattern DATE_PATTERN11 = Pattern.compile("'\\$\\[yyyyMMdd-1\\]'");
    private static final Pattern DATE_PATTERN2 = Pattern.compile("'\\$\\[yyyy-MM-dd-2\\]'");
    private static final Pattern DATE_PATTERN21 = Pattern.compile("'\\$\\[yyyyMMdd-2\\]'");
    private static final Map<String, String> MAPPED_ENGINE = ImmutableMap.of((Object)"da", (Object)"xx");

    public DLCParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        log.info("convert dlf parameter in task: {}", (Object)this.taskDefinition.getName());
        String sqlNodeMapStr = this.converterContext.getProperties().getProperty("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", "{}");
        Map sqlTypeNodeTypeMapping = (Map)GsonUtils.fromJsonString((String)sqlNodeMapStr, (Type)new TypeToken<Map<String, String>>(){}.getType());
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        String codeProgramType = Optional.ofNullable(sqlTypeNodeTypeMapping).map(s -> (String)s.get(((DLCParameters)this.parameter).getType())).orElseGet(() -> {
            if (DbType.DLC.name().equalsIgnoreCase(((DLCParameters)this.parameter).getType())) {
                return CodeProgramType.ODPS_SQL.name();
            }
            if (DbType.ofName((String)((DLCParameters)this.parameter).getType()) != null) {
                return ((DLCParameters)this.parameter).getType();
            }
            String defaultNodeTypeIfNotSupport = this.getSQLConverterType();
            log.warn("using default node Type {} for node {}", (Object)defaultNodeTypeIfNotSupport, (Object)dwNode.getName());
            return defaultNodeTypeIfNotSupport;
        });
        dwNode.setType(codeProgramType);
        Pair<Set<String>, String> paramCode = this.getCode();
        if (paramCode != null) {
            dwNode.setCode(paramCode == null ? null : (String)paramCode.getRight());
            String params = Joiner.on((String)" ").join((Iterable)SetUtils.emptyIfNull((Set)((Set)paramCode.getLeft())));
            if (dwNode.getParameter() != null) {
                dwNode.setParameter(dwNode.getParameter() + " " + params);
            } else {
                dwNode.setParameter(params);
            }
        }
        dwNode.setConnection(this.getConnectionName(codeProgramType));
        log.info("successfully converted task parameter in task {}", (Object)this.taskDefinition.getName());
        return Collections.singletonList(dwNode);
    }

    private Pair<Set<String>, String> getCode() {
        if (this.isByFile()) {
            log.info("task {} read code from file", (Object)this.taskDefinition.getName());
            return this.getCodeByFile();
        }
        log.info("task {} read code from sql", (Object)this.taskDefinition.getName());
        String code = ((DLCParameters)this.parameter).getSql();
        return this.handleSql(code);
    }

    private Pair<Set<String>, String> handleSql(String sql) {
        if (StringUtils.isEmpty((String)sql)) {
            return null;
        }
        String[] lines = sql.split("\\r?\\n");
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line : lines) {
            line = "-- " + line;
            newLines.add(line);
        }
        String commentedSql = StringUtils.join(newLines, (String)" \n");
        sql = this.replaceEngine(sql);
        sql = this.addOverwriteTableKeyWord(sql);
        Pair<String, Set<String>> pair = this.replaceDateParam(sql);
        Set params = (Set)pair.getRight();
        sql = (String)pair.getLeft();
        sql = commentedSql + "\n\nset odps.sql.hive.compatible=true;\n\n" + sql;
        return Pair.of((Object)params, (Object)sql);
    }

    private String replaceEngine(String sql) {
        for (Map.Entry<String, String> entry : MAPPED_ENGINE.entrySet()) {
            String regex = String.format("([\\S]*)(\\s+)%s\\.([^ ]+)\\s+", entry.getKey());
            String replacement = String.format("$1 $2%s.$3 ", entry.getValue());
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(sql);
            sql = matcher.replaceAll(replacement);
        }
        return sql;
    }

    private String addOverwriteTableKeyWord(String sql) {
        Matcher matcher = TABLE_PATTERN.matcher(sql);
        return matcher.replaceAll(TABLE_REPLACEMENT);
    }

    private Pair<String, Set<String>> replaceDateParam(String sql) {
        Matcher matcher21;
        Matcher matcher2;
        Matcher matcher11;
        HashSet<String> params = new HashSet<String>();
        Matcher matcher1 = DATE_PATTERN1.matcher(sql);
        if (matcher1.find()) {
            sql = matcher1.replaceAll(DATE_REPLACEMENT1);
            params.add("p_date1=$[yyyymmdd-1]");
        }
        if ((matcher11 = DATE_PATTERN11.matcher(sql)).find()) {
            sql = matcher11.replaceAll(DATE_REPLACEMENT1);
            params.add("p_date1=$[yyyymmdd-1]");
        }
        if ((matcher2 = DATE_PATTERN2.matcher(sql)).find()) {
            sql = matcher2.replaceAll(DATE_REPLACEMENT2);
            params.add("p_date2=$[yyyymmdd-2]");
        }
        if ((matcher21 = DATE_PATTERN21.matcher(sql)).find()) {
            sql = matcher21.replaceAll(DATE_REPLACEMENT2);
            params.add("p_date2=$[yyyymmdd-2]");
        }
        return Pair.of((Object)sql, params);
    }

    private boolean isByFile() {
        return StringUtils.isBlank((String)((DLCParameters)this.parameter).getSql());
    }

    private Pair<Set<String>, String> getCodeByFile() {
        String fileName = this.taskDefinition.getName() + ".py";
        File dir = TransformerContext.getContext().getCustomResourceDir();
        if (dir == null) {
            log.error("resource dir null, skip dlc resource parse");
            dir = new File("sources");
        }
        if (!dir.exists()) {
            throw new RuntimeException(dir.getAbsolutePath() + " not exists");
        }
        for (File child : Objects.requireNonNull(dir.listFiles())) {
            if (!child.getName().equals(fileName)) continue;
            return this.readfile(child);
        }
        return null;
    }

    private String getCmd() {
        File file;
        String scriptDir = TransformerContext.getContext().getScriptDir();
        if (scriptDir == null) {
            scriptDir = "script/";
        }
        if (!(file = new File(scriptDir)).exists()) {
            throw new RuntimeException("script dir " + file.getAbsolutePath() + " not exists");
        }
        return file.getAbsolutePath() + File.separator + CMD;
    }

    private Pair<Set<String>, String> readfile(File file) {
        String cmd = this.getCmd();
        log.info("dlf read file cmd {}, source {}", (Object)cmd, (Object)file.getAbsolutePath());
        ProcessBuilder processBuilder = new ProcessBuilder("python", cmd, file.getAbsolutePath());
        processBuilder.redirectErrorStream(true);
        try {
            String res;
            Process process = processBuilder.start();
            List lines = IOUtils.readLines((InputStream)IOUtils.toBufferedInputStream((InputStream)process.getInputStream()), (Charset)StandardCharsets.UTF_8);
            log.info("parse python file {} with res: \n {}", (Object)file.getAbsolutePath(), (Object)JSONUtils.toJsonString((Object)lines));
            log.info("waiting for process finished");
            int exitCode = process.waitFor();
            if (exitCode > 0) {
                log.error("python res with code {}", (Object)exitCode);
                throw new RuntimeException("exit with " + exitCode);
            }
            Set<Object> parameters = new HashSet();
            if (lines.size() >= 1) {
                TypeReference<List<String>> type = new TypeReference<List<String>>(){};
                parameters = ((List)JSONUtils.parseObject((String)((String)lines.get(0)), (TypeReference)type)).stream().collect(Collectors.toSet());
                res = String.join((CharSequence)"\n", lines.subList(1, lines.size()));
            } else {
                res = String.join((CharSequence)"\n", lines);
            }
            return Pair.of(parameters, (Object)res);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getConnectionName(String codeProgramType) {
        String mappingJson = this.converterContext.getProperties().getProperty("workflow.converter.connection.mapping");
        if (StringUtils.isNotEmpty((String)mappingJson)) {
            Map connectionMapping = (Map)JSONUtils.parseObject((String)mappingJson, Map.class);
            if (connectionMapping == null) {
                log.error("parse connection mapping with {} error", (Object)mappingJson);
            } else {
                String connectionName = (String)connectionMapping.get(codeProgramType);
                log.info("Got connectionName {} by {}", (Object)connectionName, (Object)codeProgramType);
                return connectionName;
            }
        }
        if (!CodeProgramType.EMR_HIVE.name().equals(codeProgramType) && !CodeProgramType.EMR_SPARK.name().equals(codeProgramType)) {
            List datasources = DolphinSchedulerV3Context.getContext().getDataSources();
            if (((DLCParameters)this.parameter).getDatasource() > 0 && CollectionUtils.isNotEmpty((Collection)datasources)) {
                return CollectionUtils.emptyIfNull((Collection)datasources).stream().filter(Objects::nonNull).filter(s -> s.getId() == ((DLCParameters)this.parameter).getDatasource()).findFirst().map(s -> s.getName()).orElse(null);
            }
        }
        return null;
    }

    private String getSQLConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.commandSqlAs");
        return this.getConverterType(convertType, CodeProgramType.SQL_COMPONENT.name());
    }
}

