/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes;

import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LabelType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecFileResourceType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.BaseDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSourceFactory;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinSchedulerV3Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.ResourceComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.connection.JdbcConnection;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.tenant.EnvType;
import com.aliyun.dataworks.migrationx.transformer.core.loader.ProjectAssetLoader;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.AbstractDolphinSchedulerConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.V3ProcessDefinitionConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksTransformerConfig;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.exception.UnSupportedTypeException;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerV3Converter
extends AbstractDolphinSchedulerConverter {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerV3Converter.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DolphinSchedulerV3Converter.class);
    public static final DolphinSchedulerVersion version = DolphinSchedulerVersion.V2;
    private List<DagData> dagDataList = new ArrayList<DagData>();
    private List<DwWorkflow> dwWorkflowList = new ArrayList<DwWorkflow>();
    private DolphinSchedulerPackage<com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project, DagData, DataSource, ResourceComponent, UdfFunc> dolphinSchedulerPackage;

    public DolphinSchedulerV3Converter(DolphinSchedulerPackage dolphinSchedulerPackage) {
        super(AssetType.DOLPHINSCHEDULER, DolphinSchedulerV3Converter.class.getSimpleName());
        this.dolphinSchedulerPackage = dolphinSchedulerPackage;
    }

    public DolphinSchedulerV3Converter(AssetType assetType, String name) {
        super(assetType, name);
    }

    public DolphinSchedulerV3Converter(AssetType assetType, String name, ProjectAssetLoader projectAssetLoader) {
        super(assetType, name, projectAssetLoader);
    }

    @Override
    public List<DwWorkflow> convert(Asset asset) throws Exception {
        this.dagDataList = this.dolphinSchedulerPackage.getProcessDefinitions().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (this.dagDataList.isEmpty()) {
            throw new RuntimeException("process list empty");
        }
        log.info("dagDataList size: {}", (Object)CollectionUtils.size(this.dagDataList));
        this.findAllSubProcessDefinition(this.dagDataList);
        this.dwWorkflowList = this.convertProcessMetaListToDwWorkflowList(this.dagDataList);
        this.setProjectRootDependForNoInputNode(this.project, this.dwWorkflowList);
        this.convertDataSources(this.project);
        return this.dwWorkflowList;
    }

    private void setResources(DwWorkflow workflow) {
        if (workflow == null) {
            return;
        }
        String engineType = this.properties.getProperty("workflow.converter.target.engine.type", "");
        CalcEngineType calcEngineType = CalcEngineType.valueOf((String)engineType);
        ArrayList<String> paths = new ArrayList<String>();
        DataWorksTransformerConfig config = DataWorksTransformerConfig.getConfig();
        if (config != null) {
            paths.add(calcEngineType.getDisplayName(config.getLocale()));
            paths.add(LabelType.RESOURCE.getDisplayName(config.getLocale()));
        } else {
            paths.add(calcEngineType.getDisplayName(Locale.SIMPLIFIED_CHINESE));
            paths.add(LabelType.RESOURCE.getDisplayName(Locale.SIMPLIFIED_CHINESE));
        }
        String folder = Joiner.on((String)File.separator).join(paths);
        ArrayList<DwResource> resources = new ArrayList<DwResource>();
        List resourceComponents = this.dolphinSchedulerPackage.getResources();
        File dir = TransformerContext.getContext().getSourceDir();
        for (ResourceComponent component : resourceComponents) {
            File file = new File(dir.getAbsolutePath() + File.separator + "resource" + File.separator + "resources" + File.separator + component.getFileName());
            if (!file.exists()) continue;
            DwResource resource = new DwResource();
            resource.setName(component.getFileName());
            resource.setFolder(folder);
            if (component.getFileName().endsWith(".jar")) {
                if (CalcEngineType.EMR.equals((Object)calcEngineType)) {
                    resource.setType(CodeProgramType.EMR_JAR.name());
                } else {
                    if (!CalcEngineType.ODPS.equals((Object)calcEngineType)) continue;
                    resource.setType(CodeProgramType.ODPS_JAR.name());
                }
                resource.setExtend(SpecFileResourceType.JAR.name());
            } else if (component.getFileName().endsWith(".py")) {
                if (!CalcEngineType.ODPS.equals((Object)calcEngineType)) continue;
                resource.setType(CodeProgramType.ODPS_PYTHON.name());
                resource.setExtend(SpecFileResourceType.PYTHON.name());
            } else if (component.getFileName().endsWith(".txt")) {
                if (!CalcEngineType.EMR.equals((Object)calcEngineType)) continue;
                resource.setType(CodeProgramType.EMR_FILE.name());
                resource.setExtend(SpecFileResourceType.FILE.name());
            } else {
                if (!component.getFileName().endsWith(".sh")) continue;
                if (CalcEngineType.EMR.equals((Object)calcEngineType)) {
                    resource.setType(CodeProgramType.EMR_FILE.name());
                } else {
                    if (!CalcEngineType.ODPS.equals((Object)calcEngineType)) continue;
                    resource.setType(CodeProgramType.ODPS_FILE.name());
                }
                resource.setExtend(SpecFileResourceType.FILE.name());
            }
            resource.setLocalPath(file.getAbsolutePath());
            resources.add(resource);
        }
        workflow.getResources().addAll(resources);
    }

    private List<DwWorkflow> convertProcessMetaListToDwWorkflowList(List<DagData> dataList) {
        return ListUtils.emptyIfNull(dataList).stream().map(this::convertProcessMetaToDwWorkflow).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<DwWorkflow> convertProcessMetaToDwWorkflow(DagData processMeta) {
        log.info("convertProcessMetaToDwWorkflow: {}", (Object)processMeta.getProcessDefinition().getName());
        DolphinSchedulerConverterContext<com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project, DagData, DataSource, ResourceComponent, UdfFunc> converterContext = new DolphinSchedulerConverterContext<com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project, DagData, DataSource, ResourceComponent, UdfFunc>();
        converterContext.setProject(this.project);
        converterContext.setProperties(this.properties);
        converterContext.setDolphinSchedulerPackage(this.dolphinSchedulerPackage);
        V3ProcessDefinitionConverter definitionConverter = new V3ProcessDefinitionConverter(converterContext, processMeta);
        try {
            return definitionConverter.convert();
        }
        catch (UnSupportedTypeException e) {
            log.error("", (Throwable)e);
            if (Config.get().isSkipUnSupportType()) {
                return Collections.emptyList();
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void convertDataSources(Project project) {
        project.setDatasources(ListUtils.emptyIfNull((List)this.dolphinSchedulerPackage.getDatasources()).stream().filter(Objects::nonNull).map(ds -> {
            DwDatasource dwDatasource = new DwDatasource();
            dwDatasource.setName(ds.getName());
            dwDatasource.setEnvType(EnvType.PRD.name());
            try {
                dwDatasource.setType(StringUtils.lowerCase((String)ds.getType().name()));
                DbType dbType = DbType.valueOf((String)ds.getType().name());
                BaseDataSource baseDataSource = DataSourceFactory.getDatasource((String)ds.getType().name(), (String)ds.getConnectionParams());
                Optional.ofNullable(baseDataSource).ifPresent(datasource -> {
                    switch (dbType) {
                        case MYSQL: 
                        case POSTGRESQL: 
                        case ORACLE: 
                        case H2: 
                        case DB2: 
                        case CLICKHOUSE: 
                        case SQLSERVER: {
                            this.setJdbcConnection((BaseDataSource)datasource, dwDatasource);
                            break;
                        }
                    }
                });
                dwDatasource.setDescription(ds.getNote());
            }
            catch (Exception e) {
                log.error("can not handle type {}", ds);
                return null;
            }
            return dwDatasource;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void findAllSubProcessDefinition(List<DagData> dagDataList) {
        for (DagData dagData : ListUtils.emptyIfNull(dagDataList)) {
            ProcessDefinition processDefinition = dagData.getProcessDefinition();
            dagData.getTaskDefinitionList().stream().filter(task -> TaskType.SUB_PROCESS.name().equalsIgnoreCase(task.getTaskType())).forEach(task -> {
                JsonObject jsonObject = (JsonObject)GsonUtils.fromJsonString((String)task.getTaskParams(), JsonObject.class);
                if (jsonObject.has("processDefinitionCode")) {
                    Long processDefCode = jsonObject.get("processDefinitionCode").getAsLong();
                    String out = this.getDefaultNodeOutput(processDefinition, task.getName());
                    DolphinSchedulerV3Context.getContext().putSubProcessCodeOutMap(processDefCode, out + ".virtual.start");
                }
            });
        }
    }

    protected String getDefaultNodeOutput(ProcessDefinition processMeta, String taskName) {
        return Joiner.on((String)".").join((Object)this.project.getName(), (Object)processMeta.getProjectName(), new Object[]{processMeta.getName(), taskName});
    }

    private void setJdbcConnection(BaseDataSource datasource, DwDatasource dwDatasource) {
        JdbcConnection conn = new JdbcConnection();
        conn.setUsername(datasource.getUser());
        conn.setPassword(datasource.getPassword());
        conn.setDatabase(datasource.getDatabase());
        conn.setJdbcUrl(datasource.getAddress());
        conn.setTag("public");
        dwDatasource.setConnection(GsonUtils.defaultGson.toJson((Object)conn));
    }
}

