/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecDatasource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.procedure.ProcedureParameters;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class ProcedureParameterConverter
extends AbstractParameterConverter<ProcedureParameters> {
    public ProcedureParameterConverter(Properties properties, SpecWorkflow specWorkflow, DagData processMeta, TaskDefinition taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        this.convertFileResourceList(specNode);
        String dbType = this.getType();
        CodeProgramType codeProgramType = CodeProgramType.of((String)dbType);
        String language = this.codeToLanguageIdentifier(codeProgramType);
        SpecScript script = new SpecScript();
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        String code = ((ProcedureParameters)this.parameter).getMethod();
        code = this.replaceCodeWithParams(code, specVariableList);
        script.setContent(code);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        SpecDatasource datasource = this.getDataSource(codeProgramType);
        specNode.setDatasource(datasource);
        this.postHandle("PROCEDURE", script);
    }

    private String getType() {
        String sqlNodeMapStr = this.properties.getProperty("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", "{}");
        Map sqlTypeNodeTypeMapping = (Map)GsonUtils.fromJsonString((String)sqlNodeMapStr, (Type)new TypeToken<Map<DbType, String>>(){}.getType());
        sqlTypeNodeTypeMapping = Optional.ofNullable(sqlTypeNodeTypeMapping).orElse(new HashMap(1));
        DbType dbType = DbType.valueOf((String)((ProcedureParameters)this.parameter).getType());
        String codeProgramType = (String)sqlTypeNodeTypeMapping.get(dbType);
        return codeProgramType;
    }

    private SpecDatasource getDataSource(CodeProgramType codeProgramType) {
        DataSource dataSource = this.getDataSourceById(((ProcedureParameters)this.parameter).getDatasource());
        String connName = null;
        if (dataSource != null) {
            connName = dataSource.getName();
        }
        String type = null;
        switch (codeProgramType) {
            case MYSQL: {
                type = "mysql";
                break;
            }
            case POSTGRESQL: {
                type = "postgresql";
                break;
            }
            case EMR_HIVE: {
                type = "emr";
                break;
            }
            case CLICK_SQL: {
                type = "clickhouse";
                break;
            }
            case Oracle: {
                type = "oracle";
                break;
            }
            case ODPS_SQL: {
                type = "odps";
            }
        }
        if (connName != null) {
            SpecDatasource datasource = new SpecDatasource();
            datasource.setName(connName);
            datasource.setType(type);
            return datasource;
        }
        return null;
    }
}

