/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.ArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.mr.MapReduceParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.utils.ParameterUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.AbstractParameterConverter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrParameterConverter
extends AbstractParameterConverter<MapReduceParameters> {
    private static final Logger log = LoggerFactory.getLogger(MrParameterConverter.class);
    public static final String MR_YARN_QUEUE = "mapreduce.job.queuename";

    public MrParameterConverter(Properties properties, SpecWorkflow specWorkflow, DagData processMeta, TaskDefinition taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        this.convertFileResourceList(specNode);
        SpecScript script = new SpecScript();
        String type = this.getConverterType();
        CodeProgramType codeProgramType = CodeProgramType.getNodeTypeByName((String)type);
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        String code = this.convertCode(codeProgramType, this.taskDefinition.getName());
        code = this.replaceCodeWithParams(code, specVariableList);
        script.setContent(code);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        this.postHandle("MR", script);
    }

    public String convertCode(CodeProgramType codeProgramType, String taskName) {
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.EMR_MR.name(), (CharSequence)codeProgramType.getName())) {
            String cmd = this.buildCommand((MapReduceParameters)this.parameter);
            return cmd;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.ODPS_MR.name(), (CharSequence)codeProgramType.getName())) {
            ResourceInfo mainJar = ((MapReduceParameters)this.parameter).getMainJar();
            ArrayList<String> codeLines = new ArrayList<String>();
            ArrayList<String> resources = new ArrayList<String>();
            if (mainJar != null) {
                DolphinSchedulerV2Context context = DolphinSchedulerV2Context.getContext();
                String resourceName = CollectionUtils.emptyIfNull((Collection)context.getResources()).stream().filter(r -> r.getId() == mainJar.getId()).findAny().map(r -> r.getName()).orElse("");
                resources.add(resourceName);
                codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)codeProgramType, (String)"", resources));
            }
            String command = Joiner.on((String)" ").join((Object)"jar", (Object)"-resources", new Object[]{Optional.ofNullable(((MapReduceParameters)this.parameter).getMainJar().getName()).orElse(""), "-classpath", Joiner.on((String)",").join(resources), Optional.ofNullable(((MapReduceParameters)this.parameter).getMainClass()).orElse(""), Optional.ofNullable(((MapReduceParameters)this.parameter).getMainArgs()).orElse(""), Optional.ofNullable(((MapReduceParameters)this.parameter).getOthers()).orElse("")});
            codeLines.add(command);
            OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
            odpsSparkCode.setResourceReferences(codeLines);
            odpsSparkCode.setSparkJson(new OdpsSparkCode.CodeJson());
            odpsSparkCode.getSparkJson().setMainClass(((MapReduceParameters)this.parameter).getMainClass());
            odpsSparkCode.getSparkJson().setVersion("2.x");
            odpsSparkCode.getSparkJson().setLanguage("java");
            odpsSparkCode.getSparkJson().setMainJar(((MapReduceParameters)this.parameter).getMainJar().getResourceName());
            odpsSparkCode.getSparkJson().setArgs(((MapReduceParameters)this.parameter).getMainArgs());
            return odpsSparkCode.toString();
        }
        throw new RuntimeException("not support type " + codeProgramType.getName());
    }

    protected String buildCommand(MapReduceParameters mapreduceParameters) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.buildArgs(mapreduceParameters));
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), new HashMap());
        log.info("mapreduce task command: {}", (Object)command);
        return command;
    }

    public List<String> buildArgs(MapReduceParameters param) {
        String mainArgs;
        String queue;
        String others;
        String appName;
        ArrayList<String> args = new ArrayList<String>();
        ResourceInfo mainJar = param.getMainJar();
        if (mainJar != null) {
            String resourceName = mainJar.getResourceName();
            if (resourceName == null) {
                resourceName = this.getResourceNameById(mainJar.getId());
            }
            String resource = DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.EMR_MR, (String)"", Arrays.asList(resourceName));
            args.add(resource + resourceName);
        }
        ProgramType programType = param.getProgramType();
        String mainClass = param.getMainClass();
        if (programType != null && programType != ProgramType.PYTHON && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add(mainClass);
        }
        if (StringUtils.isNotEmpty((CharSequence)(appName = param.getAppName()))) {
            args.add(String.format("%s%s=%s", "-D", "mapreduce.job.name", ArgsUtils.escape((String)appName)));
        }
        if ((StringUtils.isEmpty((CharSequence)(others = param.getOthers())) || !others.contains(MR_YARN_QUEUE)) && StringUtils.isNotEmpty((CharSequence)(queue = param.getQueue()))) {
            args.add(String.format("%s%s=%s", "-D", MR_YARN_QUEUE, queue));
        }
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.mrNodeType");
        String defaultConvertType = CodeProgramType.EMR_MR.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

