/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LabelType;
import com.aliyun.dataworks.common.spec.utils.ReflectUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.ProcessTaskRelation;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.ResourceComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.Property;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.AbstractParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.conditions.ConditionResult;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.conditions.ConditionsParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.datax.DataxParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.dependent.DependentParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.flink.FlinkParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.http.HttpParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.mr.MapReduceParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.procedure.ProcedureParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.python.PythonParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.shell.ShellParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.spark.SparkParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.sql.SqlParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.sqoop.SqoopParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.subprocess.SubProcessParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.switchtask.SwitchParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.ResourceType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.StringUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.AbstractBaseConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.utils.ConverterTypeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksTransformerConfig;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.metrics.DolphinMetrics;
import com.aliyun.migrationx.common.metrics.Metrics;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameterConverter<Parameter extends AbstractParameters> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBaseConverter.class);
    protected final DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext;
    protected final DwWorkflow dwWorkflow;
    protected final DagData dagData;
    protected final ProcessDefinition processMeta;
    protected final List<ProcessTaskRelation> processTaskRelationList;
    protected final TaskDefinition taskDefinition;
    protected final Properties properties;
    protected Parameter parameter;
    protected List<DwWorkflow> workflowList = new ArrayList<DwWorkflow>();
    protected static Map<TaskType, Class<? extends AbstractParameters>> taskTypeClassMap = new HashMap<TaskType, Class<? extends AbstractParameters>>();

    public AbstractParameterConverter(DagData dagData, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        this.converterContext = converterContext;
        this.dagData = dagData;
        this.processMeta = dagData.getProcessDefinition();
        this.processTaskRelationList = dagData.getProcessTaskRelationList();
        this.dwWorkflow = converterContext.getDwWorkflow();
        this.taskDefinition = taskDefinition;
        this.workflowList.add(this.dwWorkflow);
        this.properties = converterContext.getProperties();
    }

    public void convert() throws IOException {
        try {
            List<DwNode> dwNodes = this.doConvert();
            this.markSuccessProcess(dwNodes);
        }
        catch (Throwable e) {
            this.markFailedProcess(e.getMessage());
            throw e;
        }
    }

    protected List<DwNode> doConvert() throws IOException {
        if (this.dwWorkflow.getNodes() == null) {
            this.dwWorkflow.setNodes(new ArrayList());
        }
        if (this.dwWorkflow.getResources() == null) {
            this.dwWorkflow.setResources(new ArrayList());
        }
        if (this.dwWorkflow.getFunctions() == null) {
            this.dwWorkflow.setFunctions(new ArrayList());
        }
        TaskType taskType = TaskType.of((String)this.taskDefinition.getTaskType());
        LOGGER.info("converting parameter of task: {}, type: {}", (Object)this.taskDefinition.getName(), (Object)taskType);
        try {
            this.parameter = (AbstractParameters)GsonUtils.fromJsonString((String)this.taskDefinition.getTaskParams(), (Type)TypeToken.get(taskTypeClassMap.get(taskType)).getType());
        }
        catch (Exception ex) {
            LOGGER.error("parse task {}, {}, parameter {} error: ", new Object[]{taskType, taskTypeClassMap.get(taskType), ex});
        }
        List<DwNode> dwNodes = this.convertParameter();
        LOGGER.info("convert task: {}, type: {} done.", (Object)this.taskDefinition.getName(), (Object)taskType);
        return dwNodes;
    }

    protected abstract List<DwNode> convertParameter() throws IOException;

    protected String getDefaultNodeOutput(ProcessDefinition processMeta, String taskName) {
        return Joiner.on((String)".").join((Object)this.converterContext.getProject().getName(), (Object)processMeta.getProjectName(), new Object[]{processMeta.getName(), taskName});
    }

    protected DwNode newDwNode(TaskDefinition taskDefinition) {
        DwNode dwNode = new DwNode();
        dwNode.setWorkflowRef((Workflow)this.dwWorkflow);
        this.dwWorkflow.getNodes().add(dwNode);
        dwNode.setName(StringUtils.toValidName((String)taskDefinition.getName()));
        dwNode.setDescription(taskDefinition.getDescription());
        dwNode.setRawNodeType(Optional.ofNullable(ReflectUtils.getFieldValue(this.parameter, (String)"type")).filter(type -> type instanceof DbType).map(type -> Joiner.on((String)".").join((Object)taskDefinition.getTaskType(), type, new Object[0])).orElse(taskDefinition.getTaskType()));
        dwNode.setDependentType(Integer.valueOf(0));
        dwNode.setCycleType(Integer.valueOf(0));
        dwNode.setNodeUseType(NodeUseType.SCHEDULED);
        if (taskDefinition.getFailRetryTimes() > 0) {
            dwNode.setRerunMode(RerunMode.ALL_ALLOWED);
        } else {
            dwNode.setRerunMode(RerunMode.FAILURE_ALLOWED);
        }
        dwNode.setTaskRerunTime(Integer.valueOf(taskDefinition.getFailRetryTimes()));
        dwNode.setTaskRerunInterval(Integer.valueOf(taskDefinition.getFailRetryInterval() * 1000 * 60));
        this.setOutputs(dwNode);
        dwNode.setParameter(this.getParameter());
        Set<TaskDefinition> preTasks = this.listPreTasks();
        this.setInputs(dwNode, preTasks);
        this.setSubProcessInputs(dwNode);
        SetUtils.emptyIfNull(preTasks).stream().filter(preTask -> TaskType.CONDITIONS.name().equals(preTask.getTaskType())).forEach(preTask -> {
            ConditionResult conditionResult = (ConditionResult)GsonUtils.fromJsonString((String)taskDefinition.getTaskParams(), ConditionResult.class);
            Optional.ofNullable(conditionResult.getSuccessNode()).filter(successNode -> ListUtils.emptyIfNull((List)successNode).stream().anyMatch(n -> n.longValue() == taskDefinition.getCode())).ifPresent(successNode -> {
                String successInput = this.getDefaultNodeOutput(this.processMeta, Joiner.on((String)"_").join((Object)preTask.getName(), (Object)"join", new Object[]{"success"}));
                ListUtils.emptyIfNull((List)dwNode.getInputs()).stream().filter(in -> org.apache.commons.lang3.StringUtils.equals((CharSequence)this.getDefaultNodeOutput(this.processMeta, preTask.getName()), (CharSequence)in.getData())).findFirst().ifPresent(in -> in.setData(successInput));
            });
            Optional.ofNullable(conditionResult.getFailedNode()).filter(failureNode -> ListUtils.emptyIfNull((List)failureNode).stream().anyMatch(n -> n.longValue() == taskDefinition.getCode())).ifPresent(failureNode -> {
                String failureInput = this.getDefaultNodeOutput(this.processMeta, Joiner.on((String)"_").join((Object)preTask.getName(), (Object)"join", new Object[]{"failure"}));
                ListUtils.emptyIfNull((List)dwNode.getInputs()).stream().filter(in -> org.apache.commons.lang3.StringUtils.equals((CharSequence)this.getDefaultNodeOutput(this.processMeta, preTask.getName()), (CharSequence)in.getData())).findFirst().ifPresent(in -> in.setData(failureInput));
            });
        });
        dwNode.setResourceGroup(this.properties.getProperty("workflow.converter.target.schedule.resGroupIdentifier", null));
        return dwNode;
    }

    protected String getParameter() {
        String globalParams;
        ArrayList paramList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)this.parameter.getLocalParams())) {
            List localParamList = ListUtils.emptyIfNull((List)this.parameter.getLocalParams()).stream().map(property -> property.getProp() + "=" + property.getValue()).collect(Collectors.toList());
            paramList.addAll(localParamList);
        }
        if (Config.get().isIncludeGlobalParam() && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(globalParams = this.processMeta.getGlobalParams()))) {
            List globalProperties = (List)JSONUtils.parseObject((String)globalParams, (TypeReference)new TypeReference<List<Property>>(){});
            List globalList = globalProperties.stream().map(property -> property.getProp() + "=" + property.getValue()).filter(s -> !paramList.contains(s)).collect(Collectors.toList());
            paramList.addAll(globalList);
        }
        String paraStr = Joiner.on((String)" ").join(paramList);
        return paraStr;
    }

    protected void setOutputs(DwNode dwNode) {
        DwNodeIo output = new DwNodeIo();
        output.setData(this.getDefaultNodeOutput(this.processMeta, this.taskDefinition.getName()));
        output.setParseType(Integer.valueOf(1));
        output.setNodeRef((Node)dwNode);
        dwNode.setOutputs(new ArrayList<DwNodeIo>(Collections.singletonList(output)));
    }

    protected void setInputs(DwNode dwNode, Set<TaskDefinition> preTasks) {
        List inputIo = SetUtils.emptyIfNull(preTasks).stream().map(upTask -> {
            DwNodeIo input = new DwNodeIo();
            input.setParseType(Integer.valueOf(1));
            input.setNodeRef((Node)dwNode);
            input.setData(Joiner.on((String)".").join((Object)this.converterContext.getProject().getName(), (Object)this.processMeta.getProjectName(), new Object[]{this.processMeta.getName(), upTask.getName()}));
            return input;
        }).collect(Collectors.toList());
        dwNode.getInputs().addAll(inputIo);
    }

    protected Set<TaskDefinition> listPreTasks() {
        List relations = this.dagData.getProcessTaskRelationList();
        Set preCodes = relations.stream().filter(r -> r.getPostTaskCode() == this.taskDefinition.getCode()).map(ProcessTaskRelation::getPreTaskCode).collect(Collectors.toSet());
        return this.dagData.getTaskDefinitionList().stream().filter(task -> preCodes.contains(task.getCode())).collect(Collectors.toSet());
    }

    private Set<TaskDefinition> listPostTasks() {
        List relations = this.dagData.getProcessTaskRelationList();
        Set postCodes = relations.stream().filter(r -> r.getPreTaskCode() == this.taskDefinition.getCode()).map(ProcessTaskRelation::getPostTaskCode).collect(Collectors.toSet());
        return this.dagData.getTaskDefinitionList().stream().filter(task -> postCodes.contains(task.getCode())).collect(Collectors.toSet());
    }

    private boolean isRootNode(long processCode, long taskCode) {
        return DolphinSchedulerV2Context.getContext().getDagDatas().stream().filter(dag -> dag.getProcessDefinition().getCode() == processCode).map(dag -> dag.getProcessTaskRelationList()).flatMap(Collection::stream).filter(task -> task.getPostTaskCode() == taskCode).filter(task -> task.getPreTaskCode() == 0L).findAny().isPresent();
    }

    private void setSubProcessInputs(DwNode dwNode) {
        if (!this.isRootNode(this.processMeta.getCode(), this.taskDefinition.getCode())) {
            return;
        }
        List outs = DolphinSchedulerV2Context.getContext().getSubProcessCodeMap(Long.valueOf(this.processMeta.getCode()));
        for (String virtualOut : CollectionUtils.emptyIfNull((Collection)outs)) {
            DwNodeIo input = new DwNodeIo();
            input.setData(virtualOut);
            input.setParseType(Integer.valueOf(1));
            input.setNodeRef((Node)dwNode);
            if (dwNode.getInputs() == null) {
                dwNode.setInputs(new ArrayList());
            }
            dwNode.getInputs().add(input);
        }
    }

    public List<DwWorkflow> getWorkflowList() {
        return this.workflowList;
    }

    protected void markSuccessProcess(List<DwNode> nodes) {
        for (DwNode node : nodes) {
            DolphinMetrics metrics = DolphinMetrics.builder().projectName(this.taskDefinition.getProjectName()).projectCode(Long.valueOf(this.taskDefinition.getProjectCode())).processName(this.processMeta.getName()).processCode(Long.valueOf(this.processMeta.getCode())).taskName(this.taskDefinition.getName()).taskCode(Long.valueOf(this.taskDefinition.getCode())).taskType(this.taskDefinition.getTaskType()).build();
            metrics.setWorkflowName(this.dwWorkflow.getName());
            metrics.setDwName(node.getName());
            metrics.setDwType(node.getType());
            TransformerContext.getCollector().markSuccessMiddleProcess((Metrics)metrics);
        }
    }

    protected void markFailedProcess(String errorMsg) {
        DolphinMetrics metrics = DolphinMetrics.builder().projectName(this.taskDefinition.getProjectName()).projectCode(Long.valueOf(this.taskDefinition.getProjectCode())).processName(this.processMeta.getName()).processCode(Long.valueOf(this.processMeta.getCode())).taskName(this.taskDefinition.getName()).taskCode(Long.valueOf(this.taskDefinition.getCode())).taskType(this.taskDefinition.getTaskType()).build();
        metrics.setWorkflowName(this.dwWorkflow.getName());
        metrics.setErrorMsg(errorMsg);
        TransformerContext.getCollector().markFailedMiddleProcess((Metrics)metrics);
    }

    protected String getConverterType(String convertType, String defaultConvertType) {
        String projectName = this.processMeta.getProjectName();
        String processName = this.processMeta.getName();
        String taskName = this.taskDefinition.getName();
        return ConverterTypeUtils.getConverterType(convertType, projectName, processName, taskName, defaultConvertType);
    }

    protected String replaceCode(String code, DwNode dwNode) {
        if (Config.get().getReplaceMapping() == null) {
            return code;
        }
        for (Config.Replaced pattern : Config.get().getReplaceMapping()) {
            if (!this.taskDefinition.getTaskType().equalsIgnoreCase(pattern.getTaskType())) continue;
            Matcher matcher = pattern.getParsedPattern().matcher(code);
            if (matcher.find()) {
                String param = " " + pattern.getParam();
                dwNode.setParameter(dwNode.getParameter() + param);
            }
            code = matcher.replaceAll(pattern.getTarget());
        }
        return code;
    }

    protected String replaceResourceFullName(Map<String, String> resourceMap, String code) {
        if (MapUtils.isEmpty(resourceMap)) {
            return code;
        }
        for (Map.Entry<String, String> entry : resourceMap.entrySet()) {
            code = code.replace(entry.getKey(), entry.getValue());
        }
        return code;
    }

    protected Map<String, String> handleResourcesReference() {
        HashMap<String, String> resourceNames = new HashMap<String, String>();
        for (ResourceInfo resourceInfo : this.parameter.getResourceFilesList()) {
            ResourceComponent resourceComponent = this.getResourceById(resourceInfo.getId());
            if (resourceComponent == null) continue;
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)resourceComponent.getFileName())) {
                resourceComponent.setFileName(resourceComponent.getName());
            }
            resourceInfo.setResourceName(resourceComponent.getFileName());
            resourceInfo.setFullName(resourceComponent.getFullName());
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)resourceInfo.getName())) {
                resourceInfo.setName(resourceComponent.getName());
            }
            DwResource dwResource = this.buildResource(resourceInfo);
            resourceNames.put(resourceComponent.getFullName(), resourceComponent.getFileName());
            this.dwWorkflow.getResources().add(dwResource);
        }
        return resourceNames;
    }

    private DwResource buildResource(ResourceInfo resourceInfo) {
        ArrayList<String> paths;
        DwResource pyRes = new DwResource();
        pyRes.setName(resourceInfo.getResourceName());
        pyRes.setWorkflowRef(this.dwWorkflow);
        String engineType = this.properties.getProperty("workflow.converter.target.engine.type", "");
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)CalcEngineType.EMR.name(), (CharSequence)engineType)) {
            if (resourceInfo.getResourceName().endsWith(".jar")) {
                pyRes.setType(CodeProgramType.EMR_JAR.name());
                pyRes.setExtend(ResourceType.JAR.name());
            } else {
                pyRes.setType(CodeProgramType.EMR_FILE.name());
                pyRes.setExtend(ResourceType.FILE.name());
            }
            paths = new ArrayList<String>();
            DataWorksTransformerConfig config = DataWorksTransformerConfig.getConfig();
            if (config != null) {
                paths.add(CalcEngineType.EMR.getDisplayName(config.getLocale()));
                paths.add(LabelType.RESOURCE.getDisplayName(config.getLocale()));
            } else {
                paths.add(CalcEngineType.EMR.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                paths.add(LabelType.RESOURCE.getDisplayName(Locale.SIMPLIFIED_CHINESE));
            }
            pyRes.setFolder(Joiner.on((String)File.separator).join(paths));
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)CalcEngineType.ODPS.name(), (CharSequence)engineType)) {
            if (resourceInfo.getResourceName().endsWith(".jar")) {
                pyRes.setType(CodeProgramType.ODPS_JAR.name());
                pyRes.setExtend(ResourceType.JAR.name());
            } else if (resourceInfo.getResourceName().endsWith(".sql")) {
                pyRes.setType(CodeProgramType.ODPS_SQL.name());
                pyRes.setExtend(ResourceType.FILE.name());
            } else {
                pyRes.setType(CodeProgramType.ODPS_FILE.name());
                pyRes.setExtend(ResourceType.FILE.name());
            }
            paths = new ArrayList();
            DataWorksTransformerConfig config = DataWorksTransformerConfig.getConfig();
            if (config != null) {
                paths.add(CalcEngineType.HADOOP_CDH.getDisplayName(config.getLocale()));
                paths.add(LabelType.RESOURCE.getDisplayName(config.getLocale()));
            } else {
                paths.add(CalcEngineType.HADOOP_CDH.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                paths.add(LabelType.RESOURCE.getDisplayName(Locale.SIMPLIFIED_CHINESE));
            }
            pyRes.setFolder(Joiner.on((String)File.separator).join(paths));
        }
        String source = Config.get().getSource() + File.separator + "resource" + File.separator + resourceInfo.getFullName();
        pyRes.setLocalPath(source);
        return pyRes;
    }

    protected ResourceComponent getResourceById(Integer id) {
        if (id == null) {
            return null;
        }
        DolphinSchedulerV2Context context = DolphinSchedulerV2Context.getContext();
        return CollectionUtils.emptyIfNull((Collection)context.getResources()).stream().filter(r -> r.getId() == id.intValue()).findAny().orElse(null);
    }

    protected String getResourceNameById(Integer id) {
        ResourceComponent resourceComponent = this.getResourceById(id);
        if (resourceComponent == null) {
            return null;
        }
        String name = resourceComponent.getFileName();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)name)) {
            name = resourceComponent.getName();
        }
        return name;
    }

    static {
        taskTypeClassMap.put(TaskType.SQL, SqlParameters.class);
        taskTypeClassMap.put(TaskType.DEPENDENT, DependentParameters.class);
        taskTypeClassMap.put(TaskType.FLINK, FlinkParameters.class);
        taskTypeClassMap.put(TaskType.SPARK, SparkParameters.class);
        taskTypeClassMap.put(TaskType.DATAX, DataxParameters.class);
        taskTypeClassMap.put(TaskType.SHELL, ShellParameters.class);
        taskTypeClassMap.put(TaskType.HTTP, HttpParameters.class);
        taskTypeClassMap.put(TaskType.PROCEDURE, ProcedureParameters.class);
        taskTypeClassMap.put(TaskType.CONDITIONS, ConditionsParameters.class);
        taskTypeClassMap.put(TaskType.SQOOP, SqoopParameters.class);
        taskTypeClassMap.put(TaskType.SUB_PROCESS, SubProcessParameters.class);
        taskTypeClassMap.put(TaskType.PYTHON, PythonParameters.class);
        taskTypeClassMap.put(TaskType.MR, MapReduceParameters.class);
        taskTypeClassMap.put(TaskType.SWITCH, SwitchParameters.class);
    }
}

