/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.SparkArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.spark.SparkParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.translator.TranslateUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkParameterConverter
extends AbstractParameterConverter<SparkParameters> {
    private static final Logger log = LoggerFactory.getLogger(SparkParameterConverter.class);

    public SparkParameterConverter(ProcessMeta processMeta, TaskNode taskDefinition, DolphinSchedulerConverterContext<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        Optional.ofNullable((SparkParameters)this.parameter).map(SparkParameters::getMainJar).flatMap(mainJar -> ListUtils.emptyIfNull((List)this.converterContext.getDolphinSchedulerPackage().getResources()).stream().filter(res -> Objects.equals(res.getId(), mainJar.getId())).findFirst()).ifPresent(res -> ((SparkParameters)this.parameter).setMainJar(res));
        ListUtils.emptyIfNull((List)Optional.ofNullable((SparkParameters)this.parameter).map(SparkParameters::getResourceFilesList).orElse(ListUtils.emptyIfNull(null))).forEach(res -> ListUtils.emptyIfNull((List)this.converterContext.getDolphinSchedulerPackage().getResources()).stream().filter(res1 -> Objects.equals(res1.getId(), res.getId())).forEach(res1 -> {
            BeanUtils.copyProperties((Object)res1, (Object)res);
            res.setRes(res1.getName());
            res.setName(res1.getName());
        }));
        DwNode dwNode = this.newDwNode(this.processMeta, this.taskDefinition);
        dwNode.setType(this.properties.getProperty("workflow.converter.sparkSubmitAs", CodeProgramType.DIDE_SHELL.name()));
        dwNode.setParameter(Joiner.on((String)" ").join((Iterable)ListUtils.emptyIfNull((List)((SparkParameters)this.parameter).getLocalParams()).stream().map(property -> property.getProp() + "=" + property.getValue()).collect(Collectors.toList())));
        List resources = ListUtils.emptyIfNull((List)((SparkParameters)this.parameter).getResourceFilesList()).stream().filter(Objects::nonNull).map(ResourceInfo::getName).distinct().collect(Collectors.toList());
        ArrayList<String> codeLines = new ArrayList<String>();
        codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)dwNode.getType()), (String)"", resources));
        String sparkCmd = Joiner.on((String)" ").join((Iterable)SparkArgsUtils.buildArgs((SparkParameters)((SparkParameters)this.parameter)).stream().map(String::valueOf).collect(Collectors.toList()));
        dwNode.setCode(sparkCmd);
        log.info("node: {}, spark command: {}", (Object)dwNode.getName(), (Object)sparkCmd);
        TranslateUtils.translateSparkSubmit(dwNode, this.properties);
        codeLines.add(dwNode.getCode());
        dwNode.setCode(codeLines.stream().filter(Objects::nonNull).collect(Collectors.joining("\n")));
        dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        return Arrays.asList(dwNode);
    }
}

