/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.Property;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.shell.ShellParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DefaultNodeTypeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.translator.HiveEofDelimiterCommandSqlTranslator;
import com.aliyun.dataworks.migrationx.transformer.core.translator.SqoopToDITranslator;
import com.aliyun.dataworks.migrationx.transformer.core.translator.TranslateUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.AbstractParameterConverter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellParameterConverter
extends AbstractParameterConverter<ShellParameters> {
    private static final Logger log = LoggerFactory.getLogger(ShellParameterConverter.class);

    public ShellParameterConverter(ProcessMeta processMeta, TaskNode taskDefinition, DolphinSchedulerConverterContext<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        DwNode dwNode = this.newDwNode(this.processMeta, this.taskDefinition);
        String converterType = this.getShellConverterType();
        dwNode.setType(converterType);
        dwNode.setCode(((ShellParameters)this.parameter).getRawScript());
        List resources = ListUtils.emptyIfNull((List)((ShellParameters)this.parameter).getResourceFilesList()).stream().map(ResourceInfo::getName).distinct().collect(Collectors.toList());
        ArrayList<String> codeLines = new ArrayList<String>();
        codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)dwNode.getType()), (String)"", resources));
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.DIDE_SHELL.name(), (CharSequence)dwNode.getType())) {
            dwNode.setParameter(Joiner.on((String)" ").join((Iterable)ListUtils.emptyIfNull((List)((ShellParameters)this.parameter).getLocalParams()).stream().map(Property::getValue).collect(Collectors.toList())));
            String codeArgPredefine = ListUtils.emptyIfNull((List)((ShellParameters)this.parameter).getLocalParams()).stream().map(property -> property.getProp() + "=" + property.getValue()).collect(Collectors.joining("\n"));
            codeLines.add(codeArgPredefine);
        }
        codeLines.add(((ShellParameters)this.parameter).getRawScript());
        dwNode.setCode(Joiner.on((String)"\n").join(codeLines));
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.EMR_SHELL.name(), (CharSequence)dwNode.getType())) {
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        }
        boolean changed = TranslateUtils.translate(this.dwWorkflow, dwNode, Collections.singletonList(SqoopToDITranslator.class), () -> CodeProgramType.DI);
        String sqlConverterType = this.getSQLConverterType(dwNode.getType());
        if (!changed) {
            CodeProgramType nodeType = DefaultNodeTypeUtils.getTypeByName((String)sqlConverterType, (CodeProgramType)CodeProgramType.DIDE_SHELL);
            changed = TranslateUtils.translate(this.dwWorkflow, dwNode, Collections.singletonList(HiveEofDelimiterCommandSqlTranslator.class), () -> nodeType);
        }
        if (!changed) {
            changed = TranslateUtils.translateSparkSubmit(dwNode, this.properties);
        }
        if (!changed) {
            changed = TranslateUtils.translateCommandSql(this.dwWorkflow, dwNode, sqlConverterType);
        }
        log.info("node: {}, type: {}, translation changed: {}", new Object[]{dwNode.getName(), dwNode.getType(), changed});
        return Arrays.asList(dwNode);
    }

    private String getShellConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.shellNodeType");
        String defaultConvertType = CodeProgramType.DIDE_SHELL.name();
        return this.getConverterType(convertType, defaultConvertType);
    }

    private String getSQLConverterType(String defaultConvertType) {
        String convertType = this.properties.getProperty("workflow.converter.commandSqlAs");
        return this.getConverterType(convertType, defaultConvertType);
    }
}

