/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.CronExpressUtil;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import java.text.ParseException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessDefinitionConverter<Project, ProcessDefinitionType, DataSource, ResourceInfo, UdfFunction> {
    private static final Logger log = LoggerFactory.getLogger(ProcessDefinitionConverter.class);
    protected final ProcessDefinitionType processDefinition;
    protected final DolphinSchedulerConverterContext<Project, ProcessDefinitionType, DataSource, ResourceInfo, UdfFunction> converterContext;

    public ProcessDefinitionConverter(DolphinSchedulerConverterContext<Project, ProcessDefinitionType, DataSource, ResourceInfo, UdfFunction> converterContext, ProcessDefinitionType processDefinition) {
        this.converterContext = converterContext;
        this.processDefinition = processDefinition;
    }

    public abstract List<DwWorkflow> convert();

    public abstract List<DwWorkflow> getWorkflowList();

    protected String convertCrontab(String scheduleCrontab) {
        try {
            return CronExpressUtil.quartzCronExpressionToDwCronExpress((String)scheduleCrontab);
        }
        catch (ParseException e) {
            log.error("convert quartz cron expression error: ", (Throwable)e);
            return "day";
        }
    }
}

