/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerJoinCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.conditions.ConditionsParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.dependent.DependentParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionsParameterConverter
extends AbstractParameterConverter<ConditionsParameters> {
    private static final Logger log = LoggerFactory.getLogger(ConditionsParameterConverter.class);

    public ConditionsParameterConverter(ProcessMeta processMeta, TaskNode taskDefinition, DolphinSchedulerConverterContext<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() throws IOException {
        DependentParameters dependencies = this.taskDefinition.getDependence();
        log.info("dependencies: {}", (Object)GsonUtils.toJsonString((Object)dependencies));
        AtomicInteger outerRelationIndex = new AtomicInteger(0);
        List taskDepJoinNodes = ListUtils.emptyIfNull((List)Optional.ofNullable(dependencies).map(DependentParameters::getDependTaskList).orElse(null)).stream().map(dependentTaskModel -> {
            DwNode joinNode = this.newDwNode(this.processMeta, this.taskDefinition);
            joinNode.setType(CodeProgramType.CONTROLLER_JOIN.name());
            joinNode.setName(Joiner.on((String)"_").join((Object)joinNode.getName(), (Object)"join", new Object[]{outerRelationIndex.getAndIncrement()}));
            ListUtils.emptyIfNull((List)joinNode.getOutputs()).stream().findFirst().ifPresent(out -> out.setData(this.getDefaultNodeOutput(this.processMeta, joinNode.getName())));
            List branchList = ListUtils.emptyIfNull((List)dependentTaskModel.getDependItemList()).stream().filter(dependentItem -> StringUtils.isNotBlank((CharSequence)dependentItem.getDepTasks()) && dependentItem.getStatus() != null).map(dependentItem -> {
                ControllerJoinCode.Branch branch = new ControllerJoinCode.Branch();
                switch (dependentTaskModel.getRelation()) {
                    case OR: {
                        branch.setLogic(Integer.valueOf(1));
                        break;
                    }
                    case AND: {
                        branch.setLogic(Integer.valueOf(0));
                    }
                }
                branch.setNode(this.getDefaultNodeOutput(this.processMeta, dependentItem.getDepTasks()));
                switch (dependentItem.getStatus()) {
                    case FAILURE: {
                        branch.setRunStatus(Collections.singletonList("0"));
                        break;
                    }
                    case SUCCESS: {
                        branch.setRunStatus(Collections.singletonList("1"));
                    }
                }
                return branch;
            }).collect(Collectors.toList());
            ControllerJoinCode joinCode = new ControllerJoinCode();
            joinCode.setBranchList(branchList);
            switch (dependentTaskModel.getRelation()) {
                case AND: {
                    joinCode.setResultStatus("0");
                    break;
                }
                case OR: {
                    joinCode.setResultStatus("1");
                }
            }
            joinNode.setCode(joinCode.getContent());
            return joinNode;
        }).collect(Collectors.toList());
        DwNode joinSuccessNode = this.newDwNode(this.processMeta, this.taskDefinition);
        joinSuccessNode.setType(CodeProgramType.CONTROLLER_JOIN.name());
        joinSuccessNode.setName(Joiner.on((String)"_").join((Object)joinSuccessNode.getName(), (Object)"join", new Object[]{"success"}));
        ControllerJoinCode joinSuccessCode = new ControllerJoinCode();
        joinSuccessCode.setBranchList(ListUtils.emptyIfNull(taskDepJoinNodes).stream().map(Node::getOutputs).flatMap(Collection::stream).map(NodeIo::getData).distinct().map(out -> {
            ControllerJoinCode.Branch branch = new ControllerJoinCode.Branch();
            switch (dependencies.getRelation()) {
                case OR: {
                    branch.setLogic(Integer.valueOf(1));
                    break;
                }
                case AND: {
                    branch.setLogic(Integer.valueOf(0));
                }
            }
            branch.setNode(out);
            branch.setRunStatus(Collections.singletonList("1"));
            return branch;
        }).collect(Collectors.toList()));
        joinSuccessCode.setResultStatus("1");
        joinSuccessNode.setCode(joinSuccessCode.getContent());
        ListUtils.emptyIfNull((List)joinSuccessNode.getOutputs()).stream().findFirst().ifPresent(out -> out.setData(this.getDefaultNodeOutput(this.processMeta, joinSuccessNode.getName())));
        joinSuccessNode.setInputs(ListUtils.emptyIfNull(taskDepJoinNodes).stream().map(Node::getOutputs).flatMap(Collection::stream).collect(Collectors.toList()));
        DwNode joinFailureNode = this.newDwNode(this.processMeta, this.taskDefinition);
        joinFailureNode.setType(CodeProgramType.CONTROLLER_JOIN.name());
        joinFailureNode.setName(Joiner.on((String)"_").join((Object)joinFailureNode.getName(), (Object)"join", new Object[]{"failure"}));
        ControllerJoinCode joinFailureCode = new ControllerJoinCode();
        joinFailureCode.setBranchList(ListUtils.emptyIfNull(taskDepJoinNodes).stream().map(Node::getOutputs).flatMap(Collection::stream).map(NodeIo::getData).distinct().map(out -> {
            ControllerJoinCode.Branch branch = new ControllerJoinCode.Branch();
            switch (dependencies.getRelation()) {
                case OR: {
                    branch.setLogic(Integer.valueOf(1));
                    break;
                }
                case AND: {
                    branch.setLogic(Integer.valueOf(0));
                }
            }
            branch.setNode(out);
            branch.setRunStatus(Collections.singletonList("1"));
            return branch;
        }).collect(Collectors.toList()));
        joinFailureCode.setResultStatus("0");
        joinFailureNode.setCode(joinFailureCode.getContent());
        ListUtils.emptyIfNull((List)joinFailureNode.getOutputs()).stream().findFirst().ifPresent(out -> out.setData(this.getDefaultNodeOutput(this.processMeta, joinFailureNode.getName())));
        joinFailureNode.setInputs(ListUtils.emptyIfNull(taskDepJoinNodes).stream().map(Node::getOutputs).flatMap(Collection::stream).collect(Collectors.toList()));
        return Arrays.asList(joinSuccessNode, joinFailureNode);
    }
}

