/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters;

import com.aliyun.dataworks.common.spec.utils.ReflectUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.AbstractParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.conditions.ConditionsParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.datax.DataxParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.dependent.DependentParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.flink.FlinkParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.http.HttpParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.mr.MapReduceParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.procedure.ProcedureParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.python.PythonParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.shell.ShellParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.spark.SparkParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.sql.SqlParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.sqoop.SqoopParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.subprocess.SubProcessParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.StringUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.utils.ConverterTypeUtils;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.metrics.DolphinMetrics;
import com.aliyun.migrationx.common.metrics.Metrics;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameterConverter<Parameter extends AbstractParameters> {
    private static final Logger log = LoggerFactory.getLogger(AbstractParameterConverter.class);
    protected final DolphinSchedulerConverterContext<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> converterContext;
    protected final DwWorkflow dwWorkflow;
    protected final ProcessMeta processMeta;
    protected final ProcessData processData;
    protected final TaskNode taskDefinition;
    protected final Properties properties;
    protected Parameter parameter;
    protected List<DwWorkflow> workflowList = new ArrayList<DwWorkflow>();
    protected static Map<TaskType, Class<? extends AbstractParameters>> taskTypeClassMap = new HashMap<TaskType, Class<? extends AbstractParameters>>();

    public AbstractParameterConverter(ProcessMeta processMeta, TaskNode taskDefinition, DolphinSchedulerConverterContext<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> converterContext) {
        this.converterContext = converterContext;
        this.processMeta = processMeta;
        this.processData = processMeta.getProcessDefinitionJson();
        this.dwWorkflow = converterContext.getDwWorkflow();
        this.taskDefinition = taskDefinition;
        this.workflowList.add(this.dwWorkflow);
        this.properties = converterContext.getProperties();
    }

    public void convert() throws IOException {
        try {
            List<DwNode> dwNodes = this.doConvert();
            this.markSuccessProcess(dwNodes);
        }
        catch (Throwable e) {
            this.markFailedProcess(e.getMessage());
            throw e;
        }
    }

    private List<DwNode> doConvert() throws IOException {
        if (this.dwWorkflow.getNodes() == null) {
            this.dwWorkflow.setNodes(new ArrayList());
        }
        if (this.dwWorkflow.getResources() == null) {
            this.dwWorkflow.setResources(new ArrayList());
        }
        if (this.dwWorkflow.getFunctions() == null) {
            this.dwWorkflow.setFunctions(new ArrayList());
        }
        TaskType taskType = this.taskDefinition.getType();
        log.info("converting parameter of task: {}, type: {}", (Object)this.taskDefinition.getName(), (Object)taskType);
        try {
            this.parameter = (AbstractParameters)GsonUtils.fromJsonString((String)this.taskDefinition.getParams(), (Type)TypeToken.get(taskTypeClassMap.get(taskType)).getType());
        }
        catch (Exception ex) {
            log.error("parse task {}, {}, parameter {} error: ", new Object[]{taskType, taskTypeClassMap.get(taskType), ex});
        }
        List<DwNode> dwNodes = this.convertParameter();
        log.info("convert task: {}, type: {} done.", (Object)this.taskDefinition.getName(), (Object)taskType);
        return dwNodes;
    }

    protected abstract List<DwNode> convertParameter() throws IOException;

    protected String getDefaultNodeOutput(ProcessMeta processMeta, String taskName) {
        return Joiner.on((String)".").join((Object)this.converterContext.getProject().getName(), (Object)processMeta.getProjectName(), new Object[]{processMeta.getProcessDefinitionName(), taskName});
    }

    protected DwNode newDwNode(ProcessMeta processMeta, TaskNode taskDefinition) {
        DwNode dwNode = new DwNode();
        dwNode.setWorkflowRef((Workflow)this.dwWorkflow);
        this.dwWorkflow.getNodes().add(dwNode);
        dwNode.setName(StringUtils.toValidName((String)taskDefinition.getName()));
        dwNode.setDescription(taskDefinition.getDesc());
        dwNode.setRawNodeType(Optional.ofNullable(ReflectUtils.getFieldValue(this.parameter, (String)"type")).filter(type -> type instanceof DbType).map(type -> Joiner.on((String)".").join((Object)taskDefinition.getType(), type, new Object[0])).orElse(taskDefinition.getType().name()));
        dwNode.setDependentType(Integer.valueOf(0));
        dwNode.setCycleType(Integer.valueOf(0));
        dwNode.setNodeUseType(NodeUseType.SCHEDULED);
        if (taskDefinition.getMaxRetryTimes() > 0) {
            dwNode.setRerunMode(RerunMode.ALL_ALLOWED);
        } else {
            dwNode.setRerunMode(RerunMode.FAILURE_ALLOWED);
        }
        dwNode.setTaskRerunTime(Integer.valueOf(taskDefinition.getMaxRetryTimes()));
        dwNode.setTaskRerunInterval(Integer.valueOf(taskDefinition.getRetryInterval() * 1000 * 60));
        DwNodeIo output = new DwNodeIo();
        output.setData(this.getDefaultNodeOutput(processMeta, taskDefinition.getName()));
        output.setParseType(Integer.valueOf(1));
        output.setNodeRef((Node)dwNode);
        dwNode.setOutputs(new ArrayList<DwNodeIo>(Collections.singletonList(output)));
        dwNode.setParameter(this.getParameter());
        List connects = processMeta.getProcessDefinitionConnects();
        dwNode.setInputs(ListUtils.emptyIfNull((List)connects).stream().filter(connect -> org.apache.commons.lang3.StringUtils.equals((CharSequence)connect.getEndPointTargetId(), (CharSequence)taskDefinition.getId())).map(connect -> {
            List upstreamTask = Optional.ofNullable(this.processData).map(ProcessData::getTasks).map(tasks -> ListUtils.emptyIfNull((List)tasks).stream().filter(task -> org.apache.commons.lang3.StringUtils.equals((CharSequence)task.getId(), (CharSequence)connect.getEndPointSourceId())).collect(Collectors.toList())).orElse(null);
            return ListUtils.emptyIfNull((List)upstreamTask).stream().map(upTask -> {
                DwNodeIo input = new DwNodeIo();
                input.setParseType(Integer.valueOf(1));
                input.setNodeRef((Node)dwNode);
                input.setData(Joiner.on((String)".").join((Object)this.converterContext.getProject().getName(), (Object)processMeta.getProjectName(), new Object[]{processMeta.getProcessDefinitionName(), upTask.getName()}));
                return input;
            }).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList()));
        List preTasks = (List)GsonUtils.fromJsonString((String)taskDefinition.getPreTasks(), (Type)new TypeToken<List<String>>(){}.getType());
        ListUtils.emptyIfNull((List)processMeta.getProcessDefinitionJson().getTasks()).stream().filter(taskNode -> ListUtils.emptyIfNull((List)preTasks).stream().anyMatch(preTask -> org.apache.commons.lang3.StringUtils.equals((CharSequence)preTask, (CharSequence)taskNode.getName()))).filter(preTaskNode -> TaskType.CONDITIONS.equals((Object)preTaskNode.getType())).forEach(preConditionTaskNode -> {
            ConditionsParameters conditionResult = preConditionTaskNode.getConditionResult();
            log.info("condition result: {}", (Object)GsonUtils.toJsonString((Object)conditionResult));
            Optional.ofNullable(conditionResult).map(ConditionsParameters::getSuccessNode).filter(successNode -> ListUtils.emptyIfNull((List)successNode).stream().anyMatch(n -> org.apache.commons.lang3.StringUtils.equals((CharSequence)n, (CharSequence)taskDefinition.getName()))).ifPresent(successNode -> {
                String successInput = this.getDefaultNodeOutput(processMeta, Joiner.on((String)"_").join((Object)preConditionTaskNode.getName(), (Object)"join", new Object[]{"success"}));
                ListUtils.emptyIfNull((List)dwNode.getInputs()).stream().filter(in -> org.apache.commons.lang3.StringUtils.equals((CharSequence)this.getDefaultNodeOutput(processMeta, preConditionTaskNode.getName()), (CharSequence)in.getData())).findFirst().ifPresent(in -> in.setData(successInput));
            });
            Optional.ofNullable(conditionResult).map(ConditionsParameters::getFailedNode).filter(failureNode -> ListUtils.emptyIfNull((List)failureNode).stream().anyMatch(n -> org.apache.commons.lang3.StringUtils.equals((CharSequence)n, (CharSequence)taskDefinition.getName()))).ifPresent(failureNode -> {
                String failureInput = this.getDefaultNodeOutput(processMeta, Joiner.on((String)"_").join((Object)preConditionTaskNode.getName(), (Object)"join", new Object[]{"failure"}));
                ListUtils.emptyIfNull((List)dwNode.getInputs()).stream().filter(in -> org.apache.commons.lang3.StringUtils.equals((CharSequence)this.getDefaultNodeOutput(processMeta, preConditionTaskNode.getName()), (CharSequence)in.getData())).findFirst().ifPresent(in -> in.setData(failureInput));
            });
        });
        return dwNode;
    }

    protected String getParameter() {
        List globalParams;
        ArrayList paramList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)this.parameter.getLocalParams())) {
            List localParamList = ListUtils.emptyIfNull((List)this.parameter.getLocalParams()).stream().map(property -> property.getProp() + "=" + property.getValue()).collect(Collectors.toList());
            paramList.addAll(localParamList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(globalParams = this.processData.getGlobalParams()))) {
            List globalList = globalParams.stream().map(property -> property.getProp() + "=" + property.getValue()).filter(s -> !paramList.contains(s)).collect(Collectors.toList());
            paramList.addAll(globalList);
        }
        String paraStr = Joiner.on((String)" ").join(paramList);
        return paraStr;
    }

    public List<DwWorkflow> getWorkflowList() {
        return this.workflowList;
    }

    protected void markSuccessProcess(List<DwNode> nodes) {
        for (DwNode node : nodes) {
            DolphinMetrics metrics = DolphinMetrics.builder().projectName(this.processMeta.getProjectName()).processName(this.processMeta.getProcessDefinitionName()).taskName(this.taskDefinition.getName()).taskType(this.taskDefinition.getType().name()).build();
            metrics.setWorkflowName(this.dwWorkflow.getName());
            metrics.setDwName(node.getName());
            metrics.setDwType(node.getType());
            TransformerContext.getCollector().markSuccessMiddleProcess((Metrics)metrics);
        }
    }

    protected void markFailedProcess(String errorMsg) {
        DolphinMetrics metrics = DolphinMetrics.builder().projectName(this.processMeta.getProjectName()).processName(this.processMeta.getProcessDefinitionName()).taskName(this.taskDefinition.getName()).taskType(this.taskDefinition.getType().name()).build();
        metrics.setWorkflowName(this.dwWorkflow.getName());
        metrics.setErrorMsg(errorMsg);
        TransformerContext.getCollector().markFailedMiddleProcess((Metrics)metrics);
    }

    protected String getConverterType(String convertType, String defaultConvertType) {
        String projectName = this.processMeta.getProjectName();
        String processName = this.processMeta.getProcessDefinitionName();
        String taskName = this.taskDefinition.getName();
        return ConverterTypeUtils.getConverterType(convertType, projectName, processName, taskName, defaultConvertType);
    }

    static {
        taskTypeClassMap.put(TaskType.SQL, SqlParameters.class);
        taskTypeClassMap.put(TaskType.DEPENDENT, DependentParameters.class);
        taskTypeClassMap.put(TaskType.FLINK, FlinkParameters.class);
        taskTypeClassMap.put(TaskType.SPARK, SparkParameters.class);
        taskTypeClassMap.put(TaskType.DATAX, DataxParameters.class);
        taskTypeClassMap.put(TaskType.SHELL, ShellParameters.class);
        taskTypeClassMap.put(TaskType.HTTP, HttpParameters.class);
        taskTypeClassMap.put(TaskType.PROCEDURE, ProcedureParameters.class);
        taskTypeClassMap.put(TaskType.CONDITIONS, ConditionsParameters.class);
        taskTypeClassMap.put(TaskType.SQOOP, SqoopParameters.class);
        taskTypeClassMap.put(TaskType.SUB_PROCESS, SubProcessParameters.class);
        taskTypeClassMap.put(TaskType.PYTHON, PythonParameters.class);
        taskTypeClassMap.put(TaskType.MR, MapReduceParameters.class);
    }
}

