/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.utils;

import com.aliyun.migrationx.common.utils.Config;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinFilter {
    private static final Logger log = LoggerFactory.getLogger(DolphinFilter.class);

    public static boolean willConvert(String processName, String releaseState, List<String> codes) {
        String state;
        Config.ProcessFilter filter = Config.get().getProcessFilter();
        if (filter != null && (state = filter.getReleaseState()) != null) {
            if (releaseState != null && releaseState.equals(state)) {
                return true;
            }
            boolean includeSubProcess = filter.isIncludeSubProcess();
            if (includeSubProcess && DolphinFilter.isInSubProcess(codes)) {
                log.info("filterProcess: {} state: {} in subprocess", (Object)processName, (Object)releaseState);
                return true;
            }
            log.warn("filterProcess: {} state: {} is not equals {}, skip", new Object[]{processName, releaseState, state});
            return false;
        }
        return true;
    }

    private static boolean isInSubProcess(List<String> codes) {
        return codes != null;
    }
}

