/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.azkaban;

import azkaban.utils.Props;
import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.azkaban.objects.CommandJob;
import com.aliyun.dataworks.migrationx.domain.dataworks.azkaban.objects.Job;
import com.aliyun.dataworks.migrationx.domain.dataworks.azkaban.objects.JobType;
import com.aliyun.dataworks.migrationx.domain.dataworks.azkaban.service.AzkabanPackageParser;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DefaultNodeTypeUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.RawNodeType;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.AbstractBaseConverter;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzkabanConverter
extends AbstractBaseConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzkabanConverter.class);
    private Project project;
    private Properties properties = new Properties();

    public AzkabanConverter() {
        super(AssetType.AZKABAN, AzkabanConverter.class.getSimpleName());
    }

    public AzkabanConverter(AssetType assetType, String name) {
        super(assetType, name);
    }

    @Override
    public List<DwWorkflow> convert(Asset asset) throws Exception {
        Preconditions.checkArgument((this.project != null ? 1 : 0) != 0, (Object)"project not set");
        Preconditions.checkArgument((asset.getPath() != null && asset.getPath().exists() ? 1 : 0) != 0, (Object)"invalid asset path");
        File[] subDirs = asset.getPath().listFiles(File::isDirectory);
        File[] files = asset.getPath().listFiles(File::isFile);
        ArrayList<File> dirs = new ArrayList<File>();
        if (subDirs == null || subDirs.length == 0) {
            dirs.add(asset.getPath());
        } else if (files == null || files.length == 0) {
            dirs.addAll(Arrays.asList(subDirs));
        } else {
            dirs.add(asset.getPath());
        }
        this.workflowList = dirs.stream().map(this::processDirWorkflow).flatMap(Collection::stream).collect(Collectors.toList());
        ListUtils.emptyIfNull((List)this.workflowList).forEach(wf -> ListUtils.emptyIfNull((List)wf.getNodes()).forEach(n -> NodeUtils.setProjectRootDependencyIfIsolated((Project)this.project, (DwWorkflow)wf, (Node)n)));
        return this.workflowList;
    }

    private List<DwWorkflow> processDirWorkflow(File dir) {
        AzkabanPackageParser parser = new AzkabanPackageParser();
        try {
            parser.parse(dir);
        }
        catch (Exception e) {
            LOGGER.error("parse azkaban package error: ", (Throwable)e);
            throw BizException.of((ErrorCode)ErrorCode.PACKAGE_ANALYZE_FAILED).with(new Object[]{e.getMessage()});
        }
        return this.convertAzkabanPackage(parser);
    }

    private List<DwWorkflow> convertAzkabanPackage(AzkabanPackageParser parser) {
        Map flowJobs = parser.getFlowJobs();
        return MapUtils.emptyIfNull((Map)flowJobs).entrySet().stream().map(ent -> {
            String flowName = (String)ent.getKey();
            List jobs = (List)ent.getValue();
            DwWorkflow workflow = new DwWorkflow();
            workflow.setScheduled(Boolean.valueOf(true));
            workflow.setName(NodeUtils.normalizedFileName((String)flowName));
            workflow.setVersion(WorkflowVersion.V3);
            ListUtils.emptyIfNull((List)jobs).stream().forEach(job -> {
                Props props = Optional.ofNullable(parser.getJobProperties(flowName, job.getName())).orElse(new Props());
                List<Node> nodes = this.jobToNode((Job)job, workflow, props.toAllProperties());
                nodes.stream().forEach(n -> ((DwNode)n).setWorkflowRef((Workflow)workflow));
                workflow.getNodes().addAll(nodes);
                List<DwResource> dwResources = this.jobToResource((Job)job, workflow);
                ListUtils.emptyIfNull(dwResources).stream().forEach(r -> r.setWorkflowRef(workflow));
                workflow.getResources().addAll(dwResources);
            });
            return workflow;
        }).collect(Collectors.toList());
    }

    private List<DwResource> jobToResource(Job job, DwWorkflow workflow) {
        String engineType = this.properties.getProperty("workflow.converter.target.engine.type");
        CalcEngineType calcEngineType = CalcEngineType.valueOf((String)engineType);
        String nodeMarketEngineType = DefaultNodeTypeUtils.convertToNodeMarketModelEngineTypes((CalcEngineType)calcEngineType);
        return ListUtils.emptyIfNull((List)job.getRelatedFiles()).stream().map(file -> {
            DwResource dwResource = new DwResource();
            dwResource.setName(file.getName());
            dwResource.setOdps(Boolean.valueOf(false));
            dwResource.setLocalPath(file.getAbsolutePath());
            dwResource.setWorkflowRef(workflow);
            if (file.getName().endsWith(".jar")) {
                CodeProgramType type = DefaultNodeTypeUtils.getJarResourceType((String)nodeMarketEngineType);
                dwResource.setType(type.name());
            } else {
                CodeProgramType type = DefaultNodeTypeUtils.getFileResourceType((String)nodeMarketEngineType);
                dwResource.setType(type.name());
            }
            dwResource.setOriginResourceName(file.getName());
            return dwResource;
        }).collect(Collectors.toList());
    }

    private List<String> parseCodeParameters(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return ListUtils.emptyIfNull(null);
        }
        Pattern pattern = Pattern.compile("\\$\\{[\\w\\.]+\\}");
        Matcher matcher = pattern.matcher(code);
        HashSet<String> params = new HashSet<String>();
        while (matcher.find()) {
            String param = matcher.group();
            param = param.replaceAll("\\$\\{", "").replaceAll("\\}", "");
            params.add(param);
        }
        return new ArrayList<String>(params);
    }

    private String processJobParameters(Job job, Properties jobProperty, String type, List<String> params) {
        AtomicInteger paramIndex = new AtomicInteger(0);
        return Joiner.on((String)" ").join((Iterable)ListUtils.emptyIfNull(params).stream().map(p -> {
            String rawValue = Optional.ofNullable(jobProperty.getProperty((String)p)).orElse("UNDEFINED_VARIABLE_VALUE");
            String value = ListUtils.emptyIfNull(this.parseCodeParameters(rawValue)).stream().filter(StringUtils::isNotBlank).map(paramInValue -> Optional.ofNullable(jobProperty.getProperty((String)paramInValue)).map(val -> StringUtils.replace((String)rawValue, (String)("${" + paramInValue + "}"), (String)val)).orElse(rawValue)).reduce((a, b) -> b).orElse(rawValue);
            int index = paramIndex.incrementAndGet();
            if (!DefaultNodeTypeUtils.isNoCalcEngineShell((String)type)) {
                return Joiner.on((String)"=").join(p, (Object)value, new Object[0]);
            }
            ((CommandJob)job).getCommands().add(index - 1, Joiner.on((String)"=").join(p, (Object)("$" + index), new Object[0]));
            return value;
        }).collect(Collectors.toList()));
    }

    private List<Node> jobToNode(Job job, DwWorkflow workflow, Properties jobProperty) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DwNode dwNode = new DwNode();
        dwNode.setName(job.getName());
        dwNode.setIsAutoParse(Integer.valueOf(0));
        dwNode.setType(this.getNodeType(job.getType()));
        dwNode.setRawNodeType(Optional.ofNullable(this.getRawNodeType(job.getType())).map(Enum::name).orElse(job.getType().name()));
        dwNode.setNodeUseType(BooleanUtils.isTrue((Boolean)workflow.getScheduled()) ? NodeUseType.SCHEDULED : NodeUseType.MANUAL_WORKFLOW);
        dwNode.setWorkflowRef((Workflow)workflow);
        DwNodeIo dwNodeIo = new DwNodeIo();
        dwNodeIo.setNodeRef((Node)dwNode);
        dwNodeIo.setData(Joiner.on((String)".").join((Object)this.project.getName(), (Object)workflow.getName(), new Object[]{dwNode.getName()}));
        dwNodeIo.setParseType(Integer.valueOf(1));
        dwNodeIo.setNodeRef((Node)dwNode);
        dwNode.setOutputs(Collections.singletonList(dwNodeIo));
        dwNode.setCronExpress("day");
        dwNode.setInputs(ListUtils.emptyIfNull((List)job.getDependencies()).stream().map(dependency -> {
            DwNodeIo input = new DwNodeIo();
            if (StringUtils.contains((CharSequence)dependency, (CharSequence)"@")) {
                input.setData(StringUtils.replace((String)dependency, (String)"@", (String)"."));
            } else {
                input.setData(Joiner.on((String)".").join((Object)workflow.getName(), dependency, new Object[0]));
            }
            input.setData(Joiner.on((String)".").join((Object)this.project.getName(), (Object)input.getData(), new Object[0]));
            input.setParseType(Integer.valueOf(1));
            input.setNodeRef((Node)dwNode);
            return input;
        }).collect(Collectors.toList()));
        dwNode.setParameter(this.processJobParameters(job, jobProperty, dwNode.getType(), this.parseCodeParameters(job.getCode())));
        dwNode.setCode(job.getCode());
        if (CollectionUtils.isNotEmpty((Collection)job.getRelatedFiles())) {
            dwNode.setCode(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)dwNode.getType()), (String)dwNode.getCode(), (Collection)ListUtils.emptyIfNull((List)job.getRelatedFiles()).stream().map(File::getName).collect(Collectors.toList())));
        }
        dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        LOGGER.info("jobType: {}, jobClz: {}", (Object)job.getType(), job.getClass());
        nodes.add((Node)dwNode);
        return nodes;
    }

    private RawNodeType getRawNodeType(JobType type) {
        switch (type) {
            case noop: {
                return RawNodeType.AZKABAN_NOOP;
            }
            case command: {
                return RawNodeType.AZKABAN_COMMAND;
            }
            case hive: {
                return RawNodeType.AZKABAN_HIVE;
            }
            case flow: {
                return RawNodeType.AZKABAN_FLOW;
            }
        }
        return null;
    }

    private String getNodeType(JobType type) {
        switch (type) {
            case noop: 
            case flow: {
                return CodeProgramType.VIRTUAL.name();
            }
            case command: {
                return this.properties.getProperty("workflow.converter.shellNodeType", CodeProgramType.EMR_SHELL.name());
            }
            case hive: {
                return this.properties.getProperty("workflow.converter.sqlNodeType", CodeProgramType.EMR_HIVE.name());
            }
        }
        String unsupportedType = this.getDefaultTypeIfNotSupported(this.properties, CodeProgramType.DIDE_SHELL);
        if (StringUtils.isNotBlank((CharSequence)unsupportedType)) {
            return unsupportedType;
        }
        throw new RuntimeException("unsupported azkaban job type: " + type);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

