/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.FunctionType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwFunction;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Function;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.DeployType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Flow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.FunctionCode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.DmMajorVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.transformer.core.utils.ZipUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.AbstractBaseConverter;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1MigrationPackageConverter
extends AbstractBaseConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(V1MigrationPackageConverter.class);
    public static final String FULL_DIR = "full";
    public static final String NOT_FULL_DIR = "notfull";
    public static final String CODES_DIR = "codes";
    public static final String NODES_DIR = "nodes";
    public static final String FUNCTIONS_DIR = "functions";
    public static final String RESOURCES_DIR = "resources";
    public static final String NODE_RUN_TYPE_MANUAL = "manual";
    public static final String NODE_RUN_TYPE_PAUSE = "pause";
    public static final String NODE_RUN_TYPE_NORMAL = "normal";
    private static final String DEFAULT_WORKFLOW_NAME = "migration_workflows";
    private static final char WORKFLOW_NAME_SEPARATOR = '_';
    public static final Map<String, String> NODE_TYPE_TO_FILE_EXT = new HashMap<String, String>();
    public static final Map<String, String> RESOURCE_TYPE_TO_FILE_EXT = new HashMap<String, String>();
    public static final Map<String, String> NODE_TYPE_MAP = new HashMap<String, String>();
    private List<Function> functionList;
    private List<DwResource> resourceList;

    public V1MigrationPackageConverter() {
        super(AssetType.V1_EXPORT, V1MigrationPackageConverter.class.getSimpleName());
    }

    @Override
    public List<DwWorkflow> convert(Asset asset) throws Exception {
        Preconditions.checkNotNull((Object)asset, (Object)"asset is null");
        Preconditions.checkNotNull((Object)asset.getPath(), (Object)"vi migration package directory is null");
        Preconditions.checkArgument((boolean)asset.getPath().exists(), (Object)"unzipped v1 migration package directory not exists");
        LOGGER.info("unzipping v1 migration package ...");
        File unzippedPath = ZipUtils.unzipExportFile(asset.getPath());
        LOGGER.info("unzip v1 migration package success");
        Project project = this.readV1MigrationProject(unzippedPath);
        return this.convertV1Project(project);
    }

    private List<DwWorkflow> convertV1Project(Project project) {
        List<DwWorkflow> workflowList = this.convertWorkflows(project);
        this.resourceList = this.convertResources(project);
        this.functionList = this.convertFunctions(project);
        return workflowList;
    }

    private List<Function> convertFunctions(Project project) {
        return ListUtils.emptyIfNull((List)project.getFunctions()).stream().map(function -> {
            DwFunction dwFunction = new DwFunction();
            dwFunction.setDmMajorVersion(DmMajorVersion.DATAWORKS_V1.name());
            dwFunction.setName(function.getName());
            dwFunction.setType(CodeProgramType.ODPS_FUNCTION.name());
            dwFunction.setFunctionType(FunctionType.OTHER.name());
            dwFunction.setIsOdps(function.getIsOdps());
            dwFunction.setConnection(function.getConnection());
            if (StringUtils.isNotBlank((CharSequence)function.getFolderPath())) {
                String[] folders = function.getFolderPath().split("/");
                if (folders.length > 1) {
                    dwFunction.setFolder(Joiner.on((String)"/").join(Arrays.asList(folders).subList(1, folders.length)));
                }
                if (StringUtils.isNotBlank((CharSequence)function.getFilePath()) && new File(function.getFilePath()).exists()) {
                    try {
                        String code = IOUtils.toString((Reader)new FileReader(function.getFilePath()));
                        FunctionCode functionCode = (FunctionCode)GsonUtils.gson.fromJson(code, new TypeToken<FunctionCode>(){}.getType());
                        if (functionCode != null) {
                            dwFunction.setClazz(functionCode.getClassName());
                            dwFunction.setResource(functionCode.getResources());
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("read function code failed: ", (Throwable)e);
                    }
                }
            }
            return dwFunction;
        }).collect(Collectors.toList());
    }

    private List<DwResource> convertResources(Project project) {
        List resList = ListUtils.emptyIfNull((List)project.getResources()).stream().map(resource -> {
            String[] folders;
            DwResource dwResource = new DwResource();
            dwResource.setDmMajorVersion(DmMajorVersion.DATAWORKS_V1.name());
            dwResource.setName(resource.getName());
            if (StringUtils.isNotBlank((CharSequence)resource.getFolderPath()) && (folders = resource.getFolderPath().split("/")).length > 1) {
                dwResource.setFolder(Joiner.on((String)"/").join(Arrays.asList(folders).subList(1, folders.length)));
            }
            dwResource.setOdps(resource.getIsOdps());
            dwResource.setType(resource.getType());
            dwResource.setConnection(resource.getConnection());
            dwResource.setLocalPath(resource.getFilePath());
            return dwResource;
        }).collect(Collectors.toList());
        HashSet keySet = new HashSet();
        return resList.stream().filter(res -> {
            if (!keySet.contains(res.getUniqueKey())) {
                keySet.add(res.getUniqueKey());
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    private List<DwWorkflow> convertWorkflows(Project project) {
        ArrayList<com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Node> nodes = new ArrayList<com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Node>();
        nodes.addAll(ListUtils.emptyIfNull((List)project.getNodes()));
        nodes.addAll(ListUtils.emptyIfNull((List)project.getFlows()));
        HashMap workflowMap = new HashMap();
        ListUtils.emptyIfNull(nodes).forEach(node -> {
            DwWorkflow dwWorkflow;
            Node dwNode = this.convertNode((com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Node)node, null);
            String workflowName = this.mapWorkflowNameByNode((com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Node)node);
            Boolean scheduled = this.mapWorkflowScheduled((com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Node)node);
            String key = workflowName + "_" + scheduled;
            if (workflowMap.containsKey(key)) {
                dwWorkflow = (DwWorkflow)workflowMap.get(key);
            } else {
                dwWorkflow = new DwWorkflow();
                dwWorkflow.setDmMajorVersion(DmMajorVersion.DATAWORKS_V1.name());
                dwWorkflow.setName(workflowName);
                dwWorkflow.setScheduled(scheduled);
                dwWorkflow.setOwner(node.getOwner());
                workflowMap.put(key, dwWorkflow);
            }
            dwNode.setNodeUseType(dwWorkflow.getScheduled() != false ? NodeUseType.SCHEDULED : NodeUseType.MANUAL_WORKFLOW);
            dwWorkflow.getNodes().add(dwNode);
        });
        List<Node> dwNodes = workflowMap.values().stream().map(Workflow::getNodes).flatMap(Collection::stream).collect(Collectors.toList());
        this.convertNodeRelations(nodes, dwNodes);
        return workflowMap.values().stream().collect(Collectors.toList());
    }

    private void convertNodeRelations(List<com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Node> nodes, List<Node> dwNodes) {
        HashMap<String, String> nodeParentRelations = new HashMap<String, String>(100);
        Map<String, Node> nodeNameMap = dwNodes.stream().collect(Collectors.toMap(Node::getName, node -> node));
        nodes.stream().forEach(node -> {
            String parents = node.getParents();
            if (StringUtils.isBlank((CharSequence)parents)) {
                return;
            }
            ListUtils.emptyIfNull(Arrays.asList(parents.split(","))).stream().forEach(parentNodeName -> {
                if (!nodeNameMap.containsKey(parentNodeName)) {
                    return;
                }
                nodeParentRelations.put((String)parentNodeName, node.getName());
            });
        });
        nodeParentRelations.forEach((parentName, childName) -> {
            Node parentNode = (Node)nodeNameMap.get(parentName);
            Node childNode = (Node)nodeNameMap.get(childName);
            NodeIo input = (NodeIo)parentNode.getOutputs().stream().findFirst().orElseThrow(() -> new RuntimeException("get no outputs of node: " + parentNode.getName()));
            childNode.getInputs().add(input);
        });
        dwNodes.stream().filter(node -> CollectionUtils.isNotEmpty((Collection)node.getInnerNodes())).forEach(flowNode -> {
            Flow outerNode = (Flow)nodes.stream().filter(node -> node.getName().equals(flowNode.getName()) && node instanceof Flow).findFirst().orElseThrow(() -> new RuntimeException("flow node not found: " + flowNode.getName()));
            Map<String, List> innerNodeParentsMap = ListUtils.emptyIfNull((List)outerNode.getNodes()).stream().filter(node -> StringUtils.isNotBlank((CharSequence)node.getParents())).collect(Collectors.toMap(innerNode -> innerNode.getName(), innerNode -> Arrays.asList(innerNode.getParents().split(","))));
            Map<String, Node> innerNodesMap = ListUtils.emptyIfNull((List)flowNode.getInnerNodes()).stream().collect(Collectors.toMap(Node::getName, innerNode -> innerNode));
            ListUtils.emptyIfNull((List)flowNode.getInnerNodes()).forEach(node -> {
                List parents = (List)innerNodeParentsMap.get(node.getName());
                ListUtils.emptyIfNull((List)parents).stream().map(innerNodesMap::get).forEach(parentNode -> node.getInputs().add((NodeIo)ListUtils.emptyIfNull((List)parentNode.getOutputs()).stream().findAny().orElseThrow(() -> new RuntimeException("get no outputs of node: " + parentNode.getName()))));
            });
        });
    }

    private Node convertNode(com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Node node, Flow parentFlowNode) {
        DwNode dwNode = new DwNode();
        dwNode.setDmMajorVersion(DmMajorVersion.DATAWORKS_V1.name());
        dwNode.setName(node.getName());
        dwNode.setFolder(node.getFolderPath());
        dwNode.setRef(node.getFilePath());
        try {
            if (StringUtils.isNotBlank((CharSequence)node.getFilePath())) {
                dwNode.setCode(IOUtils.toString((Reader)new FileReader(node.getFilePath())));
            }
        }
        catch (IOException e) {
            LOGGER.error("error read node code: {}", (Throwable)e);
        }
        dwNode.setStartRightNow(Boolean.valueOf(false));
        dwNode.setCronExpress(node.getScheduleExpression());
        dwNode.setPauseSchedule(Boolean.valueOf(NODE_RUN_TYPE_PAUSE.equalsIgnoreCase(node.getRunType())));
        dwNode.setOwner(node.getOwner());
        dwNode.setStartEffectDate(node.getStartEffectDate());
        dwNode.setEndEffectDate(node.getEndEffectDate());
        dwNode.setDescription(node.getDescription());
        dwNode.setIsRoot(node.getIsRoot());
        if (NODE_TYPE_MAP.containsKey(StringUtils.upperCase((String)node.getType()))) {
            dwNode.setType(NODE_TYPE_MAP.get(StringUtils.upperCase((String)node.getType())));
        } else {
            dwNode.setType(StringUtils.upperCase((String)node.getType()));
        }
        dwNode.setConnection(node.getConnection());
        Optional.ofNullable(node.getExtension()).ifPresent(extension -> dwNode.setExtension(GsonUtils.gson.toJson((Object)node.getExtension())));
        DwNodeIo output = new DwNodeIo();
        output.setDmMajorVersion(DmMajorVersion.DATAWORKS_V1.name());
        if (parentFlowNode != null) {
            output.setData(parentFlowNode.getName() + "." + node.getName());
        } else {
            output.setData(node.getName());
        }
        output.setParseType(Integer.valueOf(1));
        output.setNodeRef((Node)dwNode);
        output.setType("OUTPUT");
        dwNode.setOutputs(Arrays.asList(output));
        if (node instanceof Flow) {
            Flow flowNode = (Flow)node;
            List<Node> innerDwNodes = ListUtils.emptyIfNull((List)flowNode.getNodes()).stream().map(innerNode -> this.convertNode((com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Node)innerNode, flowNode)).collect(Collectors.toList());
            dwNode.setInnerNodes(innerDwNodes);
            dwNode.setNodeUseType(BooleanUtils.isTrue((Boolean)flowNode.getAutoSchedule()) ? NodeUseType.SCHEDULED : NodeUseType.MANUAL);
            innerDwNodes.forEach(n -> n.setNodeUseType(dwNode.getNodeUseType()));
            dwNode.setType(CodeProgramType.COMBINED_NODE.name());
            dwNode.setDeployType(DeployType.getDeployTypeByValue((String)flowNode.getDeployType()));
        }
        return dwNode;
    }

    private Boolean mapWorkflowScheduled(com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Node node) {
        return !NODE_RUN_TYPE_MANUAL.equalsIgnoreCase(node.getRunType());
    }

    private String mapWorkflowNameByNode(com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v1.Node node) {
        String name = DEFAULT_WORKFLOW_NAME;
        if (StringUtils.isNotBlank((CharSequence)node.getFolderPath())) {
            int code = node.getFolderPath().hashCode();
            String[] folderPath = node.getFolderPath().split("/");
            name = folderPath[folderPath.length - 1] + '_' + code;
        }
        return name;
    }

    private Project readV1MigrationProject(File unzippedPath) throws IOException {
        LOGGER.info("reading v1 migration project ...");
        File fullDir = new File(unzippedPath.getAbsoluteFile() + File.separator + FULL_DIR);
        Project fullProject = this.parseProjectDir(fullDir);
        LOGGER.info("read v1 migration package success");
        return fullProject;
    }

    private Project parseProjectDir(File fullDir) throws IOException {
        ArrayList<Project> batchProjects = new ArrayList<Project>();
        File[] batchDirs = fullDir.listFiles(File::isDirectory);
        if (batchDirs == null) {
            throw new RuntimeException("invalid project package file: " + fullDir);
        }
        for (File batchDir : batchDirs) {
            LOGGER.info("parsing project dir: {}", (Object)batchDir.getAbsolutePath());
            File[] zips = batchDir.listFiles((dir, name) -> name.endsWith(".zip"));
            if (zips.length <= 0) continue;
            File unzippedDir = ZipUtils.unzipExportFile(zips[0]);
            batchProjects.add(this.parseBatchDir(unzippedDir));
        }
        if (CollectionUtils.isEmpty(batchProjects)) {
            throw new RuntimeException("no project dir found, invalid project package file: " + fullDir);
        }
        Project project = new Project();
        BeanUtils.copyProperties(batchProjects.get(0), (Object)project, (String[])new String[]{"flows", NODES_DIR, FUNCTIONS_DIR, RESOURCES_DIR});
        project.setNodes(batchProjects.stream().filter(p -> CollectionUtils.isNotEmpty((Collection)p.getNodes())).map(Project::getNodes).flatMap(Collection::stream).collect(Collectors.toList()));
        project.setFlows(batchProjects.stream().filter(p -> CollectionUtils.isNotEmpty((Collection)p.getFlows())).map(Project::getFlows).flatMap(Collection::stream).collect(Collectors.toList()));
        project.setFunctions(batchProjects.stream().filter(p -> CollectionUtils.isNotEmpty((Collection)p.getFunctions())).map(Project::getFunctions).flatMap(Collection::stream).collect(Collectors.toList()));
        project.setResources(batchProjects.stream().filter(p -> CollectionUtils.isNotEmpty((Collection)p.getResources())).map(Project::getResources).flatMap(Collection::stream).collect(Collectors.toList()));
        return project;
    }

    private Project parseBatchDir(File unzippedDir) throws IOException {
        File workflowXml = new File(unzippedDir.getAbsolutePath() + File.separator + "workflow.xml");
        Preconditions.checkArgument((boolean)workflowXml.exists(), (Object)(workflowXml + " file not exists"));
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        xmlMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        Project project = (Project)xmlMapper.readValue(IOUtils.toString((Reader)new FileReader(workflowXml)), Project.class);
        ListUtils.emptyIfNull((List)project.getNodes()).stream().forEach(node -> {
            File filePath = new File(Joiner.on((String)File.separator).join((Object)unzippedDir.getAbsolutePath(), (Object)node.getFilePath(), new Object[0]));
            node.setFilePath(filePath.getAbsolutePath());
        });
        ListUtils.emptyIfNull((List)project.getFlows()).stream().forEach(flow -> ListUtils.emptyIfNull((List)flow.getNodes()).stream().forEach(node -> {
            File filePath = new File(Joiner.on((String)File.separator).join((Object)unzippedDir.getAbsolutePath(), (Object)node.getFilePath(), new Object[0]));
            node.setFilePath(filePath.getAbsolutePath());
        }));
        ListUtils.emptyIfNull((List)project.getResources()).stream().forEach(resource -> {
            File filePath = new File(Joiner.on((String)File.separator).join((Object)unzippedDir.getAbsolutePath(), (Object)resource.getFilePath(), new Object[0]));
            resource.setFilePath(filePath.getAbsolutePath());
        });
        ListUtils.emptyIfNull((List)project.getFunctions()).stream().forEach(function -> {
            File filePath = new File(Joiner.on((String)File.separator).join((Object)unzippedDir.getAbsolutePath(), (Object)function.getFilePath(), new Object[0]));
            function.setFilePath(filePath.getAbsolutePath());
        });
        return project;
    }

    public List<DwResource> getResourceList() {
        return this.resourceList;
    }

    public List<Function> getFunctionList() {
        return this.functionList;
    }

    static {
        NODE_TYPE_TO_FILE_EXT.put("odps_sql", "sql");
        NODE_TYPE_TO_FILE_EXT.put("odps_mr", "mr");
        NODE_TYPE_TO_FILE_EXT.put("shell", "sh");
        NODE_TYPE_TO_FILE_EXT.put("cdp", "cdp");
        RESOURCE_TYPE_TO_FILE_EXT.put("python", "py");
        RESOURCE_TYPE_TO_FILE_EXT.put(CodeProgramType.ODPS_PYTHON.name().toLowerCase(), "py");
        RESOURCE_TYPE_TO_FILE_EXT.put("jar", "jar");
        RESOURCE_TYPE_TO_FILE_EXT.put(CodeProgramType.ODPS_JAR.name().toLowerCase(), "jar");
        RESOURCE_TYPE_TO_FILE_EXT.put("file", "");
        RESOURCE_TYPE_TO_FILE_EXT.put(CodeProgramType.ODPS_FILE.name().toLowerCase(), "");
        RESOURCE_TYPE_TO_FILE_EXT.put("archive", "zip,tgz,tar.gz,tar,jar");
        RESOURCE_TYPE_TO_FILE_EXT.put(CodeProgramType.ODPS_ARCHIVE.name().toLowerCase(), "tgz");
        NODE_TYPE_MAP.put(CodeProgramType.CDP.name(), CodeProgramType.DI.name());
        NODE_TYPE_MAP.put(CodeProgramType.SHELL.name(), CodeProgramType.DIDE_SHELL.name());
        NODE_TYPE_MAP.put(CodeProgramType.ODPS_MR.name(), CodeProgramType.ODPS_MR.name());
        NODE_TYPE_MAP.put(CodeProgramType.ODPS_SQL.name(), CodeProgramType.ODPS_SQL.name());
    }
}

