/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.utils;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.connection.JdbcConnection;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CodeModeType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.tenant.EnvType;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DICode;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.JdbcUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiCodeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiCodeUtils.class);

    public static List<DwDatasource> processSqoopDatasource(DICode code) {
        String diCode = code.getCode();
        if (StringUtils.isBlank((CharSequence)diCode)) {
            return ListUtils.emptyIfNull(null);
        }
        ArrayList<DwDatasource> datasourceList = new ArrayList<DwDatasource>();
        JsonObject diJsonObject = (JsonObject)GsonUtils.gson.fromJson(diCode, JsonObject.class);
        if (diJsonObject.has("steps")) {
            JsonArray steps = diJsonObject.get("steps").getAsJsonArray();
            if (steps != null && steps.size() > 0) {
                for (int i = 0; i < steps.size(); ++i) {
                    String stepType;
                    JsonObject step = steps.get(i).getAsJsonObject();
                    if (!step.has("stepType") || !"mysql".equalsIgnoreCase(stepType = step.get("stepType").getAsString()) || !step.has("parameter")) continue;
                    JsonObject parameter = step.get("parameter").getAsJsonObject();
                    JsonArray connections = parameter.has("connection") ? parameter.get("connection").getAsJsonArray() : new JsonArray();
                    String password = parameter.has("password") ? parameter.get("password").getAsString() : "";
                    String username = parameter.has("username") ? parameter.get("username").getAsString() : "";
                    String jdbcUrl = null;
                    for (int j = 0; j < connections.size(); ++j) {
                        JsonArray jdbcUrls;
                        JsonObject conn = connections.get(j).getAsJsonObject();
                        JsonArray jsonArray = jdbcUrls = conn.has("jdbcUrl") ? conn.get("jdbcUrl").getAsJsonArray() : new JsonArray();
                        if (jdbcUrls.size() <= 0) continue;
                        jdbcUrl = jdbcUrls.get(0).getAsString();
                    }
                    if (StringUtils.isNotBlank(jdbcUrl) && StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                        DwDatasource dwDatasource = new DwDatasource();
                        dwDatasource.setName(JdbcUtils.getDbName(jdbcUrl));
                        JdbcConnection jdbcConnection = new JdbcConnection();
                        jdbcConnection.setJdbcUrl(jdbcUrl);
                        jdbcConnection.setUsername(username);
                        jdbcConnection.setPassword(password);
                        jdbcConnection.setTag("public");
                        dwDatasource.setConnection(GsonUtils.gson.toJson((Object)jdbcConnection));
                        dwDatasource.setType("mysql");
                        dwDatasource.setEnvType(EnvType.PRD.name());
                        if (datasourceList.stream().noneMatch(d -> d.getName().equals(dwDatasource.getName()))) {
                            datasourceList.add(dwDatasource);
                        }
                        boolean datasourceSet = false;
                        for (int k = 0; k < connections.size(); ++k) {
                            JsonObject conn = connections.get(k).getAsJsonObject();
                            JsonArray jdbcUrls = conn.has("jdbcUrl") ? conn.get("jdbcUrl").getAsJsonArray() : new JsonArray();
                            for (int n = 0; n < jdbcUrls.size(); ++n) {
                                if (!jdbcUrl.equals(jdbcUrls.get(n).getAsString())) continue;
                                conn.addProperty("datasource", dwDatasource.getName());
                                parameter.addProperty("datasource", dwDatasource.getName());
                                datasourceSet = true;
                                break;
                            }
                            if (!datasourceSet) continue;
                            conn.remove("jdbcUrl");
                            connections.set(k, (JsonElement)conn);
                        }
                        if (datasourceSet) {
                            parameter.remove("username");
                            parameter.remove("password");
                            JsonObject extend = diJsonObject.has("extend") ? diJsonObject.get("extend").getAsJsonObject() : new JsonObject();
                            extend.addProperty("mode", CodeModeType.WIZARD.getValue());
                            diJsonObject.add("extend", (JsonElement)extend);
                        }
                    }
                    step.add("parameter", (JsonElement)parameter);
                }
            }
            diJsonObject.add("steps", (JsonElement)steps);
        }
        code.setCode(GsonUtils.gson.toJson((JsonElement)diJsonObject));
        return datasourceList;
    }

    public static String replaceDiCodeOdpsTablePrefix(String code, String newPrefix) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return code;
        }
        try {
            JsonArray steps;
            String dstGuid;
            JsonObject codeJson = (JsonObject)GsonUtils.fromJsonString((String)code, JsonObject.class);
            String srcType = codeJson.has("srcType") ? codeJson.get("srcType").getAsString() : null;
            String srcGuid = codeJson.has("srcGuid") ? codeJson.get("srcGuid").getAsString() : null;
            String dstType = codeJson.has("dstType") ? codeJson.get("dstType").getAsString() : null;
            String string = dstGuid = codeJson.has("dstGuid") ? codeJson.get("dstGuid").getAsString() : null;
            if (StringUtils.equalsIgnoreCase((CharSequence)"odps", (CharSequence)srcType)) {
                srcGuid = DiCodeUtils.replaceGuidOdpsProjectPrefix(newPrefix, srcGuid);
                codeJson.addProperty("srcGuid", srcGuid);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"odps", (CharSequence)dstType)) {
                dstGuid = DiCodeUtils.replaceGuidOdpsProjectPrefix(newPrefix, dstGuid);
                codeJson.addProperty("dstGuid", dstGuid);
            }
            if (codeJson.has("config") && codeJson.get("config").isJsonObject()) {
                String guid;
                JsonObject config = codeJson.get("config").getAsJsonObject();
                if (StringUtils.equalsIgnoreCase((CharSequence)"odps", (CharSequence)srcType)) {
                    JsonObject reader = config.has("reader") ? config.get("reader").getAsJsonObject() : new JsonObject();
                    guid = reader.has("guid") ? reader.get("guid").getAsString() : null;
                    guid = DiCodeUtils.replaceGuidOdpsProjectPrefix(newPrefix, guid);
                    reader.addProperty("guid", guid);
                    config.remove("reader");
                    config.add("reader", (JsonElement)reader);
                    codeJson.add("config", (JsonElement)config);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"odps", (CharSequence)dstType)) {
                    JsonObject writer = config.has("writer") ? config.get("writer").getAsJsonObject() : new JsonObject();
                    guid = writer.has("guid") ? writer.get("guid").getAsString() : null;
                    guid = DiCodeUtils.replaceGuidOdpsProjectPrefix(newPrefix, guid);
                    writer.addProperty("guid", guid);
                    config.remove("writer");
                    config.add("writer", (JsonElement)writer);
                    codeJson.add("config", (JsonElement)config);
                }
            }
            if (codeJson.has("steps") && (steps = codeJson.get("steps").getAsJsonArray()) != null && steps.size() > 0) {
                for (int i = 0; i < steps.size(); ++i) {
                    String stepType;
                    JsonObject step = steps.get(i).getAsJsonObject();
                    if (!step.has("stepType") || !StringUtils.equalsIgnoreCase((CharSequence)"odps", (CharSequence)(stepType = step.get("stepType").getAsString())) || !step.has("parameter")) continue;
                    JsonObject parameter = step.get("parameter").getAsJsonObject();
                    String guid = parameter.has("guid") ? parameter.get("guid").getAsString() : null;
                    guid = DiCodeUtils.replaceGuidOdpsProjectPrefix(newPrefix, guid);
                    parameter.addProperty("guid", guid);
                }
            }
            return GsonUtils.defaultGson.toJson((JsonElement)codeJson);
        }
        catch (Exception e) {
            LOGGER.error("replace di code error, code: {}", (Object)code, (Object)e);
            return code;
        }
    }

    private static String replaceGuidOdpsProjectPrefix(String newPrefix, String guid) {
        Object[] parts;
        if (StringUtils.startsWith((CharSequence)guid, (CharSequence)"odps.") && (parts = StringUtils.split((String)guid, (String)".")).length >= 3) {
            parts[1] = newPrefix;
            guid = Joiner.on((String)".").join(parts);
        }
        return guid;
    }

    public static String getDiCodeOdpsTablePrefix(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        try {
            JsonArray steps;
            String dstGuid;
            JsonObject codeJson = (JsonObject)GsonUtils.fromJsonString((String)code, JsonObject.class);
            String srcType = codeJson.has("srcType") ? codeJson.get("srcType").getAsString() : null;
            String srcGuid = codeJson.has("srcGuid") ? codeJson.get("srcGuid").getAsString() : null;
            String dstType = codeJson.has("dstType") ? codeJson.get("dstType").getAsString() : null;
            String string = dstGuid = codeJson.has("dstGuid") ? codeJson.get("dstGuid").getAsString() : null;
            if (codeJson.has("config") && codeJson.get("config").isJsonObject()) {
                String[] parts;
                JsonObject config = codeJson.get("config").getAsJsonObject();
                JsonObject reader = config.has("reader") ? config.get("reader").getAsJsonObject() : new JsonObject();
                JsonObject writer = config.has("writer") ? config.get("writer").getAsJsonObject() : new JsonObject();
                String guid = null;
                if (StringUtils.equalsIgnoreCase((CharSequence)"odps", (CharSequence)srcType)) {
                    String string2 = guid = reader.has("guid") ? reader.get("guid").getAsString() : null;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"odps", (CharSequence)dstType)) {
                    String string3 = guid = writer.has("guid") ? writer.get("guid").getAsString() : null;
                }
                if (StringUtils.isNotBlank(guid) && StringUtils.startsWith((CharSequence)guid, (CharSequence)"odps.") && (parts = StringUtils.split((String)guid, (String)".")).length >= 3) {
                    return parts[1];
                }
            }
            if (codeJson.has("steps") && (steps = codeJson.get("steps").getAsJsonArray()) != null && steps.size() > 0) {
                for (int i = 0; i < steps.size(); ++i) {
                    String[] parts;
                    String guid;
                    String stepType;
                    JsonObject step = steps.get(i).getAsJsonObject();
                    if (!step.has("stepType") || !StringUtils.equalsIgnoreCase((CharSequence)"odps", (CharSequence)(stepType = step.get("stepType").getAsString())) || !step.has("parameter")) continue;
                    JsonObject parameter = step.get("parameter").getAsJsonObject();
                    String string4 = guid = parameter.has("guid") ? parameter.get("guid").getAsString() : null;
                    if (!StringUtils.startsWith((CharSequence)guid, (CharSequence)"odps.") || (parts = StringUtils.split((String)guid, (String)".")).length < 3) continue;
                    return parts[1];
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("replace di code error, code: {}", (Object)code, (Object)e);
        }
        return null;
    }
}

