/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.translator;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.transformer.core.translator.AbstractCommandSqlTranslator;
import java.util.regex.Pattern;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrestoCommandSqlTranslator
extends AbstractCommandSqlTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrestoCommandSqlTranslator.class);
    public static Pattern PRESTO_PATTERN = Pattern.compile("[\\s|\\n|\\t]*presto[\\s|\\n|\\t]+.*");

    @Override
    public boolean match(DwWorkflow workflow, DwNode node) {
        return super.match(workflow, node) && StringUtils.contains((CharSequence)node.getCode(), (CharSequence)"--execute");
    }

    @Override
    protected Pattern getCommandPrefixPattern() {
        return PRESTO_PATTERN;
    }

    @Override
    protected String getSqlOption() {
        return "execute";
    }

    @Override
    protected Options getGnuOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"execute");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"execute statement");
        OptionBuilder.withDescription((String)"execute statement");
        options.addOption(OptionBuilder.create());
        return options;
    }
}

