/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.translator;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.Reportable;
import com.aliyun.dataworks.migrationx.transformer.core.translator.NodePropertyTranslator;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class Perl2ShellTranslator
implements Reportable,
NodePropertyTranslator {
    private Properties properties;

    @Override
    public List<ReportItem> getReport() {
        return null;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public boolean match(DwWorkflow workflow, DwNode node) {
        boolean perl2Shell;
        List<CodeProgramType> perlTypes = Arrays.asList(CodeProgramType.PERL, CodeProgramType.ODPS_PERL);
        boolean bl = perl2Shell = perlTypes.stream().anyMatch(t -> t.name().equalsIgnoreCase(node.getType())) && BooleanUtils.toBoolean((String)this.properties.getProperty("workflow.converter.perl2shell.enable", "true"));
        return perl2Shell;
    }

    @Override
    public boolean translate(DwWorkflow dwWorkflow, DwNode dwNode) throws Exception {
        if (!this.match(dwWorkflow, dwNode)) {
            return false;
        }
        String code = dwNode.getCode();
        DwResource perlResource = new DwResource();
        perlResource.setName(dwNode.getName() + "__script.pl");
        perlResource.setType(CodeProgramType.ODPS_FILE.name());
        perlResource.setOdps(Boolean.valueOf(false));
        perlResource.setConnection(dwNode.getConnection());
        perlResource.setFolder(dwNode.getFolder());
        perlResource.setLocalPath(this.writePerlCodeFile(code));
        perlResource.setWorkflowRef(dwWorkflow);
        dwWorkflow.getResources().add(perlResource);
        String perlBin = this.properties.getProperty("workflow.converter.perl2shell.perlBin", "/usr/bin/perl");
        String perlIncludePath = this.properties.getProperty("workflow.converter.perl2shell.perlIncludePaths", "/usr/lib64/perl5/5.8.8/x86_64-linux-thread-multi");
        String perlIncludeOptions = Arrays.asList(perlIncludePath.split(",")).stream().map(p -> "-I " + p).collect(Collectors.joining(" "));
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        velocityEngine.init();
        Template template = velocityEngine.getTemplate("res/perl2shell.sh", "UTF-8");
        VelocityContext context = new VelocityContext();
        context.put("perlBin", (Object)perlBin);
        context.put("perlIncludePathOptions", (Object)perlIncludeOptions);
        context.put("perlScriptResourceName", (Object)perlResource.getName());
        StringWriter stringWriter = new StringWriter();
        template.merge((Context)context, (Writer)stringWriter);
        dwNode.setCode(stringWriter.getBuffer().toString());
        dwNode.setType(CodeProgramType.DIDE_SHELL.name());
        dwNode.setConnection("odps_first");
        return true;
    }

    private String writePerlCodeFile(String code) throws IOException {
        File tmpFile = File.createTempFile("tmp", "perl");
        FileUtils.writeStringToFile((File)tmpFile, (String)code, (String)"utf-8");
        return tmpFile.getAbsolutePath();
    }
}

