/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.translator;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.transformer.core.translator.AbstractCommandSqlTranslator;
import java.util.regex.Pattern;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaCommandSqlTranslator
extends AbstractCommandSqlTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImpalaCommandSqlTranslator.class);
    public static Pattern IMPALA_SHELL_PATTERN = Pattern.compile("[\\s|\\n|\\t]*impala-shell.*");

    @Override
    public boolean match(DwWorkflow workflow, DwNode node) {
        return super.match(workflow, node) && (StringUtils.contains((CharSequence)node.getCode(), (CharSequence)" -q") || StringUtils.contains((CharSequence)node.getCode(), (CharSequence)"--query"));
    }

    @Override
    protected Pattern getCommandPrefixPattern() {
        return IMPALA_SHELL_PATTERN;
    }

    @Override
    protected String getSqlOption() {
        return "q";
    }

    @Override
    protected Options getGnuOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"query");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"query");
        OptionBuilder.withDescription((String)"The driver class to use");
        options.addOption(OptionBuilder.create((char)'q'));
        return options;
    }
}

