/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.translator;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.Reportable;
import com.aliyun.dataworks.migrationx.transformer.core.translator.NodePropertyTranslator;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveEofDelimiterCommandSqlTranslator
implements Reportable,
NodePropertyTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveEofDelimiterCommandSqlTranslator.class);
    public static Pattern START_DELIMITER_PATTERN = Pattern.compile("\\s*(?i)hive\\s*<<\\s*(?i)EOF\\s*\\n*");
    public static Pattern END_DELIMITER_PATTERN = Pattern.compile("\\n*\\s*(?i)EOF\\s*\\n*");
    public static Pattern ECHO_COMMENT_PATTERN = Pattern.compile("^\\s*(?i)echo\\s+'(?<comment>.+)'");

    @Override
    public boolean match(DwWorkflow workflow, DwNode node) {
        return START_DELIMITER_PATTERN.matcher(node.getCode()).find();
    }

    @Override
    public boolean translate(DwWorkflow workflow, DwNode node) throws Exception {
        if (!this.match(workflow, node)) {
            return false;
        }
        String sql = this.parseSqlCode(node.getCode());
        node.setCode(sql);
        if (NodeUtils.isEmrNode((String)node.getType())) {
            node.setCode(EmrCodeUtils.toEmrCode((Node)node));
            return true;
        }
        return true;
    }

    private String parseSqlCode(String nodeCode) {
        if (StringUtils.isBlank((CharSequence)nodeCode)) {
            return nodeCode;
        }
        StringBuilder code = new StringBuilder();
        AtomicBoolean codeStarts = new AtomicBoolean(false);
        AtomicBoolean codeEnds = new AtomicBoolean(false);
        Arrays.stream(StringUtils.split((String)nodeCode, (String)"\n")).forEach(line -> {
            if (START_DELIMITER_PATTERN.matcher((CharSequence)line).find()) {
                codeStarts.set(true);
                line = line.replaceFirst(START_DELIMITER_PATTERN.pattern(), "");
            } else if (codeStarts.get() && END_DELIMITER_PATTERN.matcher((CharSequence)line).find()) {
                codeEnds.set(true);
            }
            Matcher commentMatcher = ECHO_COMMENT_PATTERN.matcher((CharSequence)line);
            if (!codeStarts.get() && commentMatcher.matches()) {
                String comment = commentMatcher.group("comment");
                code.append("--").append(comment).append("\n");
            }
            if (codeStarts.get() && !codeEnds.get()) {
                code.append((String)line).append("\n");
            }
        });
        return code.toString();
    }

    @Override
    public List<ReportItem> getReport() {
        return null;
    }
}

