/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.translator;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.transformer.core.translator.AbstractCommandSqlTranslator;
import java.util.regex.Pattern;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeeLineCommandSqlTranslator
extends AbstractCommandSqlTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeeLineCommandSqlTranslator.class);
    public static Pattern BEELINE_PATTERN = Pattern.compile("[\\s|\\n|\\t]*beeline.*");

    @Override
    public boolean match(DwWorkflow workflow, DwNode node) {
        return super.match(workflow, node) && StringUtils.contains((CharSequence)node.getCode(), (CharSequence)" -e ");
    }

    @Override
    protected Pattern getCommandPrefixPattern() {
        return BEELINE_PATTERN;
    }

    @Override
    protected String getSqlOption() {
        return "e";
    }

    @Override
    protected Options getGnuOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"driver class");
        OptionBuilder.withDescription((String)"The driver class to use");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"database url");
        OptionBuilder.withDescription((String)"The JDBC URL to connect to");
        options.addOption(OptionBuilder.create((char)'u'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"named JDBC URL in beeline-site.xml");
        OptionBuilder.withDescription((String)"The named JDBC URL to connect to, which should be present in beeline-site.xml as the value of beeline.hs2.jdbc.url.<namedUrl>");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"reconnect");
        OptionBuilder.withDescription((String)"Reconnect to last saved connect url (in conjunction with !save)");
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.withDescription((String)"The username to connect as");
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.withDescription((String)"The password to connect as");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password-file");
        OptionBuilder.withDescription((String)"The password file to read password from");
        OptionBuilder.withLongOpt((String)"password-file");
        options.addOption(OptionBuilder.create((char)'w'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"authType");
        OptionBuilder.withDescription((String)"The authentication type");
        options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"init");
        OptionBuilder.withDescription((String)"The script file for initialization");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"query");
        OptionBuilder.withDescription((String)"The query that should be executed");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withDescription((String)"The script file that should be executed");
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Display this message");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withLongOpt((String)"hivevar");
        OptionBuilder.withDescription((String)"Hive variable name and value");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"property-file");
        OptionBuilder.withDescription((String)"The file to read configuration properties from");
        options.addOption(OptionBuilder.create());
        return options;
    }
}

