/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.sqoop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ListIterator;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopParser
extends GnuParser {
    public static final Logger LOG = LoggerFactory.getLogger((String)SqoopParser.class.getName());
    private static Method addValForProcessing;

    public void processArgs(Option opt, ListIterator iter) throws ParseException {
        while (iter.hasNext()) {
            String str = (String)iter.next();
            if (this.getOptions().hasOption(str) && str.startsWith("-")) {
                iter.previous();
                break;
            }
            try {
                addValForProcessing.invoke((Object)opt, this.stripMatchedQuotes(str));
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            catch (InvocationTargetException ite) {
                iter.previous();
                break;
            }
            catch (RuntimeException re) {
                iter.previous();
                break;
            }
        }
        if (opt.getValues() == null && !opt.hasOptionalArg()) {
            throw new MissingArgumentException(opt);
        }
    }

    private String stripMatchedQuotes(String in) {
        if (null == in || "\"".equals(in)) {
            return in;
        }
        if (in.startsWith("\"") && in.endsWith("\"")) {
            return in.substring(1, in.length() - 1);
        }
        return in;
    }

    static {
        try {
            addValForProcessing = Option.class.getDeclaredMethod("addValueForProcessing", String.class);
            addValForProcessing.setAccessible(true);
        }
        catch (NoSuchMethodException nsme) {
            LOG.error("Could not load required method of Parser: " + StringUtils.stringifyException((Throwable)nsme));
            addValForProcessing = null;
        }
    }
}

