/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.sqoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OptionsFileUtil {
    public static final Logger LOG = LoggerFactory.getLogger((String)OptionsFileUtil.class.getName());

    private OptionsFileUtil() {
    }

    public static String[] expandArguments(String[] args) throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--options-file")) {
                if (i == args.length - 1) {
                    throw new Exception("Missing options file");
                }
                String fileName = args[++i];
                File optionsFile = new File(fileName);
                BufferedReader reader = null;
                StringBuilder buffer = new StringBuilder();
                try {
                    reader = new BufferedReader(new FileReader(optionsFile));
                    String nextLine = null;
                    while ((nextLine = reader.readLine()) != null) {
                        if ((nextLine = nextLine.trim()).length() == 0 || nextLine.startsWith("#")) continue;
                        buffer.append(nextLine);
                        if (nextLine.endsWith("\\")) {
                            if (buffer.charAt(0) == '\'' || buffer.charAt(0) == '\"') {
                                throw new Exception("Multiline quoted strings not supported in file(" + fileName + "): " + buffer.toString());
                            }
                            buffer.deleteCharAt(buffer.length() - 1);
                            continue;
                        }
                        options.add(OptionsFileUtil.removeQuotesEncolosingOption(fileName, buffer.toString()));
                        buffer.delete(0, buffer.length());
                    }
                    if (buffer.length() == 0) continue;
                    throw new Exception("Malformed option in options file(" + fileName + "): " + buffer.toString());
                }
                catch (IOException ex) {
                    throw new Exception("Unable to read options file: " + fileName, ex);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex) {
                            LOG.info("Exception while closing reader", (Throwable)ex);
                        }
                    }
                }
            }
            options.add(args[i]);
        }
        return options.toArray(new String[options.size()]);
    }

    private static String removeQuotesEncolosingOption(String fileName, String option) throws Exception {
        String option1 = OptionsFileUtil.removeQuoteCharactersIfNecessary(fileName, option, '\"');
        if (!option1.equals(option)) {
            return option1;
        }
        return OptionsFileUtil.removeQuoteCharactersIfNecessary(fileName, option, '\'');
    }

    private static String removeQuoteCharactersIfNecessary(String fileName, String option, char quote) throws Exception {
        boolean endingQuote;
        boolean startingQuote = option.charAt(0) == quote;
        boolean bl = endingQuote = option.charAt(option.length() - 1) == quote;
        if (startingQuote && endingQuote) {
            if (option.length() == 1) {
                throw new Exception("Malformed option in options file(" + fileName + "): " + option);
            }
            return option.substring(1, option.length() - 1);
        }
        if (startingQuote || endingQuote) {
            throw new Exception("Malformed option in options file(" + fileName + "): " + option);
        }
        return option;
    }
}

