/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.sqoop;

import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceContext.class);
    public static String READER_PLUGIN_PATH = "configuration.reader.plugin";
    public static String READER_PLUGIN_PARAMETER_PATH = "configuration.reader.parameter";
    public static String WRITER_PLUGIN_PATH = "configuration.writer.plugin";
    public static String WRITER_PLUGIN_PARAMETER_PATH = "configuration.writer.parameter";
    public static String SETTING_PATH = "configuration.setting";
    public static String TRANSFORMER_PATH = "configuration.transformer";
    public static String EXTEND_PATH = "extend";
    public static String ID_PATH = "id";
    public static String TYPE_PATH = "type";
    public static String TRACEID_PATH = "traceId";
    public static String VERSION_PATH = "version";
    private DIJsonProcessor diCode;

    public InstanceContext(String diCodeInJsonString) {
        this.diCode = DIJsonProcessor.from(diCodeInJsonString);
    }

    public String getReaderPlugin() {
        return this.diCode.getString(READER_PLUGIN_PATH);
    }

    public void setReaderPlugin(String pluginName) {
        this.diCode.set(READER_PLUGIN_PATH, pluginName);
    }

    public DIJsonProcessor getReaderParameter() {
        return this.diCode.getConfiguration(READER_PLUGIN_PARAMETER_PATH);
    }

    public DIJsonProcessor setReaderParameter(Object parameter) {
        this.diCode.set(READER_PLUGIN_PARAMETER_PATH, parameter);
        return this.diCode;
    }

    public String getWriterPlugin() {
        return this.diCode.getString(WRITER_PLUGIN_PATH);
    }

    public void setWriterPlugin(String pluginName) {
        this.diCode.set(WRITER_PLUGIN_PATH, pluginName);
    }

    public DIJsonProcessor getWriterParameter() {
        return this.diCode.getConfiguration(WRITER_PLUGIN_PARAMETER_PATH);
    }

    public DIJsonProcessor setWriterParameter(Object parameter) {
        this.diCode.set(WRITER_PLUGIN_PARAMETER_PATH, parameter);
        return this.diCode;
    }

    public DIJsonProcessor getSetting() {
        return this.diCode.getConfiguration(SETTING_PATH);
    }

    public DIJsonProcessor setSetting(Object parameter) {
        this.diCode.set(SETTING_PATH, parameter);
        return this.diCode;
    }

    public List<DIJsonProcessor> getTransformer() {
        return this.diCode.getListConfiguration(TRANSFORMER_PATH);
    }

    public DIJsonProcessor getExtend() {
        return this.diCode.getConfiguration(EXTEND_PATH);
    }

    public String getId() {
        return this.diCode.getString(ID_PATH);
    }

    public String getType() {
        return this.diCode.getString(TYPE_PATH);
    }

    public String getTraceId() {
        return this.diCode.getString(TRACEID_PATH);
    }

    public String getVersion() {
        return this.diCode.getString(VERSION_PATH);
    }

    public Object get(String path) {
        return this.diCode.get(path);
    }

    public void set(String path, Object value) {
        this.diCode.set(path, value);
    }

    public DIJsonProcessor getDiCode() {
        return this.diCode;
    }

    public boolean isList(String path) {
        return this.diCode.get(path) instanceof List;
    }

    public boolean isString(String path) {
        return this.diCode.get(path) instanceof String;
    }

    public String toString() {
        return this.diCode.toJSON();
    }

    public static String streamX2Cdp(String streamXJson) {
        DIJsonProcessor streamXCode;
        List<DIJsonProcessor> steps;
        String cdpSkeleton = "{\n    \"configuration\": {\n        \"reader\": {\n            \"plugin\": \"\",\n            \"parameter\": {}\n        },\n        \"writer\": {\n            \"plugin\": \"\",\n            \"parameter\": {}\n        },\n        \"setting\": {}\n    }\n}";
        DIJsonProcessor cdpCode = DIJsonProcessor.from(streamXJson);
        if ((cdpCode = cdpCode.merge(DIJsonProcessor.from(cdpSkeleton), false)).containsKey("steps")) {
            cdpCode.remove("steps");
        }
        if (null != (steps = (streamXCode = DIJsonProcessor.from(streamXJson)).getListConfiguration("steps"))) {
            for (DIJsonProcessor eachPlugin : steps) {
                String category = eachPlugin.getString("category");
                String stepType = eachPlugin.getString("stepType");
                if ("reader".equalsIgnoreCase(category)) {
                    cdpCode.set(READER_PLUGIN_PATH, stepType);
                    cdpCode.set(READER_PLUGIN_PARAMETER_PATH, eachPlugin.get("parameter"));
                    continue;
                }
                if ("writer".equalsIgnoreCase(category)) {
                    cdpCode.set(WRITER_PLUGIN_PATH, stepType);
                    cdpCode.set(WRITER_PLUGIN_PARAMETER_PATH, eachPlugin.get("parameter"));
                    continue;
                }
                LOGGER.warn("found not support parameters, ignore: {}", (Object)eachPlugin.toJSON());
            }
        }
        if (streamXCode.containsKey("setting")) {
            cdpCode.set(SETTING_PATH, streamXCode.get("setting"));
            streamXCode.remove("setting");
        }
        return cdpCode.toJSON();
    }

    public class TransformerContext {
        private DIJsonProcessor code;

        public DIJsonProcessor getCode() {
            return this.code;
        }

        public void setCode(DIJsonProcessor code) {
            this.code = code;
        }

        public TransformerContext(DIJsonProcessor code) {
            this.code = code;
        }
    }

    public class SettingContext {
        private DIJsonProcessor code;

        public DIJsonProcessor getCode() {
            return this.code;
        }

        public void setCode(DIJsonProcessor code) {
            this.code = code;
        }

        public SettingContext(DIJsonProcessor code) {
            this.code = code;
        }
    }

    public class WriterContext {
        private DIJsonProcessor code;

        public DIJsonProcessor getCode() {
            return this.code;
        }

        public void setCode(DIJsonProcessor code) {
            this.code = code;
        }

        public WriterContext(DIJsonProcessor code) {
            this.code = code;
        }
    }

    public class ReaderContext {
        private DIJsonProcessor code;

        public DIJsonProcessor getCode() {
            return this.code;
        }

        public void setCode(DIJsonProcessor code) {
            this.code = code;
        }

        public ReaderContext(DIJsonProcessor code) {
            this.code = code;
        }
    }
}

