/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.spark.command;

import com.aliyun.dataworks.migrationx.transformer.core.spark.command.ChildProcAppHandle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

class OutputRedirector {
    private final BufferedReader reader;
    private final Logger sink;
    private final Thread thread;
    private final ChildProcAppHandle callback;
    private volatile boolean active = true;
    private volatile Throwable error;

    OutputRedirector(InputStream in, String loggerName, ThreadFactory tf) {
        this(in, loggerName, tf, null);
    }

    OutputRedirector(InputStream in, String loggerName, ThreadFactory tf, ChildProcAppHandle callback) {
        this.reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        this.thread = tf.newThread(this::redirect);
        this.sink = Logger.getLogger(loggerName);
        this.callback = callback;
        this.thread.start();
    }

    private void redirect() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (!this.active) continue;
                this.sink.info(line.replaceFirst("\\s*$", ""));
                if (!OutputRedirector.containsIgnoreCase(line, "Error") && !OutputRedirector.containsIgnoreCase(line, "Exception") || line.contains("at ")) continue;
                this.error = new RuntimeException(line);
            }
        }
        catch (IOException e) {
            this.sink.log(Level.FINE, "Error reading child process output.", e);
        }
        finally {
            if (this.callback != null) {
                this.callback.monitorChild();
            }
        }
    }

    void stop() {
        this.active = false;
    }

    boolean isAlive() {
        return this.thread.isAlive();
    }

    Throwable getError() {
        return this.error;
    }

    private static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int len = searchStr.length();
        int max = str.length() - len;
        for (int i = 0; i <= max; ++i) {
            if (!str.regionMatches(true, i, searchStr, 0, len)) continue;
            return true;
        }
        return false;
    }
}

