/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.css;

import com.alibaba.security.css.CSSLexicalUnit;
import com.alibaba.security.css.CSSParseException;
import com.alibaba.security.css.CSSProcessHandler;
import com.alibaba.security.css.CSSReader;
import com.alibaba.security.css.CSSScanner;
import com.alibaba.security.css.CSSScannerUtilities;
import com.alibaba.security.css.CSSStreamReader;
import com.alibaba.security.css.CSSStringReader;
import com.alibaba.security.css.DefaultDocumentHandler;
import com.alibaba.security.css.DefaultErrorHandler;
import com.alibaba.security.css.ErrorHandler;
import com.alibaba.security.css.condition.CSSAndCondition;
import com.alibaba.security.css.condition.CSSAttributeCondition;
import com.alibaba.security.css.condition.CSSBeginHyphenAttributeCondition;
import com.alibaba.security.css.condition.CSSClassCondition;
import com.alibaba.security.css.condition.CSSCondition;
import com.alibaba.security.css.condition.CSSEndWithAttributeCondition;
import com.alibaba.security.css.condition.CSSIdCondition;
import com.alibaba.security.css.condition.CSSIndexOfAttributeCondition;
import com.alibaba.security.css.condition.CSSLangCondition;
import com.alibaba.security.css.condition.CSSOneOfAttributeCondition;
import com.alibaba.security.css.condition.CSSPseudoClassCondition;
import com.alibaba.security.css.condition.CSSPseudoNumCondition;
import com.alibaba.security.css.condition.CSSPseudoSelectorCondition;
import com.alibaba.security.css.condition.CSSStartWithAttributeCondition;
import com.alibaba.security.css.selector.CSSBrotherSelector;
import com.alibaba.security.css.selector.CSSChildSelector;
import com.alibaba.security.css.selector.CSSConditionalSelector;
import com.alibaba.security.css.selector.CSSDescendantSelector;
import com.alibaba.security.css.selector.CSSDirectAdjacentSelector;
import com.alibaba.security.css.selector.CSSElementSelector;
import com.alibaba.security.css.selector.CSSPseudoElementSelector;
import com.alibaba.security.css.selector.CSSSelector;
import com.alibaba.security.css.util.ParsedURL;
import com.alibaba.security.css.w3cinterface.CSSException;
import com.alibaba.security.css.w3cinterface.InputSource;
import com.alibaba.security.css.w3cinterface.LexicalUnit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CSSParser {
    private CSSScanner scanner;
    private CSSReader reader;
    private int current;
    private CSSProcessHandler documentHandler = DefaultDocumentHandler.INSTANCE;
    private ErrorHandler errorHandler = DefaultErrorHandler.INSTANCE;
    private String pseudoElement;
    private String documentURI;

    public void setDocumentHandler(DefaultDocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setDocumentHandler(CSSProcessHandler handler) {
        this.documentHandler = handler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void parseStyleSheet(InputSource source) throws CSSException, IOException {
        block18: {
            this.scanner = this.createScanner(source);
            try {
                this.documentHandler.startDocument(source);
                this.current = this.scanner.next();
                switch (this.current) {
                    case 30: {
                        if (this.nextIgnoreSpaces() != 19) {
                            this.reportError("charset.string");
                            break;
                        }
                        if (this.nextIgnoreSpaces() != 8) {
                            this.reportError("semicolon");
                        }
                        this.next();
                        break;
                    }
                    case 18: {
                        this.documentHandler.comment(this.scanner.getStringValue());
                    }
                }
                this.skipSpacesAndCDOCDC();
                while (this.current == 28) {
                    this.nextIgnoreSpaces();
                    this.parseImportRule();
                    this.nextIgnoreSpaces();
                }
                while (true) {
                    switch (this.current) {
                        case 33: {
                            this.nextIgnoreSpaces();
                            this.parsePageRule();
                            break;
                        }
                        case 32: {
                            this.nextIgnoreSpaces();
                            this.parseMediaRule();
                            break;
                        }
                        case 31: {
                            this.nextIgnoreSpaces();
                            this.parseFontFaceRule();
                            break;
                        }
                        case 29: {
                            this.nextIgnoreSpaces();
                            this.parseAtRule();
                            break;
                        }
                        case 0: {
                            break block18;
                        }
                        default: {
                            this.parseRuleSet();
                        }
                    }
                    this.skipSpacesAndCDOCDC();
                }
            }
            finally {
                this.documentHandler.endDocument(source);
                this.scanner = null;
                this.reader.close();
            }
        }
    }

    public void parseStyleSheet(String uri) throws CSSException, IOException {
        this.parseStyleSheet(new InputSource(uri));
    }

    private void parseStyleDeclarationInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        try {
            this.parseStyleDeclaration(false);
        }
        catch (CSSParseException e) {
            this.reportError(e);
        }
        finally {
            this.scanner = null;
        }
    }

    public void parseStyleDeclaration(InputSource source) throws CSSException, IOException {
        this.scanner = this.createScanner(source);
        this.parseStyleDeclarationInternal();
    }

    private void parseRuleInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        this.parseRule();
        this.scanner = null;
    }

    public void parseRule(InputSource source) throws CSSException, IOException {
        this.scanner = this.createScanner(source);
        this.parseRuleInternal();
    }

    private List<CSSSelector> parseSelectorsInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        List<CSSSelector> ret = this.parseSelectorList();
        this.scanner = null;
        return ret;
    }

    public List<CSSSelector> parseSelectors(InputSource source) throws CSSException, IOException {
        this.scanner = this.createScanner(source);
        return this.parseSelectorsInternal();
    }

    private LexicalUnit parsePropertyValueInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        LexicalUnit exp = null;
        try {
            exp = this.parseExpression(false);
        }
        catch (CSSParseException e) {
            this.reportError(e);
            throw e;
        }
        CSSParseException exception = null;
        if (this.current != 0) {
            exception = this.createCSSParseException("eof.expected");
        }
        this.scanner = null;
        if (exception != null) {
            this.errorHandler.fatalError(exception);
        }
        return exp;
    }

    public LexicalUnit parsePropertyValue(InputSource source) throws CSSException, IOException {
        this.scanner = this.createScanner(source);
        return this.parsePropertyValueInternal();
    }

    private boolean parsePriorityInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        this.scanner = null;
        switch (this.current) {
            case 0: {
                return false;
            }
            case 28: {
                return true;
            }
        }
        this.reportError("token", new Object[]{new Integer(this.current)});
        return false;
    }

    public boolean parsePriority(InputSource source) throws CSSException, IOException {
        this.scanner = this.createScanner(source);
        return this.parsePriorityInternal();
    }

    private void parseRule() {
        switch (this.scanner.getType()) {
            case 28: {
                this.nextIgnoreSpaces();
                this.parseImportRule();
                break;
            }
            case 29: {
                this.nextIgnoreSpaces();
                this.parseAtRule();
                break;
            }
            case 31: {
                this.nextIgnoreSpaces();
                this.parseFontFaceRule();
                break;
            }
            case 32: {
                this.nextIgnoreSpaces();
                this.parseMediaRule();
                break;
            }
            case 33: {
                this.nextIgnoreSpaces();
                this.parsePageRule();
                break;
            }
            default: {
                this.parseRuleSet();
            }
        }
    }

    private void parseAtRule() {
        this.scanner.scanAtRule();
        this.documentHandler.ignorableAtRule(this.scanner.getStringValue());
        this.nextIgnoreSpaces();
    }

    private void parseImportRule() {
        List<String> ml;
        String uri = null;
        switch (this.current) {
            default: {
                this.reportError("string.or.uri");
                return;
            }
            case 19: 
            case 51: 
        }
        uri = this.scanner.getStringValue();
        this.nextIgnoreSpaces();
        if (this.current != 20) {
            ml = new ArrayList<String>();
            ml.add("all");
        } else {
            ml = this.parseMediaList();
        }
        this.documentHandler.importStyle(uri, ml, null);
        if (this.current != 8) {
            this.reportError("semicolon");
        } else {
            this.next();
        }
    }

    private void getMedia(List<String> result) {
        String media = this.scanner.getStringValue();
        result.add(media);
        if (media.equalsIgnoreCase("not") || media.equalsIgnoreCase("only")) {
            this.nextIgnoreSpaces();
            media = this.scanner.getStringValue();
            result.add(media);
        }
    }

    private List<String> parseMediaList() {
        ArrayList<String> result = new ArrayList<String>();
        this.getMedia(result);
        this.nextIgnoreSpaces();
        block3: while (this.current == 6) {
            this.nextIgnoreSpaces();
            result.add(",");
            switch (this.current) {
                default: {
                    this.reportError("identifier");
                    continue block3;
                }
                case 20: 
            }
            this.getMedia(result);
            this.nextIgnoreSpaces();
        }
        return result;
    }

    private void parseFontFaceRule() {
        try {
            this.documentHandler.startFontFace();
            if (this.current != 1) {
                this.reportError("left.curly.brace");
            } else {
                this.nextIgnoreSpaces();
                try {
                    this.parseStyleDeclaration(true);
                }
                catch (CSSParseException e) {
                    this.reportError(e);
                }
            }
        }
        finally {
            this.documentHandler.endFontFace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePageRule() {
        String page = null;
        String ppage = null;
        if (this.current == 20) {
            page = this.scanner.getStringValue();
            this.nextIgnoreSpaces();
            if (this.current == 16) {
                this.nextIgnoreSpaces();
                if (this.current != 20) {
                    this.reportError("identifier");
                    return;
                }
                ppage = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
            }
        }
        try {
            this.documentHandler.startPage(page, ppage);
            if (this.current != 1) {
                this.reportError("left.curly.brace");
            } else {
                this.nextIgnoreSpaces();
                try {
                    this.parseStyleDeclaration(true);
                }
                catch (CSSParseException e) {
                    this.reportError(e);
                }
            }
        }
        finally {
            this.documentHandler.endPage(page, ppage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void parseMediaRule() {
        if (this.current != 20) {
            this.reportError("identifier");
            return;
        }
        ml = this.parseMediaList();
        sb = new StringBuilder();
        sign = false;
        isFun = false;
        block10: while (true) {
            isFun = false;
            switch (this.current) {
                case 52: {
                    isFun = true;
                }
                case 20: {
                    if (!"and".equalsIgnoreCase(this.scanner.getStringValue())) break block10;
                    if ((isFun || this.nextIgnoreSpaces() == 14) && this.nextIgnoreSpaces() == 20) {
                        id = this.scanner.getStringValue();
                        if (this.nextIgnoreSpaces() == 16) {
                            this.nextIgnoreSpaces();
                            term = this.parseTerm(null);
                            if (this.current == 15) {
                                if (sign) {
                                    sb.append(' ');
                                }
                                sb.append("and (").append(id).append(" : ").append(this.lexicalValueToString(term)).append(")");
                                sign = true;
                                this.nextIgnoreSpaces();
                                continue block10;
                            } else {
                                ** GOTO lbl31
                            }
                        } else {
                            ** GOTO lbl31
                        }
                    } else {
                        ** GOTO lbl31
                    }
                }
            }
            break;
        }
lbl31:
        // 8 sources

        if (sb.length() > 0) {
            ml.add(sb.toString());
        }
        try {
            this.documentHandler.startMedia(ml);
            if (this.current != 1) {
                this.reportError("left.curly.brace");
            } else {
                this.nextIgnoreSpaces();
                block11: while (true) {
                    switch (this.current) {
                        case 0: 
                        case 2: {
                            break block11;
                        }
                        default: {
                            this.parseRuleSet();
                            continue block11;
                        }
                    }
                    break;
                }
                this.nextIgnoreSpaces();
            }
        }
        finally {
            this.documentHandler.endMedia(ml);
        }
    }

    private String lexicalValueToString(LexicalUnit lu) {
        switch (lu.getLexicalUnitType()) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                return lu.getFloatValue() + lu.getDimensionUnitText();
            }
            case 13: {
                return String.valueOf(lu.getIntegerValue());
            }
            case 14: {
                return String.valueOf(lu.getFloatValue());
            }
            case 35: 
            case 36: {
                String value = lu.getStringValue();
                return value;
            }
            case 27: {
                int color = 0;
                LexicalUnit param = lu.getParameters();
                color |= param.getIntegerValue() << 16;
                param = param.getNextLexicalUnit();
                param = param.getNextLexicalUnit();
                color |= param.getIntegerValue() << 8;
                param = param.getNextLexicalUnit();
                param = param.getNextLexicalUnit();
                color |= param.getIntegerValue();
                String val = Integer.toHexString(color &= 0xFFFFFF);
                if (val.length() >= 6) {
                    return "#" + val;
                }
                return "#000000".substring(0, 7 - val.length()) + val;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseRuleSet() {
        List<CSSSelector> sl = null;
        do {
            try {
                sl = this.parseSelectorList();
            }
            catch (Exception e) {
                try {
                    this.scanner.nextRightCurlyBrace();
                }
                catch (IOException e1) {
                    this.reportError(e1.getMessage());
                }
                sl = null;
            }
        } while (sl == null && this.current != -1);
        try {
            this.documentHandler.startSelector(sl);
            if (this.current != 1) {
                this.reportError("left.curly.brace");
                if (this.current == 2) {
                    this.nextIgnoreSpaces();
                }
            } else {
                this.nextIgnoreSpaces();
                try {
                    this.parseStyleDeclaration(true);
                }
                catch (CSSParseException e) {
                    this.reportError(e);
                }
            }
        }
        finally {
            this.documentHandler.endSelector(sl);
        }
    }

    private List<CSSSelector> parseSelectorList() {
        ArrayList<CSSSelector> result = new ArrayList<CSSSelector>();
        result.add(this.parseSelector());
        while (this.current == 6) {
            this.nextIgnoreSpaces();
            result.add(this.parseSelector());
        }
        return result;
    }

    private CSSSelector parseSelector() {
        this.pseudoElement = null;
        CSSSelector result = this.parseSimpleSelector();
        block6: while (true) {
            switch (this.current) {
                default: {
                    break block6;
                }
                case 7: 
                case 11: 
                case 13: 
                case 16: 
                case 20: 
                case 27: {
                    if (this.pseudoElement != null) {
                        throw this.createCSSParseException("pseudo.element.position");
                    }
                    result = new CSSDescendantSelector(result, this.parseSimpleSelector());
                    continue block6;
                }
                case 4: {
                    if (this.pseudoElement != null) {
                        throw this.createCSSParseException("pseudo.element.position");
                    }
                    this.nextIgnoreSpaces();
                    result = new CSSDirectAdjacentSelector(1, result, this.parseSimpleSelector());
                    continue block6;
                }
                case 9: {
                    if (this.pseudoElement != null) {
                        throw this.createCSSParseException("pseudo.element.position");
                    }
                    this.nextIgnoreSpaces();
                    result = new CSSChildSelector(result, this.parseSimpleSelector());
                }
                case 60: {
                    if (this.pseudoElement != null) {
                        throw this.createCSSParseException("pseudo.element.position");
                    }
                    this.nextIgnoreSpaces();
                    result = new CSSBrotherSelector(result, this.parseSimpleSelector());
                    continue block6;
                }
            }
            break;
        }
        if (this.pseudoElement != null) {
            result = new CSSChildSelector(result, new CSSPseudoElementSelector(null, this.pseudoElement));
        }
        return result;
    }

    private CSSSelector parseSimpleSelector() {
        CSSSelector result;
        switch (this.current) {
            case 20: {
                result = new CSSElementSelector(null, this.scanner.getStringValue());
                this.next();
                break;
            }
            case 13: {
                this.next();
            }
            default: {
                result = new CSSElementSelector(null, null);
            }
        }
        CSSCondition cond = null;
        block32: while (true) {
            CSSCondition c = null;
            block4 : switch (this.current) {
                case 27: {
                    c = new CSSIdCondition(this.scanner.getStringValue());
                    this.next();
                    break;
                }
                case 7: {
                    if (this.next() != 20) {
                        throw this.createCSSParseException("identifier");
                    }
                    c = new CSSClassCondition(null, this.scanner.getStringValue());
                    this.next();
                    break;
                }
                case 11: {
                    if (this.nextIgnoreSpaces() != 20) {
                        throw this.createCSSParseException("identifier");
                    }
                    String name = this.scanner.getStringValue();
                    int op = this.nextIgnoreSpaces();
                    switch (op) {
                        default: {
                            throw this.createCSSParseException("right.bracket");
                        }
                        case 12: {
                            this.nextIgnoreSpaces();
                            c = new CSSAttributeCondition(name, null, false, null);
                            break block4;
                        }
                        case 3: 
                        case 25: 
                        case 26: 
                    }
                    String val = null;
                    switch (this.nextIgnoreSpaces()) {
                        default: {
                            throw this.createCSSParseException("identifier.or.string");
                        }
                        case 19: 
                        case 20: 
                    }
                    val = this.scanner.getStringValue();
                    this.nextIgnoreSpaces();
                    if (this.current != 12) {
                        throw this.createCSSParseException("right.bracket");
                    }
                    this.next();
                    switch (op) {
                        case 3: {
                            c = new CSSAttributeCondition(name, null, false, val);
                            break block4;
                        }
                        case 26: {
                            c = new CSSOneOfAttributeCondition(name, null, false, val);
                            break block4;
                        }
                        case 57: {
                            c = new CSSStartWithAttributeCondition(name, null, false, val);
                            break block4;
                        }
                        case 58: {
                            c = new CSSEndWithAttributeCondition(name, null, false, val);
                            break block4;
                        }
                        case 59: {
                            c = new CSSIndexOfAttributeCondition(name, null, false, val);
                            break block4;
                        }
                    }
                    c = new CSSBeginHyphenAttributeCondition(name, null, false, val);
                    break;
                }
                case 16: {
                    String val;
                    switch (this.nextIgnoreSpaces()) {
                        case 20: {
                            val = this.scanner.getStringValue();
                            if (this.isPseudoElement(val)) {
                                if (this.pseudoElement != null) {
                                    throw this.createCSSParseException("duplicate.pseudo.element");
                                }
                                this.pseudoElement = val;
                            } else {
                                c = new CSSPseudoClassCondition(null, val);
                            }
                            this.next();
                            break block4;
                        }
                        case 52: {
                            String func = this.scanner.getStringValue();
                            this.nextIgnoreSpaces();
                            int paraType = 0;
                            String para = null;
                            switch (this.current) {
                                case 24: {
                                    paraType = 1;
                                    para = this.scanner.getStringValue();
                                    this.nextIgnoreSpaces();
                                    break;
                                }
                                case 20: {
                                    paraType = 2;
                                    para = this.scanner.getStringValue();
                                    this.nextIgnoreSpaces();
                                    break;
                                }
                                default: {
                                    paraType = 3;
                                    para = this.parseSimpleSelector().toString();
                                }
                            }
                            if (this.current != 15) {
                                throw this.createCSSParseException("right.brace");
                            }
                            if (paraType == 1) {
                                c = new CSSPseudoNumCondition(func, para);
                            } else if (paraType == 2) {
                                if (!func.equalsIgnoreCase("lang")) {
                                    throw this.createCSSParseException("pseudo.function");
                                }
                                c = new CSSLangCondition(para);
                            } else if (paraType == 3) {
                                c = new CSSPseudoSelectorCondition(func, para);
                            }
                            this.next();
                            break block4;
                        }
                    }
                    throw this.createCSSParseException("identifier");
                }
                default: {
                    break block32;
                }
            }
            if (c == null) continue;
            if (cond == null) {
                cond = c;
                continue;
            }
            cond = new CSSAndCondition(cond, c);
        }
        this.skipSpaces();
        if (cond != null) {
            result = new CSSConditionalSelector(result, cond);
        }
        return result;
    }

    private boolean isPseudoElement(String s) {
        switch (s.charAt(0)) {
            case 'A': 
            case 'a': {
                return s.equalsIgnoreCase("after");
            }
            case 'B': 
            case 'b': {
                return s.equalsIgnoreCase("before");
            }
            case 'F': 
            case 'f': {
                return s.equalsIgnoreCase("first-letter") || s.equalsIgnoreCase("first-line");
            }
        }
        return false;
    }

    private void parseStyleDeclaration(boolean inSheet) throws CSSException {
        block9: while (true) {
            switch (this.current) {
                case 0: {
                    if (inSheet) {
                        throw this.createCSSParseException("eof");
                    }
                    return;
                }
                case 2: {
                    if (!inSheet) {
                        throw this.createCSSParseException("eof.expected");
                    }
                    this.nextIgnoreSpaces();
                    return;
                }
                case 8: {
                    this.nextIgnoreSpaces();
                    continue block9;
                }
                default: {
                    throw this.createCSSParseException("identifier");
                }
                case 55: {
                    this.parseFilter();
                    continue block9;
                }
                case 20: 
            }
            String name = this.scanner.getStringValue();
            if (this.nextIgnoreSpaces() != 16) {
                throw this.createCSSParseException("colon");
            }
            this.nextIgnoreSpaces();
            LexicalUnit exp = null;
            try {
                exp = this.parseExpression(false);
            }
            catch (CSSParseException e) {
                this.reportError(e);
            }
            if (exp == null) continue;
            boolean important = false;
            if (this.current == 23) {
                important = true;
                this.nextIgnoreSpaces();
            }
            this.documentHandler.property(name, exp, important);
        }
    }

    private void parseFilter() throws CSSException {
        StringBuilder filter = new StringBuilder();
        if (this.nextIgnoreSpaces() != 16) {
            throw this.createCSSParseException("filter.colon");
        }
        this.nextIgnoreSpaces();
        if (this.current == 20) {
            filter.append(this.scanner.getStringValue());
            if (this.nextIgnoreSpaces() != 16) {
                throw this.createCSSParseException("filter.colon");
            }
            filter.append(": ");
            while (this.nextIgnoreSpaces() == 20) {
                filter.append(this.scanner.getStringValue());
                if (this.nextIgnoreSpaces() != 7) {
                    throw this.createCSSParseException("filter.type");
                }
                filter.append('.');
            }
        }
        if (this.current != 52) {
            throw this.createCSSParseException("filter.type");
        }
        filter.append(this.scanner.getStringValue()).append('(');
        this.nextIgnoreSpaces();
        this.parseFilterParameter(filter);
        while (this.current == 6) {
            this.nextIgnoreSpaces();
            filter.append(", ");
            this.parseFilterParameter(filter);
        }
        if (this.current != 15) {
            throw this.createCSSParseException("filter.right.brace");
        }
        this.nextIgnoreSpaces();
        filter.append("); ");
        this.documentHandler.filterSymbol(filter.toString());
    }

    private void parseFilterParameter(StringBuilder para) throws CSSException {
        block0 : switch (this.current) {
            case 24: 
            case 54: {
                para.append(this.scanner.getStringValue());
                this.nextIgnoreSpaces();
                break;
            }
            case 20: {
                para.append(this.scanner.getStringValue());
                if (this.nextIgnoreSpaces() != 3) {
                    throw this.createCSSParseException("filter.parameter");
                }
                para.append("=");
                this.nextIgnoreSpaces();
                switch (this.current) {
                    default: {
                        throw this.createCSSParseException("filter.parameter");
                    }
                    case 19: {
                        para.append(this.scanner.getStringWithQuotation());
                        this.nextIgnoreSpaces();
                        break block0;
                    }
                    case 24: 
                    case 54: 
                }
                para.append(this.scanner.getStringValue());
                this.nextIgnoreSpaces();
            }
        }
    }

    private LexicalUnit parseExpression(boolean param) {
        LexicalUnit result;
        LexicalUnit curr = result = this.parseTerm(null);
        while (true) {
            boolean op = false;
            switch (this.current) {
                case 6: {
                    op = true;
                    curr = CSSLexicalUnit.createSimple((short)0, curr);
                    this.nextIgnoreSpaces();
                    break;
                }
                case 10: {
                    op = true;
                    curr = CSSLexicalUnit.createSimple((short)4, curr);
                    this.nextIgnoreSpaces();
                }
            }
            if (param) {
                if (this.current == 15) {
                    if (op) {
                        throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
                    }
                    return result;
                }
                curr = this.parseTerm(curr);
                continue;
            }
            switch (this.current) {
                case 0: 
                case 2: 
                case 8: 
                case 23: {
                    if (op) {
                        throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
                    }
                    return result;
                }
            }
            curr = this.parseTerm(curr);
        }
    }

    private LexicalUnit parseTerm(LexicalUnit prev) {
        boolean plus = true;
        boolean sgn = false;
        switch (this.current) {
            case 5: {
                plus = false;
            }
            case 4: {
                this.next();
                sgn = true;
            }
        }
        switch (this.current) {
            case 24: {
                long lVal;
                String sval = this.scanner.getStringValue();
                if (!plus) {
                    sval = "-" + sval;
                }
                if ((lVal = Long.parseLong(sval)) >= Integer.MIN_VALUE && lVal <= Integer.MAX_VALUE) {
                    int iVal = (int)lVal;
                    this.nextIgnoreSpaces();
                    return CSSLexicalUnit.createInteger(iVal, prev);
                }
            }
            case 54: {
                return CSSLexicalUnit.createFloat((short)14, this.number(plus), prev);
            }
            case 42: {
                return CSSLexicalUnit.createFloat((short)23, this.number(plus), prev);
            }
            case 45: {
                return CSSLexicalUnit.createFloat((short)21, this.number(plus), prev);
            }
            case 44: {
                return CSSLexicalUnit.createFloat((short)22, this.number(plus), prev);
            }
            case 46: {
                return CSSLexicalUnit.createFloat((short)17, this.number(plus), prev);
            }
            case 37: {
                return CSSLexicalUnit.createFloat((short)19, this.number(plus), prev);
            }
            case 38: {
                return CSSLexicalUnit.createFloat((short)20, this.number(plus), prev);
            }
            case 39: {
                return CSSLexicalUnit.createFloat((short)18, this.number(plus), prev);
            }
            case 36: {
                return CSSLexicalUnit.createFloat((short)15, this.number(plus), prev);
            }
            case 35: {
                return CSSLexicalUnit.createFloat((short)16, this.number(plus), prev);
            }
            case 47: {
                return CSSLexicalUnit.createFloat((short)28, this.number(plus), prev);
            }
            case 48: {
                return CSSLexicalUnit.createFloat((short)30, this.number(plus), prev);
            }
            case 49: {
                return CSSLexicalUnit.createFloat((short)29, this.number(plus), prev);
            }
            case 43: {
                return CSSLexicalUnit.createFloat((short)32, this.number(plus), prev);
            }
            case 40: {
                return CSSLexicalUnit.createFloat((short)31, this.number(plus), prev);
            }
            case 41: {
                return CSSLexicalUnit.createFloat((short)33, this.number(plus), prev);
            }
            case 50: {
                return CSSLexicalUnit.createFloat((short)34, this.number(plus), prev);
            }
            case 34: {
                return this.dimension(plus, prev);
            }
            case 52: {
                return this.parseFunction(plus, prev);
            }
        }
        if (sgn) {
            throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
        }
        switch (this.current) {
            case 19: {
                String val = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
                return CSSLexicalUnit.createString((short)36, val, prev);
            }
            case 20: {
                String val = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
                if (val.equalsIgnoreCase("inherit")) {
                    return CSSLexicalUnit.createSimple((short)12, prev);
                }
                return CSSLexicalUnit.createString((short)35, val, prev);
            }
            case 51: {
                String val = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
                return CSSLexicalUnit.createString((short)24, val, prev);
            }
            case 56: {
                String val = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
                return CSSLexicalUnit.createString((short)10001, val, prev);
            }
            case 27: {
                return this.hexcolor(prev);
            }
        }
        throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
    }

    private LexicalUnit parseFunction(boolean positive, LexicalUnit prev) {
        String name = this.scanner.getStringValue();
        this.nextIgnoreSpaces();
        LexicalUnit params = this.parseExpression(true);
        if (this.current != 15) {
            throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
        }
        this.nextIgnoreSpaces();
        block0 : switch (name.charAt(0)) {
            case 'R': 
            case 'r': {
                LexicalUnit lu;
                if (name.equalsIgnoreCase("rgb")) {
                    LexicalUnit lu2 = params;
                    if (lu2 == null) break;
                    switch (lu2.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 13: 
                        case 23: 
                    }
                    lu2 = lu2.getNextLexicalUnit();
                    if (lu2 == null) break;
                    switch (lu2.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 0: 
                    }
                    lu2 = lu2.getNextLexicalUnit();
                    if (lu2 == null) break;
                    switch (lu2.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 13: 
                        case 23: 
                    }
                    lu2 = lu2.getNextLexicalUnit();
                    if (lu2 == null) break;
                    switch (lu2.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 0: 
                    }
                    lu2 = lu2.getNextLexicalUnit();
                    if (lu2 == null) break;
                    switch (lu2.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 13: 
                        case 23: 
                    }
                    lu2 = lu2.getNextLexicalUnit();
                    if (lu2 != null) break;
                    return CSSLexicalUnit.createPredefinedFunction((short)27, params, prev);
                }
                if (!name.equalsIgnoreCase("rect") || (lu = params) == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 13: {
                        if (lu.getIntegerValue() != 0) break block0;
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    case 35: {
                        if (!lu.getStringValue().equalsIgnoreCase("auto")) break block0;
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        lu = lu.getNextLexicalUnit();
                    }
                }
                if (lu == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 0: 
                }
                lu = lu.getNextLexicalUnit();
                if (lu == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 13: {
                        if (lu.getIntegerValue() != 0) break block0;
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    case 35: {
                        if (!lu.getStringValue().equalsIgnoreCase("auto")) break block0;
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        lu = lu.getNextLexicalUnit();
                    }
                }
                if (lu == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 0: 
                }
                lu = lu.getNextLexicalUnit();
                if (lu == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 13: {
                        if (lu.getIntegerValue() != 0) break block0;
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    case 35: {
                        if (!lu.getStringValue().equalsIgnoreCase("auto")) break block0;
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        lu = lu.getNextLexicalUnit();
                    }
                }
                if (lu == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 0: 
                }
                lu = lu.getNextLexicalUnit();
                if (lu == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 13: {
                        if (lu.getIntegerValue() != 0) break block0;
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    case 35: {
                        if (!lu.getStringValue().equalsIgnoreCase("auto")) break block0;
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        lu = lu.getNextLexicalUnit();
                    }
                }
                if (lu != null) break;
                return CSSLexicalUnit.createPredefinedFunction((short)38, params, prev);
            }
            case 'C': 
            case 'c': {
                LexicalUnit lu;
                if (name.equalsIgnoreCase("counter")) {
                    LexicalUnit lu3 = params;
                    if (lu3 == null) break;
                    switch (lu3.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 35: 
                    }
                    lu3 = lu3.getNextLexicalUnit();
                    if (lu3 == null) break;
                    switch (lu3.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 0: 
                    }
                    lu3 = lu3.getNextLexicalUnit();
                    if (lu3 == null) break;
                    switch (lu3.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 35: 
                    }
                    lu3 = lu3.getNextLexicalUnit();
                    if (lu3 != null) break;
                    return CSSLexicalUnit.createPredefinedFunction((short)25, params, prev);
                }
                if (!name.equalsIgnoreCase("counters") || (lu = params) == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 35: 
                }
                lu = lu.getNextLexicalUnit();
                if (lu == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 0: 
                }
                lu = lu.getNextLexicalUnit();
                if (lu == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 36: 
                }
                lu = lu.getNextLexicalUnit();
                if (lu == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 0: 
                }
                lu = lu.getNextLexicalUnit();
                if (lu == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 35: 
                }
                lu = lu.getNextLexicalUnit();
                if (lu != null) break;
                return CSSLexicalUnit.createPredefinedFunction((short)26, params, prev);
            }
            case 'A': 
            case 'a': {
                LexicalUnit lu;
                if (!name.equalsIgnoreCase("attr") || (lu = params) == null) break;
                switch (lu.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 35: 
                }
                lu = lu.getNextLexicalUnit();
                if (lu != null) break;
                return CSSLexicalUnit.createString((short)37, params.getStringValue(), prev);
            }
        }
        return CSSLexicalUnit.createFunction(name, params, prev);
    }

    private LexicalUnit hexcolor(LexicalUnit prev) {
        String val = this.scanner.getStringValue();
        int len = val.length();
        CSSLexicalUnit params = null;
        switch (len) {
            case 3: {
                char rc = Character.toLowerCase(val.charAt(0));
                char gc = Character.toLowerCase(val.charAt(1));
                char bc = Character.toLowerCase(val.charAt(2));
                if (!(CSSScannerUtilities.isCSSHexadecimalCharacter(rc) && CSSScannerUtilities.isCSSHexadecimalCharacter(gc) && CSSScannerUtilities.isCSSHexadecimalCharacter(bc))) {
                    throw this.createCSSParseException("rgb.color", new Object[]{val});
                }
                int t = rc >= '0' && rc <= '9' ? rc - 48 : rc - 97 + 10;
                int r = t;
                r |= (t <<= 4);
                t = gc >= '0' && gc <= '9' ? gc - 48 : gc - 97 + 10;
                int g = t;
                t = bc >= '0' && bc <= '9' ? bc - 48 : bc - 97 + 10;
                int b = t;
                params = CSSLexicalUnit.createInteger(r, null);
                CSSLexicalUnit tmp = CSSLexicalUnit.createSimple((short)0, params);
                tmp = CSSLexicalUnit.createInteger(g |= (t <<= 4), tmp);
                tmp = CSSLexicalUnit.createSimple((short)0, tmp);
                tmp = CSSLexicalUnit.createInteger(b |= (t <<= 4), tmp);
                break;
            }
            case 6: {
                char rc1 = Character.toLowerCase(val.charAt(0));
                char rc2 = Character.toLowerCase(val.charAt(1));
                char gc1 = Character.toLowerCase(val.charAt(2));
                char gc2 = Character.toLowerCase(val.charAt(3));
                char bc1 = Character.toLowerCase(val.charAt(4));
                char bc2 = Character.toLowerCase(val.charAt(5));
                if (!(CSSScannerUtilities.isCSSHexadecimalCharacter(rc1) && CSSScannerUtilities.isCSSHexadecimalCharacter(rc2) && CSSScannerUtilities.isCSSHexadecimalCharacter(gc1) && CSSScannerUtilities.isCSSHexadecimalCharacter(gc2) && CSSScannerUtilities.isCSSHexadecimalCharacter(bc1) && CSSScannerUtilities.isCSSHexadecimalCharacter(bc2))) {
                    throw this.createCSSParseException("rgb.color");
                }
                int r = rc1 >= '0' && rc1 <= '9' ? rc1 - 48 : rc1 - 97 + 10;
                r <<= 4;
                r |= rc2 >= '0' && rc2 <= '9' ? rc2 - 48 : rc2 - 97 + 10;
                int g = gc1 >= '0' && gc1 <= '9' ? gc1 - 48 : gc1 - 97 + 10;
                g <<= 4;
                g |= gc2 >= '0' && gc2 <= '9' ? gc2 - 48 : gc2 - 97 + 10;
                int b = bc1 >= '0' && bc1 <= '9' ? bc1 - 48 : bc1 - 97 + 10;
                b <<= 4;
                int n = bc2 >= '0' && bc2 <= '9' ? bc2 - 48 : bc2 - 97 + 10;
                params = CSSLexicalUnit.createInteger(r, null);
                CSSLexicalUnit tmp = CSSLexicalUnit.createSimple((short)0, params);
                tmp = CSSLexicalUnit.createInteger(g, tmp);
                tmp = CSSLexicalUnit.createSimple((short)0, tmp);
                tmp = CSSLexicalUnit.createInteger(b |= n, tmp);
                break;
            }
            default: {
                throw this.createCSSParseException("rgb.color", new Object[]{val});
            }
        }
        this.nextIgnoreSpaces();
        return CSSLexicalUnit.createPredefinedFunction((short)27, params, prev);
    }

    private CSSScanner createScanner(InputSource source) throws UnsupportedEncodingException {
        Reader r;
        this.documentURI = source.getURI();
        if (this.documentURI == null) {
            this.documentURI = "";
        }
        if ((r = source.getCharacterStream()) != null) {
            this.reader = new CSSStreamReader(r);
            return new CSSScanner(this.reader);
        }
        InputStream is = source.getByteStream();
        if (is != null) {
            this.reader = new CSSStreamReader(is, source.getEncoding());
            return new CSSScanner(this.reader);
        }
        String uri = source.getURI();
        if (uri == null) {
            throw new CSSException(MessageFormat.format("empty.source", ""));
        }
        try {
            ParsedURL purl = new ParsedURL(uri);
            is = purl.openStreamRaw("text/css");
            this.reader = new CSSStreamReader(is, source.getEncoding());
            return new CSSScanner(this.reader);
        }
        catch (IOException e) {
            throw new CSSException(e);
        }
    }

    private int skipSpaces() {
        int lex = this.scanner.getType();
        while (lex == 17) {
            lex = this.next();
        }
        return lex;
    }

    private int skipSpacesAndCDOCDC() {
        block3: while (true) {
            switch (this.current) {
                default: {
                    break block3;
                }
                case 17: 
                case 18: 
                case 21: 
                case 22: {
                    this.scanner.clearBuffer();
                    this.next();
                    continue block3;
                }
            }
            break;
        }
        return this.current;
    }

    private float number(boolean positive) {
        try {
            float sgn = positive ? 1.0f : -1.0f;
            String val = this.scanner.getStringValue();
            this.nextIgnoreSpaces();
            return sgn * Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            throw this.createCSSParseException("number.format");
        }
    }

    private LexicalUnit dimension(boolean positive, LexicalUnit prev) {
        try {
            int i;
            float sgn = positive ? 1.0f : -1.0f;
            String val = this.scanner.getStringValue();
            block5: for (i = 0; i < val.length(); ++i) {
                switch (val.charAt(i)) {
                    default: {
                        break block5;
                    }
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        continue block5;
                    }
                }
            }
            this.nextIgnoreSpaces();
            return CSSLexicalUnit.createDimension(sgn * Float.parseFloat(val.substring(0, i)), val.substring(i), prev);
        }
        catch (NumberFormatException e) {
            throw this.createCSSParseException("number.format");
        }
    }

    private int next() {
        try {
            while (true) {
                this.scanner.clearBuffer();
                this.current = this.scanner.next();
                if (this.current != 18) break;
                this.documentHandler.comment(this.scanner.getStringValue());
            }
            return this.current;
        }
        catch (CSSParseException e) {
            this.reportError(e.getMessage());
            return this.current;
        }
    }

    private int nextIgnoreSpaces() {
        try {
            block6: while (true) {
                this.scanner.clearBuffer();
                this.current = this.scanner.next();
                switch (this.current) {
                    case 18: {
                        this.documentHandler.comment(this.scanner.getStringValue());
                        continue block6;
                    }
                    default: {
                        break block6;
                    }
                    case 17: {
                        continue block6;
                    }
                }
                break;
            }
            return this.current;
        }
        catch (CSSParseException e) {
            this.errorHandler.error(this.createCSSParseException(e.getMessage()));
            return this.current;
        }
    }

    private void reportError(String key) {
        this.reportError(key, null);
    }

    private void reportError(String key, Object[] params) {
        this.reportError(this.createCSSParseException(key, params));
    }

    private void reportError(CSSParseException e) {
        this.errorHandler.error(e);
        int cbraces = 1;
        while (true) {
            switch (this.current) {
                case 0: {
                    return;
                }
                case 2: 
                case 8: {
                    if (--cbraces == 0) {
                        this.nextIgnoreSpaces();
                        return;
                    }
                }
                case 1: {
                    ++cbraces;
                }
            }
            this.nextIgnoreSpaces();
        }
    }

    private CSSParseException createCSSParseException(String key) {
        return this.createCSSParseException(key, null);
    }

    private CSSParseException createCSSParseException(String key, Object[] params) {
        return new CSSParseException(MessageFormat.format(key, params), this.documentURI, this.scanner.getLine(), this.scanner.getColumn());
    }

    public void parseStyleDeclaration(String source) throws CSSException, IOException {
        try (CSSStringReader reader = new CSSStringReader(source);){
            this.scanner = new CSSScanner(reader);
            this.parseStyleDeclarationInternal();
        }
    }

    public void parseRule(String source) throws CSSException, IOException {
        try (CSSStringReader reader = new CSSStringReader(source);){
            this.scanner = new CSSScanner(reader);
            this.parseRuleInternal();
        }
    }

    public List<CSSSelector> parseSelectors(String source) throws CSSException, IOException {
        try (CSSStringReader reader = new CSSStringReader(source);){
            this.scanner = new CSSScanner(reader);
            List<CSSSelector> list = this.parseSelectorsInternal();
            return list;
        }
    }

    public LexicalUnit parsePropertyValue(String source) throws CSSException, IOException {
        try (CSSStringReader reader = new CSSStringReader(source);){
            this.scanner = new CSSScanner(reader);
            LexicalUnit lexicalUnit = this.parsePropertyValueInternal();
            return lexicalUnit;
        }
    }

    public boolean parsePriority(String source) throws CSSException, IOException {
        try (CSSStringReader reader = new CSSStringReader(source);){
            this.scanner = new CSSScanner(reader);
            boolean bl = this.parsePriorityInternal();
            return bl;
        }
    }

    public List<String> parseMedia(String mediaText) throws CSSException, IOException {
        ArrayList<String> result = new ArrayList<String>();
        if (!"all".equalsIgnoreCase(mediaText)) {
            StringTokenizer st = new StringTokenizer(mediaText, " ,");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
        }
        return result;
    }
}

