/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.resource.impl;

import com.alibaba.securitysdk.logging.circuitbreaker.CircuitBreakerMonitor;
import com.alibaba.securitysdk.logging.circuitbreaker.breaker.CompositeCircuitBreaker;
import com.alibaba.securitysdk.logging.utils.filewatch.FileWatchEventListener;
import com.alibaba.securitysdk.logging.utils.filewatch.FileWatchExistsException;
import com.alibaba.securitysdk.logging.utils.filewatch.FileWatcher;
import com.alibaba.securitysdk.logging.utils.filewatch.FileWatcherHelper;
import com.alibaba.securitysdk.logging.utils.filewatch.FileWatcherManager;
import com.alibaba.securitysdk.resource.FileResourceLoader;
import com.alibaba.securitysdk.resource.SwappableResource;
import com.alibaba.securitysdk.resource.config.ConfigLoader;
import com.alibaba.securitysdk.resource.exception.ResourceLoadingException;
import com.alibaba.securitysdk.resource.exception.ResourceSwapException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class WatchableFileResource<R>
implements SwappableResource<R> {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Path filepath;
    private Path watchingPath;
    protected boolean recursive = true;
    private boolean enableCircuitBreaking;
    private CompositeCircuitBreaker circuitBreaker;
    private FileWatchEventListener fileWatchEventListener;
    protected FileResourceLoader<R> resourceLoader;

    public WatchableFileResource(FileResourceLoader<R> loader) {
        this(loader, true);
    }

    public WatchableFileResource(FileResourceLoader<R> loader, boolean enableCircuitBreaking) {
        this.enableCircuitBreaking = enableCircuitBreaking;
        this.resourceLoader = loader;
        this.filepath = this.resourceLoader.getLocation();
        this.fileWatchEventListener = new SwappableFileWatchEventListener();
        this.circuitBreaker = CircuitBreakerMonitor.INSTANCE.getCircuitBreaker();
    }

    public Path locate() {
        return this.filepath;
    }

    @Override
    public void initialize(R r) throws ResourceSwapException {
        if (!ConfigLoader.loadResourceConfig().isAutoLoadingEnabled()) {
            return;
        }
        this.decideWatchingPath();
        CircuitBreakerMonitor.INSTANCE.start();
        try {
            FileWatcher fileWatcher = FileWatcherManager.INSTANCE.createFileWatcher(this.watchingPath, this.recursive, new FileWatchEventListener[]{this.fileWatchEventListener});
            fileWatcher.start();
            this.logger.log(Level.INFO, "The WatchableFileResource {0} is now running.", this.filepath);
        }
        catch (IOException e) {
            throw new ResourceSwapException("Error when swap resource " + this.filepath, e);
        }
        catch (FileWatchExistsException ex) {
            throw new ResourceSwapException(ex.getMessage(), ex);
        }
    }

    private void decideWatchingPath() throws ResourceSwapException {
        File file = this.filepath.toFile();
        if (file.exists()) {
            this.watchingPath = file.isDirectory() ? this.filepath : this.filepath.getParent();
        } else {
            File parentFile = file.getParentFile();
            if (parentFile.exists() && parentFile.isDirectory()) {
                this.watchingPath = this.filepath.getParent();
            } else {
                throw new ResourceSwapException("The file [" + this.filepath + "] not exists.");
            }
        }
    }

    private boolean watchingDirectory() {
        return this.filepath == this.watchingPath;
    }

    FileWatchEventListener getFileWatchEventListener() {
        return this.fileWatchEventListener;
    }

    void setFileWatchEventListener(FileWatchEventListener fileWatchEventListener) {
        this.fileWatchEventListener = fileWatchEventListener;
    }

    private class SwappableFileWatchEventListener
    implements FileWatchEventListener {
        private SwappableFileWatchEventListener() {
        }

        private void swap(WatchKey watchKey, WatchEvent event) {
            block6: {
                if (!WatchableFileResource.this.enableCircuitBreaking || WatchableFileResource.this.circuitBreaker.checkState()) {
                    Path eventPath = FileWatcherHelper.resolvePath((WatchKey)watchKey, (WatchEvent)event);
                    if (WatchableFileResource.this.watchingDirectory() || eventPath.equals(WatchableFileResource.this.filepath)) {
                        try {
                            WatchableFileResource.this.swap(WatchableFileResource.this.resourceLoader.load(FileWatcherHelper.resolvePath((WatchKey)watchKey, (WatchEvent)event)));
                        }
                        catch (ResourceSwapException e) {
                            if (WatchableFileResource.this.logger.isLoggable(Level.WARNING)) {
                                WatchableFileResource.this.logger.log(Level.WARNING, "Error when swapping resource " + watchKey.watchable(), e);
                            }
                        }
                        catch (ResourceLoadingException e) {
                            if (!WatchableFileResource.this.logger.isLoggable(Level.WARNING)) break block6;
                            WatchableFileResource.this.logger.log(Level.WARNING, "Error when loading resource " + watchKey.watchable(), e);
                        }
                    }
                }
            }
        }

        public void onDeleteEvent(WatchKey watchKey, WatchEvent event) {
        }

        public void onModifyEvent(WatchKey watchKey, WatchEvent event) {
            this.swap(watchKey, event);
        }

        public void onCreateEvent(WatchKey watchKey, WatchEvent event) {
            this.swap(watchKey, event);
        }
    }
}

