/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.resource.impl;

import com.alibaba.securitysdk.logging.utils.filelock.FailedLockingFileException;
import com.alibaba.securitysdk.logging.utils.filelock.FileLocker;
import com.alibaba.securitysdk.resource.FileResourceLoader;
import com.alibaba.securitysdk.resource.exception.ResourceLoadingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class LockableResourceLoader<R>
implements FileResourceLoader<R> {
    private static Logger logger = Logger.getLogger(LockableResourceLoader.class.getName());
    private boolean needLock;

    public LockableResourceLoader(boolean needLock) {
        this.needLock = needLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R load(Path path) throws ResourceLoadingException {
        if (this.needLock && path != null && Files.exists(path.toAbsolutePath(), new LinkOption[0])) {
            R r;
            FileLocker fileLocker = null;
            try {
                fileLocker = new FileLocker(path.toAbsolutePath().toFile());
                fileLocker.tryLock(true);
                r = this.load0(path);
            }
            catch (FailedLockingFileException e) {
                logger.log(Level.WARNING, e.toString(), e);
                R r2 = this.emptyResource();
                return r2;
            }
            finally {
                if (fileLocker != null) {
                    try {
                        fileLocker.unLock();
                    }
                    catch (FailedLockingFileException ignored) {}
                }
            }
            return r;
        }
        return this.load0(path);
    }

    protected abstract R emptyResource();

    protected abstract R load0(Path var1) throws ResourceLoadingException;
}

