/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.javax.xml.transform.stax;

import com.alibaba.securitysdk.javax.xml.stream.XMLEventReader;
import com.alibaba.securitysdk.javax.xml.stream.XMLStreamException;
import com.alibaba.securitysdk.javax.xml.stream.XMLStreamReader;
import com.alibaba.securitysdk.javax.xml.stream.events.XMLEvent;
import com.alibaba.securitysdk.javax.xml.transform.Source;

public class StAXSource
implements Source {
    public static final String FEATURE = "http://javax.xml.transform.stax.StAXSource/feature";
    private final XMLStreamReader xmlStreamReader;
    private final XMLEventReader xmlEventReader;
    private final String systemId;

    public StAXSource(XMLStreamReader xmlStreamReader) {
        if (xmlStreamReader == null) {
            throw new IllegalArgumentException("XMLStreamReader cannot be null.");
        }
        int event = xmlStreamReader.getEventType();
        if (event != 7 && event != 1) {
            throw new IllegalStateException("The state of the XMLStreamReader must be START_DOCUMENT or START_ELEMENT");
        }
        this.xmlStreamReader = xmlStreamReader;
        this.xmlEventReader = null;
        this.systemId = xmlStreamReader.getLocation().getSystemId();
    }

    public StAXSource(XMLEventReader xmlEventReader) throws XMLStreamException {
        if (xmlEventReader == null) {
            throw new IllegalArgumentException("XMLEventReader cannot be null.");
        }
        XMLEvent event = xmlEventReader.peek();
        if (!event.isStartDocument() && !event.isStartElement()) {
            throw new IllegalStateException("The state of the XMLEventReader must be START_DOCUMENT or START_ELEMENT");
        }
        this.xmlStreamReader = null;
        this.xmlEventReader = xmlEventReader;
        this.systemId = event.getLocation().getSystemId();
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.xmlStreamReader;
    }

    public XMLEventReader getXMLEventReader() {
        return this.xmlEventReader;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(String systemId) {
        throw new UnsupportedOperationException("Setting systemId is not supported.");
    }
}

