/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.standard.service;

import com.aliyun.dataworks.migrationx.domain.dataworks.standard.service.Code;

public class Result<T> {
    private String code;
    private Boolean success;
    private T data;
    private Integer errCode;
    private String errMsg;
    private String requestId;

    public static Result ofError(String msg, Integer errCode) {
        return Result.of(msg, errCode, null, false);
    }

    public static Result ofError(String msg, Integer code, String sessionId) {
        return Result.of(msg, code, null, false, sessionId);
    }

    public static Result ofErrorWithCode(String msg, String code) {
        return Result.ofWithCode(msg, Code.ERROR.code, null, false, code);
    }

    public static Result ofError(String msg) {
        return Result.of(msg, Code.ERROR.code, null, false);
    }

    public static Result ofError(String msg, String sessionId) {
        return Result.of(msg, Code.ERROR.code, null, false, sessionId);
    }

    public static <T> Result<T> ofSuccess(T data) {
        return Result.of(null, Code.SUCCESS.code, data, true);
    }

    public static <T> Result<T> ofSuccess(Integer errCode, T data) {
        return Result.of(null, errCode, data, true);
    }

    public static <T> Result<T> of(String msg, Integer code, T data, Boolean success) {
        Result<T> result = new Result<T>();
        result.setErrMsg(msg).setSuccess(success).setData(data).setErrCode(code);
        return result;
    }

    public static <T> Result<T> ofWithCode(String msg, Integer errCode, T data, Boolean success, String code) {
        Result<T> result = new Result<T>();
        result.setErrMsg(msg).setSuccess(success).setData(data).setCode(code).setErrCode(errCode);
        return result;
    }

    public static <T> Result<T> of(String msg, Integer code, T data, Boolean success, String requestId) {
        Result<T> result = Result.of(msg, code, data, success).setRequestId(requestId);
        return result;
    }

    public String getCode() {
        return this.code;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public T getData() {
        return this.data;
    }

    public Integer getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Result<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public Result<T> setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public Result<T> setData(T data) {
        this.data = data;
        return this;
    }

    public Result<T> setErrCode(Integer errCode) {
        this.errCode = errCode;
        return this;
    }

    public Result<T> setErrMsg(String errMsg) {
        this.errMsg = errMsg;
        return this;
    }

    public Result<T> setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", success=" + this.getSuccess() + ", data=" + this.getData() + ", errCode=" + this.getErrCode() + ", errMsg=" + this.getErrMsg() + ", requestId=" + this.getRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        Integer this$errCode = this.getErrCode();
        Integer other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !((Object)this$errCode).equals(other$errCode)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        Integer $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : ((Object)$errCode).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }
}

